/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class UCompactIntArray
implements Cloneable {
    private static final int PLANEMASK = 196608;
    private static final int PLANESHIFT = 16;
    private static final int PLANECOUNT = 16;
    private static final int CODEPOINTMASK = 65535;
    private static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int defaultValue;
    private int[][] values = new int[16][];
    private short[][] indices = new short[16][];
    private boolean isCompact;
    private boolean[][] blockTouched = new boolean[16][];
    private boolean[] planeTouched = new boolean[16];

    public UCompactIntArray() {
    }

    public UCompactIntArray(int defaultValue) {
        this();
        this.defaultValue = defaultValue;
    }

    public int elementAt(int index) {
        int plane = (index & 0x30000) >> 16;
        if (!this.planeTouched[plane]) {
            return this.defaultValue;
        }
        return this.values[plane][(this.indices[plane][(index &= 0xFFFF) >> 7] & 0xFFFF) + (index & 0x7F)];
    }

    public void setElementAt(int index, int value) {
        int plane;
        if (this.isCompact) {
            this.expand();
        }
        if (!this.planeTouched[plane = (index & 0x30000) >> 16]) {
            this.initPlane(plane);
        }
        this.values[plane][index &= 0xFFFF] = value;
        this.blockTouched[plane][index >> 7] = true;
    }

    public void compact() {
        if (this.isCompact) {
            return;
        }
        for (int plane = 0; plane < 16; ++plane) {
            if (!this.planeTouched[plane]) continue;
            int limitCompacted = 0;
            int iBlockStart = 0;
            int iUntouched = -1;
            int i = 0;
            while (i < this.indices[plane].length) {
                this.indices[plane][i] = -1;
                if (!this.blockTouched[plane][i] && iUntouched != -1) {
                    this.indices[plane][i] = iUntouched;
                } else {
                    int jBlockStart = limitCompacted * 128;
                    if (i > limitCompacted) {
                        System.arraycopy(this.values[plane], iBlockStart, this.values[plane], jBlockStart, 128);
                    }
                    if (!this.blockTouched[plane][i]) {
                        iUntouched = (short)jBlockStart;
                    }
                    this.indices[plane][i] = (short)jBlockStart;
                    ++limitCompacted;
                }
                ++i;
                iBlockStart += 128;
            }
            int newSize = limitCompacted * 128;
            int[] result = new int[newSize];
            System.arraycopy(this.values[plane], 0, result, 0, newSize);
            this.values[plane] = result;
            this.blockTouched[plane] = null;
        }
        this.isCompact = true;
    }

    private void expand() {
        if (this.isCompact) {
            for (int plane = 0; plane < 16; ++plane) {
                int i;
                if (!this.planeTouched[plane]) continue;
                this.blockTouched[plane] = new boolean[512];
                int[] tempArray = new int[65536];
                for (i = 0; i < 65536; ++i) {
                    tempArray[i] = this.values[plane][this.indices[plane][i >> 7] & 65535 + (i & 0x7F)];
                    this.blockTouched[plane][i >> 7] = true;
                }
                for (i = 0; i < 512; ++i) {
                    this.indices[plane][i] = (short)(i << 7);
                }
                this.values[plane] = tempArray;
            }
            this.isCompact = false;
        }
    }

    private void initPlane(int plane) {
        int i;
        this.values[plane] = new int[65536];
        this.indices[plane] = new short[512];
        this.blockTouched[plane] = new boolean[512];
        this.planeTouched[plane] = true;
        if (this.planeTouched[0] && plane != 0) {
            System.arraycopy(this.indices[0], 0, this.indices[plane], 0, 512);
        } else {
            for (i = 0; i < 512; ++i) {
                this.indices[plane][i] = (short)(i << 7);
            }
        }
        for (i = 0; i < 65536; ++i) {
            this.values[plane][i] = this.defaultValue;
        }
    }

    public int getKSize() {
        int size = 0;
        for (int plane = 0; plane < 16; ++plane) {
            if (!this.planeTouched[plane]) continue;
            size += this.values[plane].length * 4 + this.indices[plane].length * 2;
        }
        return size / 1024;
    }
}

