/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import javax.management.loading.MLet;

class MLetObjectInputStream
extends ObjectInputStream {
    private MLet loader;

    public MLetObjectInputStream(InputStream in, MLet loader) throws IOException, StreamCorruptedException {
        super(in);
        if (loader == null) {
            throw new IllegalArgumentException("Illegal null argument to MLetObjectInputStream");
        }
        this.loader = loader;
    }

    private Class<?> primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectstreamclass) throws IOException, ClassNotFoundException {
        String s = objectstreamclass.getName();
        if (s.startsWith("[")) {
            Class<?> class1;
            int i = 1;
            while (s.charAt(i) == '[') {
                ++i;
            }
            if (s.charAt(i) == 'L') {
                class1 = this.loader.loadClass(s.substring(i + 1, s.length() - 1));
            } else {
                if (s.length() != i + 1) {
                    throw new ClassNotFoundException(s);
                }
                class1 = this.primitiveType(s.charAt(i));
            }
            int[] ai = new int[i];
            for (int j = 0; j < i; ++j) {
                ai[j] = 0;
            }
            return Array.newInstance(class1, ai).getClass();
        }
        return this.loader.loadClass(s);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

