/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.ColorData;
import sun.awt.X11.Native;
import sun.awt.X11.XRenderPictFormat;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11.awtImageData;
import sun.misc.Unsafe;

public class AwtGraphicsConfigData
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 208;
    }

    @Override
    public int getDataSize() {
        return AwtGraphicsConfigData.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public AwtGraphicsConfigData(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public AwtGraphicsConfigData() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(AwtGraphicsConfigData.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_awt_depth() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_awt_depth(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public long get_awt_cmap() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_awt_cmap(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public XVisualInfo get_awt_visInfo() {
        log.finest("");
        return new XVisualInfo(this.pData + 16L);
    }

    public int get_awt_num_colors() {
        log.finest("");
        return Native.getInt(this.pData + 80L);
    }

    public void set_awt_num_colors(int v) {
        log.finest("");
        Native.putInt(this.pData + 80L, v);
    }

    public awtImageData get_awtImage(int index) {
        log.finest("");
        return Native.getLong(this.pData + 88L) != 0L ? new awtImageData(Native.getLong(this.pData + 88L) + (long)(index * 560)) : null;
    }

    public long get_awtImage() {
        log.finest("");
        return Native.getLong(this.pData + 88L);
    }

    public void set_awtImage(long v) {
        log.finest("");
        Native.putLong(this.pData + 88L, v);
    }

    public long get_AwtColorMatch(int index) {
        log.finest("");
        return Native.getLong(this.pData + 96L) + (long)(index * Native.getLongSize());
    }

    public long get_AwtColorMatch() {
        log.finest("");
        return Native.getLong(this.pData + 96L);
    }

    public void set_AwtColorMatch(long v) {
        log.finest("");
        Native.putLong(this.pData + 96L, v);
    }

    public long get_monoImage(int index) {
        log.finest("");
        return Native.getLong(this.pData + 104L) + (long)(index * Native.getLongSize());
    }

    public long get_monoImage() {
        log.finest("");
        return Native.getLong(this.pData + 104L);
    }

    public void set_monoImage(long v) {
        log.finest("");
        Native.putLong(this.pData + 104L, v);
    }

    public long get_monoPixmap() {
        log.finest("");
        return Native.getLong(this.pData + 112L);
    }

    public void set_monoPixmap(long v) {
        log.finest("");
        Native.putLong(this.pData + 112L, v);
    }

    public int get_monoPixmapWidth() {
        log.finest("");
        return Native.getInt(this.pData + 120L);
    }

    public void set_monoPixmapWidth(int v) {
        log.finest("");
        Native.putInt(this.pData + 120L, v);
    }

    public int get_monoPixmapHeight() {
        log.finest("");
        return Native.getInt(this.pData + 124L);
    }

    public void set_monoPixmapHeight(int v) {
        log.finest("");
        Native.putInt(this.pData + 124L, v);
    }

    public long get_monoPixmapGC() {
        log.finest("");
        return Native.getLong(this.pData + 128L);
    }

    public void set_monoPixmapGC(long v) {
        log.finest("");
        Native.putLong(this.pData + 128L, v);
    }

    public int get_pixelStride() {
        log.finest("");
        return Native.getInt(this.pData + 136L);
    }

    public void set_pixelStride(int v) {
        log.finest("");
        Native.putInt(this.pData + 136L, v);
    }

    public ColorData get_color_data(int index) {
        log.finest("");
        return Native.getLong(this.pData + 144L) != 0L ? new ColorData(Native.getLong(this.pData + 144L) + (long)(index * 88)) : null;
    }

    public long get_color_data() {
        log.finest("");
        return Native.getLong(this.pData + 144L);
    }

    public void set_color_data(long v) {
        log.finest("");
        Native.putLong(this.pData + 144L, v);
    }

    public long get_glxInfo(int index) {
        log.finest("");
        return Native.getLong(this.pData + 152L) + (long)(index * Native.getLongSize());
    }

    public long get_glxInfo() {
        log.finest("");
        return Native.getLong(this.pData + 152L);
    }

    public void set_glxInfo(long v) {
        log.finest("");
        Native.putLong(this.pData + 152L, v);
    }

    public int get_isTranslucencySupported() {
        log.finest("");
        return Native.getInt(this.pData + 160L);
    }

    public void set_isTranslucencySupported(int v) {
        log.finest("");
        Native.putInt(this.pData + 160L, v);
    }

    public XRenderPictFormat get_renderPictFormat() {
        log.finest("");
        return new XRenderPictFormat(this.pData + 168L);
    }

    @Override
    String getName() {
        return "AwtGraphicsConfigData";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(640);
        ret.append("awt_depth = ").append(this.get_awt_depth()).append(", ");
        ret.append("awt_cmap = ").append(this.get_awt_cmap()).append(", ");
        ret.append("awt_visInfo = ").append(this.get_awt_visInfo()).append(", ");
        ret.append("awt_num_colors = ").append(this.get_awt_num_colors()).append(", ");
        ret.append("awtImage = ").append(this.get_awtImage()).append(", ");
        ret.append("AwtColorMatch = ").append(this.get_AwtColorMatch()).append(", ");
        ret.append("monoImage = ").append(this.get_monoImage()).append(", ");
        ret.append("monoPixmap = ").append(this.get_monoPixmap()).append(", ");
        ret.append("monoPixmapWidth = ").append(this.get_monoPixmapWidth()).append(", ");
        ret.append("monoPixmapHeight = ").append(this.get_monoPixmapHeight()).append(", ");
        ret.append("monoPixmapGC = ").append(this.get_monoPixmapGC()).append(", ");
        ret.append("pixelStride = ").append(this.get_pixelStride()).append(", ");
        ret.append("color_data = ").append(this.get_color_data()).append(", ");
        ret.append("glxInfo = ").append(this.get_glxInfo()).append(", ");
        ret.append("isTranslucencySupported = ").append(this.get_isTranslucencySupported()).append(", ");
        ret.append("renderPictFormat = ").append(this.get_renderPictFormat()).append(", ");
        return ret.toString();
    }
}

