/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.util.ArrayList;
import java.util.Vector;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.Native;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XPopupMenuPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.java2d.SurfaceData;
import sun.util.logging.PlatformLogger;

public abstract class XBaseMenuWindow
extends XWindow {
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XBaseMenuWindow");
    private Color backgroundColor;
    private Color foregroundColor;
    private Color lightShadowColor;
    private Color darkShadowColor;
    private Color selectedColor;
    private Color disabledColor;
    private ArrayList<XMenuItemPeer> items;
    private int selectedIndex = -1;
    private XMenuPeer showingSubmenu = null;
    private static Object menuTreeLock = new Object();
    private XMenuPeer showingMousePressedSubmenu = null;
    protected Point grabInputPoint = null;
    protected boolean hasPointerMoved = false;
    private MappingData mappingData;

    XBaseMenuWindow() {
        super(new XCreateWindowParams(new Object[]{"delayed", Boolean.TRUE}));
    }

    protected abstract XBaseMenuWindow getParentMenuWindow();

    protected abstract MappingData map();

    protected abstract Rectangle getSubmenuBounds(Rectangle var1, Dimension var2);

    protected abstract void updateSize();

    @Override
    void instantPreInit(XCreateWindowParams params) {
        super.instantPreInit(params);
        this.items = new ArrayList();
    }

    static Object getMenuTreeLock() {
        return menuTreeLock;
    }

    protected void resetMapping() {
        this.mappingData = null;
    }

    void postPaintEvent() {
        if (this.isShowing()) {
            PaintEvent pe = new PaintEvent(this.target, 800, new Rectangle(0, 0, this.width, this.height));
            this.postEvent(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer getItem(int index) {
        if (index >= 0) {
            Object object = XBaseMenuWindow.getMenuTreeLock();
            synchronized (object) {
                if (this.items.size() > index) {
                    return this.items.get(index);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer[] copyItems() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            return this.items.toArray(new XMenuItemPeer[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer getSelectedItem() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            if (this.selectedIndex >= 0 && this.items.size() > this.selectedIndex) {
                return this.items.get(this.selectedIndex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuPeer getShowingSubmenu() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            return this.showingSubmenu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(MenuItem item) {
        XMenuItemPeer mp = (XMenuItemPeer)item.getPeer();
        if (mp != null) {
            mp.setContainer(this);
            Object object = XBaseMenuWindow.getMenuTreeLock();
            synchronized (object) {
                this.items.add(mp);
            }
        } else if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WARNING: Attempt to add menu item without a peer");
        }
        this.updateSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delItem(int index) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            if (this.selectedIndex == index) {
                this.selectItem(null, false);
            } else if (this.selectedIndex > index) {
                --this.selectedIndex;
            }
            if (index < this.items.size()) {
                this.items.remove(index);
            } else if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("WARNING: Attempt to remove non-existing menu item, index : " + index + ", item count : " + this.items.size());
            }
        }
        this.updateSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadItems(Vector items) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            this.items.clear();
            MenuItem[] itemArray = items.toArray(new MenuItem[0]);
            int itemCnt = itemArray.length;
            for (int i = 0; i < itemCnt; ++i) {
                this.addItem(itemArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectItem(XMenuItemPeer item, boolean showWindowIfMenu) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            XMenuPeer submenuToShow;
            int newSelectedIndex;
            XMenuPeer showingSubmenu = this.getShowingSubmenu();
            int n = newSelectedIndex = item != null ? this.items.indexOf(item) : -1;
            if (this.selectedIndex != newSelectedIndex) {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("Selected index changed, was : " + this.selectedIndex + ", new : " + newSelectedIndex);
                }
                this.selectedIndex = newSelectedIndex;
                this.postPaintEvent();
            }
            XMenuPeer xMenuPeer = submenuToShow = showWindowIfMenu && item instanceof XMenuPeer ? (XMenuPeer)item : null;
            if (submenuToShow != showingSubmenu) {
                XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                    @Override
                    public void run() {
                        XBaseMenuWindow.this.doShowSubmenu(submenuToShow);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowSubmenu(XMenuPeer submenuToShow) {
        XMenuWindow menuWindowToShow = submenuToShow != null ? submenuToShow.getMenuWindow() : null;
        Dimension dim = null;
        Rectangle bounds = null;
        if (menuWindowToShow != null) {
            menuWindowToShow.ensureCreated();
        }
        XToolkit.awtLock();
        try {
            Object object = XBaseMenuWindow.getMenuTreeLock();
            synchronized (object) {
                if (this.showingSubmenu != submenuToShow) {
                    XMenuWindow showingSubmenuWindow;
                    if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                        log.finest("Changing showing submenu");
                    }
                    if (this.showingSubmenu != null && (showingSubmenuWindow = this.showingSubmenu.getMenuWindow()) != null) {
                        showingSubmenuWindow.hide();
                    }
                    if (submenuToShow != null) {
                        dim = menuWindowToShow.getDesiredSize();
                        bounds = menuWindowToShow.getParentMenuWindow().getSubmenuBounds(submenuToShow.getBounds(), dim);
                        menuWindowToShow.show(bounds);
                    }
                    this.showingSubmenu = submenuToShow;
                }
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    final void setItemsFont(Font font) {
        XMenuItemPeer[] items = this.copyItems();
        int itemCnt = items.length;
        for (int i = 0; i < itemCnt; ++i) {
            items[i].setFont(font);
        }
    }

    MappingData getMappingData() {
        MappingData mappingData = this.mappingData;
        if (mappingData == null) {
            this.mappingData = mappingData = this.map();
        }
        return (MappingData)mappingData.clone();
    }

    XMenuItemPeer getItemFromPoint(Point pt) {
        XMenuItemPeer[] items = this.getMappingData().getItems();
        int cnt = items.length;
        for (int i = 0; i < cnt; ++i) {
            if (!items[i].getBounds().contains(pt)) continue;
            return items[i];
        }
        return null;
    }

    XMenuItemPeer getNextSelectableItem() {
        XMenuItemPeer[] mappedItems = this.getMappingData().getItems();
        XMenuItemPeer selectedItem = this.getSelectedItem();
        int cnt = mappedItems.length;
        int selIdx = -1;
        for (int i = 0; i < cnt; ++i) {
            if (mappedItems[i] != selectedItem) continue;
            selIdx = i;
            break;
        }
        int idx = selIdx == cnt - 1 ? 0 : selIdx + 1;
        for (int i = 0; i < cnt; ++i) {
            XMenuItemPeer item = mappedItems[idx];
            if (!item.isSeparator() && item.isTargetItemEnabled()) {
                return item;
            }
            if (++idx < cnt) continue;
            idx = 0;
        }
        return null;
    }

    XMenuItemPeer getPrevSelectableItem() {
        XMenuItemPeer[] mappedItems = this.getMappingData().getItems();
        XMenuItemPeer selectedItem = this.getSelectedItem();
        int cnt = mappedItems.length;
        int selIdx = -1;
        for (int i = 0; i < cnt; ++i) {
            if (mappedItems[i] != selectedItem) continue;
            selIdx = i;
            break;
        }
        int idx = selIdx <= 0 ? cnt - 1 : selIdx - 1;
        for (int i = 0; i < cnt; ++i) {
            XMenuItemPeer item = mappedItems[idx];
            if (!item.isSeparator() && item.isTargetItemEnabled()) {
                return item;
            }
            if (--idx >= 0) continue;
            idx = cnt - 1;
        }
        return null;
    }

    XMenuItemPeer getFirstSelectableItem() {
        for (XMenuItemPeer item : this.getMappingData().getItems()) {
            if (item.isSeparator() || !item.isTargetItemEnabled()) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XBaseMenuWindow getShowingLeaf() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            XBaseMenuWindow leaf = this;
            XMenuPeer leafchild = leaf.getShowingSubmenu();
            while (leafchild != null) {
                leaf = leafchild.getMenuWindow();
                leafchild = leaf.getShowingSubmenu();
            }
            return leaf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XBaseMenuWindow getRootMenuWindow() {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            XBaseMenuWindow t = this;
            XBaseMenuWindow tparent = t.getParentMenuWindow();
            while (tparent != null) {
                t = tparent;
                tparent = t.getParentMenuWindow();
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XBaseMenuWindow getMenuWindowFromPoint(Point pt) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            for (XBaseMenuWindow t = this.getShowingLeaf(); t != null; t = t.getParentMenuWindow()) {
                Rectangle r = new Rectangle(t.toGlobal(new Point(0, 0)), t.getSize());
                if (!r.contains(pt)) continue;
                return t;
            }
            return null;
        }
    }

    Rectangle fitWindowBelow(Rectangle itemBounds, Dimension windowSize, Dimension screenSize) {
        int y;
        int width = windowSize.width;
        int height = windowSize.height;
        int x = itemBounds.x > 0 ? itemBounds.x : 0;
        int n = y = itemBounds.y + itemBounds.height > 0 ? itemBounds.y + itemBounds.height : 0;
        if (y + height <= screenSize.height) {
            if (width > screenSize.width) {
                width = screenSize.width;
            }
            if (x + width > screenSize.width) {
                x = screenSize.width - width;
            }
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    Rectangle fitWindowAbove(Rectangle itemBounds, Dimension windowSize, Dimension screenSize) {
        int y;
        int width = windowSize.width;
        int height = windowSize.height;
        int x = itemBounds.x > 0 ? itemBounds.x : 0;
        int n = y = itemBounds.y > screenSize.height ? screenSize.height - height : itemBounds.y - height;
        if (y >= 0) {
            if (width > screenSize.width) {
                width = screenSize.width;
            }
            if (x + width > screenSize.width) {
                x = screenSize.width - width;
            }
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    Rectangle fitWindowRight(Rectangle itemBounds, Dimension windowSize, Dimension screenSize) {
        int y;
        int width = windowSize.width;
        int height = windowSize.height;
        int x = itemBounds.x + itemBounds.width > 0 ? itemBounds.x + itemBounds.width : 0;
        int n = y = itemBounds.y > 0 ? itemBounds.y : 0;
        if (x + width <= screenSize.width) {
            if (height > screenSize.height) {
                height = screenSize.height;
            }
            if (y + height > screenSize.height) {
                y = screenSize.height - height;
            }
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    Rectangle fitWindowLeft(Rectangle itemBounds, Dimension windowSize, Dimension screenSize) {
        int y;
        int width = windowSize.width;
        int height = windowSize.height;
        int x = itemBounds.x < screenSize.width ? itemBounds.x - width : screenSize.width - width;
        int n = y = itemBounds.y > 0 ? itemBounds.y : 0;
        if (x >= 0) {
            if (height > screenSize.height) {
                height = screenSize.height;
            }
            if (y + height > screenSize.height) {
                y = screenSize.height - height;
            }
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    Rectangle fitWindowToScreen(Dimension windowSize, Dimension screenSize) {
        int width = windowSize.width < screenSize.width ? windowSize.width : screenSize.width;
        int height = windowSize.height < screenSize.height ? windowSize.height : screenSize.height;
        return new Rectangle(0, 0, width, height);
    }

    void resetColors() {
        this.replaceColors(this.target == null ? SystemColor.window : this.target.getBackground());
    }

    void replaceColors(Color backgroundColor) {
        if (backgroundColor != this.backgroundColor) {
            this.backgroundColor = backgroundColor;
            int red = backgroundColor.getRed();
            int green = backgroundColor.getGreen();
            int blue = backgroundColor.getBlue();
            this.foregroundColor = new Color(MotifColorUtilities.calculateForegroundFromBackground(red, green, blue));
            this.lightShadowColor = new Color(MotifColorUtilities.calculateTopShadowFromBackground(red, green, blue));
            this.darkShadowColor = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(red, green, blue));
            this.selectedColor = new Color(MotifColorUtilities.calculateSelectFromBackground(red, green, blue));
            this.disabledColor = backgroundColor.equals(Color.BLACK) ? this.foregroundColor.darker() : backgroundColor.darker();
        }
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    Color getForegroundColor() {
        return this.foregroundColor;
    }

    Color getLightShadowColor() {
        return this.lightShadowColor;
    }

    Color getDarkShadowColor() {
        return this.darkShadowColor;
    }

    Color getSelectedColor() {
        return this.selectedColor;
    }

    Color getDisabledColor() {
        return this.disabledColor;
    }

    void draw3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Color c = g.getColor();
        g.setColor(raised ? this.getLightShadowColor() : this.getDarkShadowColor());
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 1, y);
        g.setColor(raised ? this.getDarkShadowColor() : this.getLightShadowColor());
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        g.setColor(c);
    }

    @Override
    protected boolean isEventDisabled(XEvent e) {
        switch (e.get_type()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 17: {
                return super.isEventDisabled(e);
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        this.setDisposed(true);
        InvocationEvent ev = new InvocationEvent((Object)this.target, new Runnable(){

            @Override
            public void run() {
                XBaseMenuWindow.this.doDispose();
            }
        });
        super.postEvent(ev);
    }

    protected void doDispose() {
        this.xSetVisible(false);
        SurfaceData oldData = this.surfaceData;
        this.surfaceData = null;
        if (oldData != null) {
            oldData.invalidate();
        }
        XToolkit.targetDisposedPeer(this.target, this);
        this.destroy();
    }

    @Override
    void postEvent(final AWTEvent event) {
        InvocationEvent ev = new InvocationEvent(event.getSource(), new Runnable(){

            @Override
            public void run() {
                XBaseMenuWindow.this.handleEvent(event);
            }
        });
        super.postEvent(ev);
    }

    protected void handleEvent(AWTEvent event) {
        switch (event.getID()) {
            case 800: {
                this.doHandleJavaPaintEvent((PaintEvent)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grabInput() {
        int rootY;
        int rootX;
        boolean res;
        XToolkit.awtLock();
        try {
            long root = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
            res = XlibWrapper.XQueryPointer(XToolkit.getDisplay(), root, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
            rootX = Native.getInt(XlibWrapper.larg3);
            rootY = Native.getInt(XlibWrapper.larg4);
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (res &= super.grabInput()) {
            this.grabInputPoint = new Point(rootX, rootY);
            this.hasPointerMoved = false;
        } else {
            this.grabInputPoint = null;
            this.hasPointerMoved = true;
        }
        return res;
    }

    void doHandleJavaPaintEvent(PaintEvent event) {
        Rectangle rect = event.getUpdateRect();
        this.repaint(rect.x, rect.y, rect.width, rect.height);
    }

    void doHandleJavaMouseEvent(MouseEvent mouseEvent) {
        XBaseMenuWindow wnd;
        if (!XToolkit.isLeftMouseButton(mouseEvent) && !XToolkit.isRightMouseButton(mouseEvent)) {
            return;
        }
        XBaseWindow grabWindow = XAwtState.getGrabWindow();
        Point ptGlobal = mouseEvent.getLocationOnScreen();
        if (!(this.hasPointerMoved || this.grabInputPoint != null && Math.abs(ptGlobal.x - this.grabInputPoint.x) <= XBaseMenuWindow.getMouseMovementSmudge() && Math.abs(ptGlobal.y - this.grabInputPoint.y) <= XBaseMenuWindow.getMouseMovementSmudge())) {
            this.hasPointerMoved = true;
        }
        XMenuItemPeer item = (wnd = this.getMenuWindowFromPoint(ptGlobal)) != null ? wnd.getItemFromPoint(wnd.toLocal(ptGlobal)) : null;
        XBaseMenuWindow cwnd = this.getShowingLeaf();
        switch (mouseEvent.getID()) {
            case 501: {
                this.showingMousePressedSubmenu = null;
                if (grabWindow == this && wnd == null) {
                    XBaseMenuWindow.ungrabInput();
                    break;
                }
                this.grabInput();
                if (item != null && !item.isSeparator() && item.isTargetItemEnabled()) {
                    if (wnd.getShowingSubmenu() == item) {
                        this.showingMousePressedSubmenu = (XMenuPeer)item;
                    }
                    wnd.selectItem(item, true);
                    break;
                }
                if (wnd == null) break;
                wnd.selectItem(null, false);
                break;
            }
            case 502: {
                if (item != null && !item.isSeparator() && item.isTargetItemEnabled()) {
                    if (item instanceof XMenuPeer) {
                        if (this.showingMousePressedSubmenu == item) {
                            if (wnd instanceof XMenuBarPeer) {
                                XBaseMenuWindow.ungrabInput();
                            } else {
                                wnd.selectItem(item, false);
                            }
                        }
                    } else {
                        item.action(mouseEvent.getWhen());
                        XBaseMenuWindow.ungrabInput();
                    }
                } else if (this.hasPointerMoved || wnd instanceof XMenuBarPeer) {
                    XBaseMenuWindow.ungrabInput();
                }
                this.showingMousePressedSubmenu = null;
                break;
            }
            case 506: {
                if (wnd != null) {
                    if (item != null && !item.isSeparator() && item.isTargetItemEnabled()) {
                        if (grabWindow != this) break;
                        wnd.selectItem(item, true);
                        break;
                    }
                    wnd.selectItem(null, false);
                    break;
                }
                if (cwnd == null) break;
                cwnd.selectItem(null, false);
            }
        }
    }

    void doHandleJavaKeyEvent(KeyEvent event) {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer(event.toString());
        }
        if (event.getID() != 401) {
            return;
        }
        int keyCode = event.getKeyCode();
        XBaseMenuWindow cwnd = this.getShowingLeaf();
        XMenuItemPeer citem = cwnd.getSelectedItem();
        switch (keyCode) {
            case 38: 
            case 224: {
                if (cwnd instanceof XMenuBarPeer) break;
                cwnd.selectItem(cwnd.getPrevSelectableItem(), false);
                break;
            }
            case 40: 
            case 225: {
                if (cwnd instanceof XMenuBarPeer) {
                    this.selectItem(this.getSelectedItem(), true);
                    break;
                }
                cwnd.selectItem(cwnd.getNextSelectableItem(), false);
                break;
            }
            case 37: 
            case 226: {
                if (cwnd instanceof XMenuBarPeer) {
                    this.selectItem(this.getPrevSelectableItem(), false);
                    break;
                }
                if (cwnd.getParentMenuWindow() instanceof XMenuBarPeer) {
                    this.selectItem(this.getPrevSelectableItem(), true);
                    break;
                }
                XBaseMenuWindow pwnd = cwnd.getParentMenuWindow();
                if (pwnd == null) break;
                pwnd.selectItem(pwnd.getSelectedItem(), false);
                break;
            }
            case 39: 
            case 227: {
                if (cwnd instanceof XMenuBarPeer) {
                    this.selectItem(this.getNextSelectableItem(), false);
                    break;
                }
                if (citem instanceof XMenuPeer) {
                    cwnd.selectItem(citem, true);
                    break;
                }
                if (!(this instanceof XMenuBarPeer)) break;
                this.selectItem(this.getNextSelectableItem(), true);
                break;
            }
            case 10: 
            case 32: {
                if (citem instanceof XMenuPeer) {
                    cwnd.selectItem(citem, true);
                    break;
                }
                if (citem == null) break;
                citem.action(event.getWhen());
                XBaseMenuWindow.ungrabInput();
                break;
            }
            case 27: {
                if (cwnd instanceof XMenuBarPeer || cwnd.getParentMenuWindow() instanceof XMenuBarPeer) {
                    XBaseMenuWindow.ungrabInput();
                    break;
                }
                if (cwnd instanceof XPopupMenuPeer) {
                    XBaseMenuWindow.ungrabInput();
                    break;
                }
                XBaseMenuWindow pwnd = cwnd.getParentMenuWindow();
                pwnd.selectItem(pwnd.getSelectedItem(), false);
                break;
            }
            case 121: {
                XBaseMenuWindow.ungrabInput();
                break;
            }
        }
    }

    static class MappingData
    implements Cloneable {
        private XMenuItemPeer[] items;

        MappingData(XMenuItemPeer[] items) {
            this.items = items;
        }

        MappingData() {
            this.items = new XMenuItemPeer[0];
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public XMenuItemPeer[] getItems() {
            return this.items;
        }
    }
}

