/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    private static Logger log = Logger.getLogger(X509IssuerSerialResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineLookupResolveX509Certificate(element, baseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        }
        X509Data x509data = null;
        try {
            x509data = new X509Data(element, baseURI);
        }
        catch (XMLSignatureException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I can't");
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I can't");
            }
            return null;
        }
        if (!x509data.containsIssuerSerial()) {
            return null;
        }
        try {
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509IssuerSerial"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "", ex);
                }
                throw ex;
            }
            int noOfISS = x509data.lengthIssuerSerial();
            Iterator<Certificate> storageIterator = storage.getIterator();
            while (storageIterator.hasNext()) {
                X509Certificate cert = (X509Certificate)storageIterator.next();
                XMLX509IssuerSerial certSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), cert);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Found Certificate Issuer: " + certSerial.getIssuerName());
                    log.log(Level.FINE, "Found Certificate Serial: " + certSerial.getSerialNumber().toString());
                }
                for (int i = 0; i < noOfISS; ++i) {
                    XMLX509IssuerSerial xmliss = x509data.itemIssuerSerial(i);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Found Element Issuer:     " + xmliss.getIssuerName());
                        log.log(Level.FINE, "Found Element Serial:     " + xmliss.getSerialNumber().toString());
                    }
                    if (certSerial.equals(xmliss)) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "match !!! ");
                        }
                        return cert;
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "XMLSecurityException", ex);
            }
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String baseURI, StorageResolver storage) {
        return null;
    }
}

