/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.corba;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class ServerRequestImpl
extends ServerRequest {
    private ORB _orb = null;
    private ORBUtilSystemException _wrapper = null;
    private String _opName = null;
    private NVList _arguments = null;
    private Context _ctx = null;
    private InputStream _ins = null;
    private boolean _paramsCalled = false;
    private boolean _resultSet = false;
    private boolean _exceptionSet = false;
    private Any _resultAny = null;
    private Any _exception = null;

    public ServerRequestImpl(CorbaMessageMediator req, ORB orb) {
        this._opName = req.getOperationName();
        this._ins = (InputStream)((Object)req.getInputObject());
        this._ctx = null;
        this._orb = orb;
        this._wrapper = ORBUtilSystemException.get(orb, "oa.invocation");
    }

    @Override
    public String operation() {
        return this._opName;
    }

    @Override
    public void arguments(NVList args) {
        if (this._paramsCalled) {
            throw this._wrapper.argumentsCalledMultiple();
        }
        if (this._exceptionSet) {
            throw this._wrapper.argumentsCalledAfterException();
        }
        if (args == null) {
            throw this._wrapper.argumentsCalledNullArgs();
        }
        this._paramsCalled = true;
        NamedValue arg = null;
        for (int i = 0; i < args.count(); ++i) {
            try {
                arg = args.item(i);
            }
            catch (Bounds e) {
                throw this._wrapper.boundsCannotOccur(e);
            }
            try {
                if (arg.flags() != 1 && arg.flags() != 3) continue;
                arg.value().read_value(this._ins, arg.value().type());
                continue;
            }
            catch (Exception ex) {
                throw this._wrapper.badArgumentsNvlist(ex);
            }
        }
        this._arguments = args;
        this._orb.getPIHandler().setServerPIInfo(this._arguments);
        this._orb.getPIHandler().invokeServerPIIntermediatePoint();
    }

    @Override
    public void set_result(Any res) {
        if (!this._paramsCalled) {
            throw this._wrapper.argumentsNotCalled();
        }
        if (this._resultSet) {
            throw this._wrapper.setResultCalledMultiple();
        }
        if (this._exceptionSet) {
            throw this._wrapper.setResultAfterException();
        }
        if (res == null) {
            throw this._wrapper.setResultCalledNullArgs();
        }
        this._resultAny = res;
        this._resultSet = true;
        this._orb.getPIHandler().setServerPIInfo(this._resultAny);
    }

    @Override
    public void set_exception(Any exc) {
        if (exc == null) {
            throw this._wrapper.setExceptionCalledNullArgs();
        }
        TCKind kind = exc.type().kind();
        if (kind != TCKind.tk_except) {
            throw this._wrapper.setExceptionCalledBadType();
        }
        this._exception = exc;
        this._orb.getPIHandler().setServerPIExceptionInfo(this._exception);
        if (!this._exceptionSet && !this._paramsCalled) {
            this._orb.getPIHandler().invokeServerPIIntermediatePoint();
        }
        this._exceptionSet = true;
    }

    public Any checkResultCalled() {
        if (this._paramsCalled && this._resultSet) {
            return null;
        }
        if (this._paramsCalled && !this._resultSet && !this._exceptionSet) {
            try {
                TypeCode result_tc = this._orb.get_primitive_tc(TCKind.tk_void);
                this._resultAny = this._orb.create_any();
                this._resultAny.type(result_tc);
                this._resultSet = true;
                return null;
            }
            catch (Exception ex) {
                throw this._wrapper.dsiResultException(CompletionStatus.COMPLETED_MAYBE, ex);
            }
        }
        if (this._exceptionSet) {
            return this._exception;
        }
        throw this._wrapper.dsimethodNotcalled(CompletionStatus.COMPLETED_MAYBE);
    }

    public void marshalReplyParams(OutputStream os) {
        this._resultAny.write_value(os);
        NamedValue arg = null;
        for (int i = 0; i < this._arguments.count(); ++i) {
            try {
                arg = this._arguments.item(i);
            }
            catch (Bounds bounds) {
                // empty catch block
            }
            if (arg.flags() != 2 && arg.flags() != 3) continue;
            arg.value().write_value(os);
        }
    }

    @Override
    public Context ctx() {
        if (!this._paramsCalled || this._resultSet || this._exceptionSet) {
            throw this._wrapper.contextCalledOutOfOrder();
        }
        throw this._wrapper.contextNotImplemented();
    }
}

