/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.CodePointIterator;

final class CharSequenceCodePointIterator
extends CodePointIterator {
    private CharSequence text;
    private int index;

    public CharSequenceCodePointIterator(CharSequence text) {
        this.text = text;
    }

    @Override
    public void setToStart() {
        this.index = 0;
    }

    @Override
    public void setToLimit() {
        this.index = this.text.length();
    }

    @Override
    public int next() {
        if (this.index < this.text.length()) {
            char cp2;
            char cp1;
            if (Character.isHighSurrogate(cp1 = this.text.charAt(this.index++)) && this.index < this.text.length() && Character.isLowSurrogate(cp2 = this.text.charAt(this.index + 1))) {
                ++this.index;
                return Character.toCodePoint(cp1, cp2);
            }
            return cp1;
        }
        return -1;
    }

    @Override
    public int prev() {
        if (this.index > 0) {
            char cp1;
            char cp2;
            if (Character.isLowSurrogate(cp2 = this.text.charAt(--this.index)) && this.index > 0 && Character.isHighSurrogate(cp1 = this.text.charAt(this.index - 1))) {
                --this.index;
                return Character.toCodePoint(cp1, cp2);
            }
            return cp2;
        }
        return -1;
    }

    @Override
    public int charIndex() {
        return this.index;
    }
}

