/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetUtil;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ServerSocket
implements Closeable {
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private SocketImpl impl;
    private boolean oldImpl = false;
    private static SocketImplFactory factory = null;

    ServerSocket(SocketImpl impl) {
        this.impl = impl;
        impl.setServerSocket(this);
    }

    public ServerSocket() throws IOException {
        this.setImpl();
    }

    public ServerSocket(int port) throws IOException {
        this(port, 50, null);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this.setImpl();
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + port);
        }
        if (backlog < 1) {
            backlog = 50;
        }
        try {
            this.bind(new InetSocketAddress(bindAddr, port), backlog);
        }
        catch (SecurityException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NoSuchMethodException {
                    Class[] cl = new Class[]{SocketAddress.class, Integer.TYPE};
                    ServerSocket.this.impl.getClass().getDeclaredMethod("connect", cl);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.oldImpl = true;
        }
    }

    private void setImpl() {
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new SocksSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setServerSocket(this);
        }
    }

    void createImpl() throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(true);
            this.created = true;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 50);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (endpoint == null) {
            endpoint = new InetSocketAddress(0);
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (backlog < 1) {
            backlog = 50;
        }
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkListen(epoint.getPort());
            }
            this.getImpl().bind(epoint.getAddress(), epoint.getPort());
            this.getImpl().listen(backlog);
            this.bound = true;
        }
        catch (SecurityException e) {
            this.bound = false;
            throw e;
        }
        catch (IOException e) {
            this.bound = false;
            throw e;
        }
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        try {
            SecurityManager sm;
            InetAddress in = this.getImpl().getInetAddress();
            if (!NetUtil.doRevealLocalAddress() && (sm = System.getSecurityManager()) != null) {
                sm.checkConnect(in.getHostAddress(), -1);
            }
            return in;
        }
        catch (SecurityException e) {
            return InetAddress.getLoopbackAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        Socket s = new Socket((SocketImpl)null);
        this.implAccept(s);
        return s;
    }

    protected final void implAccept(Socket s) throws IOException {
        SocketImpl si = null;
        try {
            if (s.impl == null) {
                s.setImpl();
            } else {
                s.impl.reset();
            }
            si = s.impl;
            s.impl = null;
            si.address = new InetAddress();
            si.fd = new FileDescriptor();
            this.getImpl().accept(si);
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkAccept(si.getInetAddress().getHostAddress(), si.getPort());
            }
        }
        catch (IOException e) {
            if (si != null) {
                si.reset();
            }
            s.impl = si;
            throw e;
        }
        catch (SecurityException e) {
            if (si != null) {
                si.reset();
            }
            s.impl = si;
            throw e;
        }
        s.impl = si;
        s.postAccept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4102, new Integer(timeout));
    }

    public synchronized int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, (Object)on);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        InetAddress in = !NetUtil.doRevealLocalAddress() && System.getSecurityManager() != null ? InetAddress.getLoopbackAddress() : this.impl.getInetAddress();
        return "ServerSocket[addr=" + in + ",localport=" + this.impl.getLocalPort() + "]";
    }

    void setBound() {
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        factory = fac;
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(size));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

