/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.SocketOptions;
import java.net.StandardSocketOptions;

public abstract class SocketImpl
implements SocketOptions {
    Socket socket = null;
    ServerSocket serverSocket = null;
    protected FileDescriptor fd;
    protected InetAddress address;
    protected int port;
    protected int localport;

    protected abstract void create(boolean var1) throws IOException;

    protected abstract void connect(String var1, int var2) throws IOException;

    protected abstract void connect(InetAddress var1, int var2) throws IOException;

    protected abstract void connect(SocketAddress var1, int var2) throws IOException;

    protected abstract void bind(InetAddress var1, int var2) throws IOException;

    protected abstract void listen(int var1) throws IOException;

    protected abstract void accept(SocketImpl var1) throws IOException;

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    protected abstract int available() throws IOException;

    protected abstract void close() throws IOException;

    protected void shutdownInput() throws IOException {
        throw new IOException("Method not implemented!");
    }

    protected void shutdownOutput() throws IOException {
        throw new IOException("Method not implemented!");
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected InetAddress getInetAddress() {
        return this.address;
    }

    protected int getPort() {
        return this.port;
    }

    protected boolean supportsUrgentData() {
        return false;
    }

    protected abstract void sendUrgentData(int var1) throws IOException;

    protected int getLocalPort() {
        return this.localport;
    }

    void setSocket(Socket soc) {
        this.socket = soc;
    }

    Socket getSocket() {
        return this.socket;
    }

    void setServerSocket(ServerSocket soc) {
        this.serverSocket = soc;
    }

    ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public String toString() {
        return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
    }

    void reset() throws IOException {
        this.address = null;
        this.port = 0;
        this.localport = 0;
    }

    protected void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    <T> void setOption(SocketOption<T> name, T value) throws IOException {
        if (name == StandardSocketOptions.SO_KEEPALIVE) {
            this.setOption(8, value);
        } else if (name == StandardSocketOptions.SO_SNDBUF) {
            this.setOption(4097, value);
        } else if (name == StandardSocketOptions.SO_RCVBUF) {
            this.setOption(4098, value);
        } else if (name == StandardSocketOptions.SO_REUSEADDR) {
            this.setOption(4, value);
        } else if (name == StandardSocketOptions.SO_LINGER) {
            this.setOption(128, value);
        } else if (name == StandardSocketOptions.IP_TOS) {
            this.setOption(3, value);
        } else if (name == StandardSocketOptions.TCP_NODELAY) {
            this.setOption(1, value);
        } else {
            throw new UnsupportedOperationException("unsupported option");
        }
    }

    <T> T getOption(SocketOption<T> name) throws IOException {
        if (name == StandardSocketOptions.SO_KEEPALIVE) {
            return (T)this.getOption(8);
        }
        if (name == StandardSocketOptions.SO_SNDBUF) {
            return (T)this.getOption(4097);
        }
        if (name == StandardSocketOptions.SO_RCVBUF) {
            return (T)this.getOption(4098);
        }
        if (name == StandardSocketOptions.SO_REUSEADDR) {
            return (T)this.getOption(4);
        }
        if (name == StandardSocketOptions.SO_LINGER) {
            return (T)this.getOption(128);
        }
        if (name == StandardSocketOptions.IP_TOS) {
            return (T)this.getOption(3);
        }
        if (name == StandardSocketOptions.TCP_NODELAY) {
            return (T)this.getOption(1);
        }
        throw new UnsupportedOperationException("unsupported option");
    }
}

