/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;

public final class MediaPrintableArea
implements DocAttribute,
PrintRequestAttribute,
PrintJobAttribute {
    private int x;
    private int y;
    private int w;
    private int h;
    private int units;
    private static final long serialVersionUID = -1597171464050795793L;
    public static final int INCH = 25400;
    public static final int MM = 1000;

    public MediaPrintableArea(float x, float y, float w, float h, int units) {
        if ((double)x < 0.0 || (double)y < 0.0 || (double)w <= 0.0 || (double)h <= 0.0 || units < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.x = (int)(x * (float)units + 0.5f);
        this.y = (int)(y * (float)units + 0.5f);
        this.w = (int)(w * (float)units + 0.5f);
        this.h = (int)(h * (float)units + 0.5f);
    }

    public MediaPrintableArea(int x, int y, int w, int h, int units) {
        if (x < 0 || y < 0 || w <= 0 || h <= 0 || units < 1) {
            throw new IllegalArgumentException("0 or negative value argument");
        }
        this.x = x * units;
        this.y = y * units;
        this.w = w * units;
        this.h = h * units;
    }

    public float[] getPrintableArea(int units) {
        return new float[]{this.getX(units), this.getY(units), this.getWidth(units), this.getHeight(units)};
    }

    public float getX(int units) {
        return MediaPrintableArea.convertFromMicrometers(this.x, units);
    }

    public float getY(int units) {
        return MediaPrintableArea.convertFromMicrometers(this.y, units);
    }

    public float getWidth(int units) {
        return MediaPrintableArea.convertFromMicrometers(this.w, units);
    }

    public float getHeight(int units) {
        return MediaPrintableArea.convertFromMicrometers(this.h, units);
    }

    public boolean equals(Object object) {
        boolean ret = false;
        if (object instanceof MediaPrintableArea) {
            MediaPrintableArea mm = (MediaPrintableArea)object;
            if (this.x == mm.x && this.y == mm.y && this.w == mm.w && this.h == mm.h) {
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public final Class<? extends Attribute> getCategory() {
        return MediaPrintableArea.class;
    }

    @Override
    public final String getName() {
        return "media-printable-area";
    }

    public String toString(int units, String unitsName) {
        if (unitsName == null) {
            unitsName = "";
        }
        float[] vals = this.getPrintableArea(units);
        String str = "(" + vals[0] + "," + vals[1] + ")->(" + vals[2] + "," + vals[3] + ")";
        return str + unitsName;
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public int hashCode() {
        return this.x + 37 * this.y + 43 * this.w + 47 * this.h;
    }

    private static float convertFromMicrometers(int x, int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return (float)x / (float)units;
    }
}

