/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractPoller;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileKey;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class SolarisWatchService
extends AbstractWatchService {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static int addressSize = unsafe.addressSize();
    private static final int SIZEOF_PORT_EVENT = SolarisWatchService.dependsArch(16, 24);
    private static final int OFFSETOF_EVENTS = 0;
    private static final int OFFSETOF_SOURCE = 4;
    private static final int OFFSETOF_OBJECT = 8;
    private static final int SIZEOF_FILEOBJ = SolarisWatchService.dependsArch(40, 80);
    private static final int OFFSET_FO_NAME = SolarisWatchService.dependsArch(36, 72);
    private static final short PORT_SOURCE_USER = 3;
    private static final short PORT_SOURCE_FILE = 7;
    private static final int FILE_MODIFIED = 2;
    private static final int FILE_ATTRIB = 4;
    private static final int FILE_NOFOLLOW = 0x10000000;
    private static final int FILE_DELETE = 16;
    private static final int FILE_RENAME_TO = 32;
    private static final int FILE_RENAME_FROM = 64;
    private static final int UNMOUNTED = 0x20000000;
    private static final int MOUNTEDOVER = 0x40000000;
    private final Poller poller;

    private static int dependsArch(int value32, int value64) {
        return addressSize == 4 ? value32 : value64;
    }

    SolarisWatchService(UnixFileSystem fs) throws IOException {
        int port = -1;
        try {
            port = SolarisWatchService.portCreate();
        }
        catch (UnixException x) {
            throw new IOException(x.errorString());
        }
        this.poller = new Poller(fs, this, port);
        this.poller.start();
    }

    @Override
    WatchKey register(Path dir, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.poller.register(dir, events, modifiers);
    }

    @Override
    void implClose() throws IOException {
        this.poller.close();
    }

    private static native void init();

    private static native int portCreate() throws UnixException;

    private static native void portAssociate(int var0, int var1, long var2, int var4) throws UnixException;

    private static native void portDissociate(int var0, int var1, long var2) throws UnixException;

    private static native void portSend(int var0, int var1) throws UnixException;

    private static native int portGetn(int var0, long var1, int var3) throws UnixException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
        SolarisWatchService.init();
    }

    private static class EntryNode
    implements Node {
        private final long object;
        private final Path name;
        private final DirectoryNode parent;

        EntryNode(long object, Path name, DirectoryNode parent) {
            this.object = object;
            this.name = name;
            this.parent = parent;
        }

        @Override
        public long object() {
            return this.object;
        }

        Path name() {
            return this.name;
        }

        DirectoryNode parent() {
            return this.parent;
        }
    }

    private static interface DirectoryNode
    extends Node {
        public void addChild(Path var1, EntryNode var2);

        public void removeChild(Path var1);

        public EntryNode getChild(Path var1);
    }

    private static interface Node {
        public long object();
    }

    private class Poller
    extends AbstractPoller {
        private static final int MAX_EVENT_COUNT = 128;
        private static final int FILE_REMOVED = 112;
        private static final int FILE_EXCEPTION = 0x60000070;
        private final long bufferAddress;
        private final SolarisWatchService watcher;
        private final int port;
        private final Map<UnixFileKey, SolarisWatchKey> fileKey2WatchKey;
        private final Map<Long, Node> object2Node;

        Poller(UnixFileSystem fs, SolarisWatchService watcher, int port) {
            this.watcher = watcher;
            this.port = port;
            this.bufferAddress = unsafe.allocateMemory(SIZEOF_PORT_EVENT * 128);
            this.fileKey2WatchKey = new HashMap<UnixFileKey, SolarisWatchKey>();
            this.object2Node = new HashMap<Long, Node>();
        }

        @Override
        void wakeup() throws IOException {
            try {
                SolarisWatchService.portSend(this.port, 0);
            }
            catch (UnixException x) {
                throw new IOException(x.errorString());
            }
        }

        @Override
        Object implRegister(Path obj, Set<? extends WatchEvent.Kind<?>> events, WatchEvent.Modifier ... modifiers) {
            if (modifiers.length > 0) {
                for (WatchEvent.Modifier modifier : modifiers) {
                    if (modifier == null) {
                        return new NullPointerException();
                    }
                    if (modifier instanceof SensitivityWatchEventModifier) continue;
                    return new UnsupportedOperationException("Modifier not supported");
                }
            }
            UnixPath dir = (UnixPath)obj;
            UnixFileAttributes attrs = null;
            try {
                attrs = UnixFileAttributes.get(dir, true);
            }
            catch (UnixException x) {
                return x.asIOException(dir);
            }
            if (!attrs.isDirectory()) {
                return new NotDirectoryException(dir.getPathForExceptionMessage());
            }
            UnixFileKey fileKey = attrs.fileKey();
            SolarisWatchKey watchKey = this.fileKey2WatchKey.get(fileKey);
            if (watchKey != null) {
                this.updateEvents(watchKey, events);
                return watchKey;
            }
            long object = 0L;
            try {
                object = this.registerImpl(dir, 6);
            }
            catch (UnixException x) {
                return x.asIOException(dir);
            }
            watchKey = new SolarisWatchKey(this.watcher, dir, fileKey, object, events);
            this.object2Node.put(object, watchKey);
            this.fileKey2WatchKey.put(fileKey, watchKey);
            this.registerChildren(dir, watchKey, false);
            return watchKey;
        }

        @Override
        void implCancelKey(WatchKey obj) {
            SolarisWatchKey key = (SolarisWatchKey)obj;
            if (key.isValid()) {
                this.fileKey2WatchKey.remove(key.getFileKey());
                if (key.children != null) {
                    for (Map.Entry entry : key.children.entrySet()) {
                        EntryNode node = (EntryNode)entry.getValue();
                        long object = node.object();
                        this.object2Node.remove(object);
                        this.releaseObject(object, true);
                    }
                }
                long object = key.object();
                this.object2Node.remove(object);
                this.releaseObject(object, true);
                key.invalidate();
            }
        }

        @Override
        void implCloseAll() {
            for (Long l : this.object2Node.keySet()) {
                this.releaseObject(l, true);
            }
            for (Map.Entry entry : this.fileKey2WatchKey.entrySet()) {
                ((SolarisWatchKey)entry.getValue()).invalidate();
            }
            this.object2Node.clear();
            this.fileKey2WatchKey.clear();
            unsafe.freeMemory(this.bufferAddress);
            UnixNativeDispatcher.close(this.port);
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    int n = SolarisWatchService.portGetn(this.port, this.bufferAddress, 128);
                    assert (n > 0);
                    long address = this.bufferAddress;
                    int i = 0;
                    while (true) {
                        if (i >= n) continue block2;
                        boolean shutdown = this.processEvent(address);
                        if (shutdown) {
                            return;
                        }
                        address += (long)SIZEOF_PORT_EVENT;
                        ++i;
                    }
                    break;
                }
            }
            catch (UnixException x) {
                x.printStackTrace();
                return;
            }
        }

        boolean processEvent(long address) {
            short source = unsafe.getShort(address + 4L);
            long object = unsafe.getAddress(address + 8L);
            int events = unsafe.getInt(address + 0L);
            if (source != 7) {
                boolean shutdown;
                return source == 3 && (shutdown = this.processRequests());
            }
            Node node = this.object2Node.get(object);
            if (node == null) {
                return false;
            }
            boolean reregister = true;
            boolean isDirectory = node instanceof SolarisWatchKey;
            if (isDirectory) {
                this.processDirectoryEvents((SolarisWatchKey)node, events);
            } else {
                boolean ignore = this.processEntryEvents((EntryNode)node, events);
                if (ignore) {
                    reregister = false;
                }
            }
            if (reregister) {
                try {
                    events = 6;
                    if (!isDirectory) {
                        events |= 0x10000000;
                    }
                    SolarisWatchService.portAssociate(this.port, 7, object, events);
                }
                catch (UnixException x) {
                    reregister = false;
                }
            }
            if (!reregister) {
                this.object2Node.remove(object);
                this.releaseObject(object, false);
                if (isDirectory) {
                    SolarisWatchKey key = (SolarisWatchKey)node;
                    this.fileKey2WatchKey.remove(key.getFileKey());
                    key.invalidate();
                    key.signal();
                } else {
                    EntryNode entry = (EntryNode)node;
                    SolarisWatchKey key = (SolarisWatchKey)entry.parent();
                    key.removeChild(entry.name());
                }
            }
            return false;
        }

        void processDirectoryEvents(SolarisWatchKey key, int mask) {
            if ((mask & 6) != 0) {
                this.registerChildren(key.getDirectory(), key, key.events().contains(StandardWatchEventKinds.ENTRY_CREATE));
            }
        }

        boolean processEntryEvents(EntryNode node, int mask) {
            SolarisWatchKey key = (SolarisWatchKey)node.parent();
            Set<WatchEvent.Kind<?>> events = key.events();
            if (events == null) {
                return true;
            }
            if ((mask & 6) != 0 && events.contains(StandardWatchEventKinds.ENTRY_MODIFY)) {
                key.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, node.name());
            }
            if ((mask & 0x70) != 0 && events.contains(StandardWatchEventKinds.ENTRY_DELETE)) {
                boolean removed = true;
                try {
                    UnixFileAttributes.get(key.getDirectory().resolve(node.name()), false);
                    removed = false;
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
                if (removed) {
                    key.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, node.name());
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerChildren(UnixPath dir, SolarisWatchKey parent, boolean sendEvents) {
            int events = 0x10000000;
            if (parent.events().contains(StandardWatchEventKinds.ENTRY_MODIFY)) {
                events |= 6;
            }
            DirectoryStream<Path> stream = null;
            try {
                stream = Files.newDirectoryStream(dir);
            }
            catch (IOException x) {
                return;
            }
            try {
                for (Path entry : stream) {
                    Path name = entry.getFileName();
                    if (parent.getChild(name) != null) continue;
                    if (sendEvents) {
                        parent.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, name);
                    }
                    long object = 0L;
                    try {
                        object = this.registerImpl((UnixPath)entry, events);
                    }
                    catch (UnixException x) {
                        continue;
                    }
                    EntryNode node = new EntryNode(object, entry.getFileName(), parent);
                    parent.addChild(entry.getFileName(), node);
                    this.object2Node.put(object, node);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }

        void updateEvents(SolarisWatchKey key, Set<? extends WatchEvent.Kind<?>> events) {
            boolean wasModifyEnabled = key.events().contains(StandardWatchEventKinds.ENTRY_MODIFY);
            key.setEvents(events);
            boolean isModifyEnabled = events.contains(StandardWatchEventKinds.ENTRY_MODIFY);
            if (wasModifyEnabled == isModifyEnabled) {
                return;
            }
            if (key.children != null) {
                int ev = 0x10000000;
                if (isModifyEnabled) {
                    ev |= 6;
                }
                for (Map.Entry entry : key.children.entrySet()) {
                    long object = ((EntryNode)entry.getValue()).object();
                    try {
                        SolarisWatchService.portAssociate(this.port, 7, object, ev);
                    }
                    catch (UnixException unixException) {}
                }
            }
        }

        long registerImpl(UnixPath dir, int events) throws UnixException {
            byte[] path = dir.getByteArrayForSysCalls();
            int len = path.length;
            long name = unsafe.allocateMemory(len + 1);
            unsafe.copyMemory(path, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, name, len);
            unsafe.putByte(name + (long)len, (byte)0);
            long object = unsafe.allocateMemory(SIZEOF_FILEOBJ);
            unsafe.setMemory(null, object, SIZEOF_FILEOBJ, (byte)0);
            unsafe.putAddress(object + (long)OFFSET_FO_NAME, name);
            try {
                SolarisWatchService.portAssociate(this.port, 7, object, events);
            }
            catch (UnixException x) {
                if (x.errno() == 11) {
                    System.err.println("The maximum number of objects associated with the port has been reached");
                }
                unsafe.freeMemory(name);
                unsafe.freeMemory(object);
                throw x;
            }
            return object;
        }

        void releaseObject(long object, boolean dissociate) {
            if (dissociate) {
                try {
                    SolarisWatchService.portDissociate(this.port, 7, object);
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
            }
            long name = unsafe.getAddress(object + (long)OFFSET_FO_NAME);
            unsafe.freeMemory(name);
            unsafe.freeMemory(object);
        }
    }

    private class SolarisWatchKey
    extends AbstractWatchKey
    implements DirectoryNode {
        private final UnixFileKey fileKey;
        private final long object;
        private volatile Set<? extends WatchEvent.Kind<?>> events;
        private Map<Path, EntryNode> children;

        SolarisWatchKey(SolarisWatchService watcher, UnixPath dir, UnixFileKey fileKey, long object, Set<? extends WatchEvent.Kind<?>> events) {
            super(dir, watcher);
            this.fileKey = fileKey;
            this.object = object;
            this.events = events;
        }

        UnixPath getDirectory() {
            return (UnixPath)this.watchable();
        }

        UnixFileKey getFileKey() {
            return this.fileKey;
        }

        @Override
        public long object() {
            return this.object;
        }

        void invalidate() {
            this.events = null;
        }

        Set<? extends WatchEvent.Kind<?>> events() {
            return this.events;
        }

        void setEvents(Set<? extends WatchEvent.Kind<?>> events) {
            this.events = events;
        }

        @Override
        public boolean isValid() {
            return this.events != null;
        }

        @Override
        public void cancel() {
            if (this.isValid()) {
                SolarisWatchService.this.poller.cancel(this);
            }
        }

        @Override
        public void addChild(Path name, EntryNode node) {
            if (this.children == null) {
                this.children = new HashMap<Path, EntryNode>();
            }
            this.children.put(name, node);
        }

        @Override
        public void removeChild(Path name) {
            this.children.remove(name);
        }

        @Override
        public EntryNode getChild(Path name) {
            if (this.children != null) {
                return this.children.get(name);
            }
            return null;
        }
    }
}

