/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.management.relation.RoleStatus;

public class RoleUnresolved
implements Serializable {
    private static final long oldSerialVersionUID = -9026457686611660144L;
    private static final long newSerialVersionUID = -48350262537070138L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myRoleName", String.class), new ObjectStreamField("myRoleValue", ArrayList.class), new ObjectStreamField("myPbType", Integer.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("roleName", String.class), new ObjectStreamField("roleValue", List.class), new ObjectStreamField("problemType", Integer.TYPE)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String roleName = null;
    private List<ObjectName> roleValue = null;
    private int problemType;

    public RoleUnresolved(String name, List<ObjectName> value, int pbType) throws IllegalArgumentException {
        if (name == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        this.setRoleName(name);
        this.setRoleValue(value);
        this.setProblemType(pbType);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public List<ObjectName> getRoleValue() {
        return this.roleValue;
    }

    public int getProblemType() {
        return this.problemType;
    }

    public void setRoleName(String name) throws IllegalArgumentException {
        if (name == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        this.roleName = name;
    }

    public void setRoleValue(List<ObjectName> value) {
        this.roleValue = value != null ? new ArrayList<ObjectName>(value) : null;
    }

    public void setProblemType(int pbType) throws IllegalArgumentException {
        if (!RoleStatus.isRoleStatus(pbType)) {
            String excMsg = "Incorrect problem type.";
            throw new IllegalArgumentException(excMsg);
        }
        this.problemType = pbType;
    }

    public Object clone() {
        try {
            return new RoleUnresolved(this.roleName, this.roleValue, this.problemType);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("role name: " + this.roleName);
        if (this.roleValue != null) {
            result.append("; value: ");
            Iterator<ObjectName> objNameIter = this.roleValue.iterator();
            while (objNameIter.hasNext()) {
                ObjectName currObjName = objNameIter.next();
                result.append(currObjName.toString());
                if (!objNameIter.hasNext()) continue;
                result.append(", ");
            }
        }
        result.append("; problem type: " + this.problemType);
        return result.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.roleName = (String)fields.get("myRoleName", null);
            if (fields.defaulted("myRoleName")) {
                throw new NullPointerException("myRoleName");
            }
            this.roleValue = (List)Util.cast(fields.get("myRoleValue", null));
            if (fields.defaulted("myRoleValue")) {
                throw new NullPointerException("myRoleValue");
            }
            this.problemType = fields.get("myPbType", 0);
            if (fields.defaulted("myPbType")) {
                throw new NullPointerException("myPbType");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myRoleName", this.roleName);
            fields.put("myRoleValue", this.roleValue);
            fields.put("myPbType", this.problemType);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -9026457686611660144L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -48350262537070138L;
        }
    }
}

