/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Hashtable;
import sun.awt.PlatformFont;

public class X11FontMetrics
extends FontMetrics {
    int[] widths;
    int ascent;
    int descent;
    int leading;
    int height;
    int maxAscent;
    int maxDescent;
    int maxHeight;
    int maxAdvance;
    static Hashtable table;

    private static native void initIDs();

    public X11FontMetrics(Font font) {
        super(font);
        this.init();
    }

    @Override
    public int getLeading() {
        return this.leading;
    }

    @Override
    public int getAscent() {
        return this.ascent;
    }

    @Override
    public int getDescent() {
        return this.descent;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMaxAscent() {
        return this.maxAscent;
    }

    @Override
    public int getMaxDescent() {
        return this.maxDescent;
    }

    @Override
    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    @Override
    public int stringWidth(String string) {
        return this.charsWidth(string.toCharArray(), 0, string.length());
    }

    @Override
    public int charsWidth(char[] chars, int offset, int length) {
        Font font = this.getFont();
        PlatformFont pf = (PlatformFont)font.getPeer();
        if (pf.mightHaveMultiFontMetrics()) {
            return this.getMFCharsWidth(chars, offset, length, font);
        }
        if (this.widths != null) {
            int w = 0;
            for (int i = offset; i < offset + length; ++i) {
                char ch = chars[i];
                if (ch < '\u0000' || ch >= this.widths.length) {
                    w += this.maxAdvance;
                    continue;
                }
                w += this.widths[ch];
            }
            return w;
        }
        return this.maxAdvance * length;
    }

    private native int getMFCharsWidth(char[] var1, int var2, int var3, Font var4);

    @Override
    public native int bytesWidth(byte[] var1, int var2, int var3);

    @Override
    public int[] getWidths() {
        return this.widths;
    }

    native void init();

    static synchronized FontMetrics getFontMetrics(Font font) {
        FontMetrics fm = (FontMetrics)table.get(font);
        if (fm == null) {
            fm = new X11FontMetrics(font);
            table.put(font, fm);
        }
        return fm;
    }

    static {
        X11FontMetrics.initIDs();
        table = new Hashtable();
    }
}

