/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Image;
import java.awt.Point;
import java.util.Arrays;
import sun.awt.CustomCursor;

public abstract class X11CustomCursor
extends CustomCursor {
    public X11CustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException {
        super(cursor, hotSpot, name);
    }

    @Override
    protected void createNativeCursor(Image im, int[] pixels, int width, int height, int xHotSpot, int yHotSpot) {
        int[] tmp = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            tmp[i] = (pixels[i] & 0xFF000000) == 0 ? -1 : pixels[i] & 0xFFFFFF;
        }
        Arrays.sort(tmp);
        int fc = 0;
        int bc = 0xFFFFFF;
        class CCount
        implements Comparable {
            int color;
            int count;

            public CCount(int cl, int ct) {
                this.color = cl;
                this.count = ct;
            }

            public int compareTo(Object cc) {
                return ((CCount)cc).count - this.count;
            }
        }
        Object[] cols = new CCount[pixels.length];
        int numColors = 0;
        for (int is = 0; is < pixels.length; ++is) {
            if (tmp[is] == -1) continue;
            cols[numColors++] = new CCount(tmp[is], 1);
            break;
        }
        for (int i = is + 1; i < pixels.length; ++i) {
            if (tmp[i] != ((CCount)cols[numColors - 1]).color) {
                cols[numColors++] = new CCount(tmp[i], 1);
                continue;
            }
            ++((CCount)cols[numColors - 1]).count;
        }
        Arrays.sort(cols, 0, numColors);
        if (numColors > 0) {
            fc = ((CCount)cols[0]).color;
        }
        int fcr = fc >> 16 & 0xFF;
        int fcg = fc >> 8 & 0xFF;
        int fcb = fc >> 0 & 0xFF;
        int rdis = 0;
        int gdis = 0;
        int bdis = 0;
        for (int j = 1; j < numColors; ++j) {
            int rr = ((CCount)cols[j]).color >> 16 & 0xFF;
            int gg = ((CCount)cols[j]).color >> 8 & 0xFF;
            int bb = ((CCount)cols[j]).color >> 0 & 0xFF;
            rdis += ((CCount)cols[j]).count * rr;
            gdis += ((CCount)cols[j]).count * gg;
            bdis += ((CCount)cols[j]).count * bb;
        }
        int rest = pixels.length - (numColors > 0 ? ((CCount)cols[0]).count : 0);
        if (rest > 0) {
            rdis = rdis / rest - fcr;
            gdis = gdis / rest - fcg;
            bdis = bdis / rest - fcb;
        }
        rdis = (rdis * rdis + gdis * gdis + bdis * bdis) / 2;
        for (int j = 1; j < numColors; ++j) {
            int rr = ((CCount)cols[j]).color >> 16 & 0xFF;
            int gg = ((CCount)cols[j]).color >> 8 & 0xFF;
            int bb = ((CCount)cols[j]).color >> 0 & 0xFF;
            if ((rr - fcr) * (rr - fcr) + (gg - fcg) * (gg - fcg) + (bb - fcb) * (bb - fcb) < rdis) continue;
            bc = ((CCount)cols[j]).color;
            break;
        }
        int bcr = bc >> 16 & 0xFF;
        int bcg = bc >> 8 & 0xFF;
        int bcb = bc >> 0 & 0xFF;
        int wNByte = (width + 7) / 8;
        int tNByte = wNByte * height;
        byte[] xorMask = new byte[tNByte];
        byte[] andMask = new byte[tNByte];
        for (int i = 0; i < width; ++i) {
            int omask = 1 << i % 8;
            for (int j = 0; j < height; ++j) {
                int pb;
                int pg;
                int pr;
                int ip = j * width + i;
                int ibyte = j * wNByte + i / 8;
                if ((pixels[ip] & 0xFF000000) != 0) {
                    int n = ibyte;
                    andMask[n] = (byte)(andMask[n] | omask);
                }
                if (((pr = pixels[ip] >> 16 & 0xFF) - fcr) * (pr - fcr) + ((pg = pixels[ip] >> 8 & 0xFF) - fcg) * (pg - fcg) + ((pb = pixels[ip] >> 0 & 0xFF) - fcb) * (pb - fcb) > (pr - bcr) * (pr - bcr) + (pg - bcg) * (pg - bcg) + (pb - bcb) * (pb - bcb)) continue;
                int n = ibyte;
                xorMask[n] = (byte)(xorMask[n] | omask);
            }
        }
        this.createCursor(xorMask, andMask, 8 * wNByte, height, fc, bc, xHotSpot, yHotSpot);
    }

    protected abstract void createCursor(byte[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);
}

