/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.peer.CanvasPeer;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;

class XCanvasPeer
extends XComponentPeer
implements CanvasPeer {
    private boolean eraseBackgroundDisabled;

    XCanvasPeer() {
    }

    XCanvasPeer(XCreateWindowParams params) {
        super(params);
    }

    XCanvasPeer(Component target) {
        super(target);
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        if (SunToolkit.getSunAwtNoerasebackground()) {
            this.disableBackgroundErase();
        }
    }

    @Override
    public GraphicsConfiguration getAppropriateGraphicsConfiguration(GraphicsConfiguration gc) {
        if (this.graphicsConfig == null || gc == null) {
            return gc;
        }
        int screenNum = ((X11GraphicsDevice)gc.getDevice()).getScreen();
        int visual = this.graphicsConfig.getVisual();
        X11GraphicsDevice newDev = (X11GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[screenNum];
        for (int i = 0; i < newDev.getNumConfigs(screenNum); ++i) {
            if (visual != newDev.getConfigVisualId(i, screenNum)) continue;
            this.graphicsConfig = (X11GraphicsConfig)newDev.getConfigurations()[i];
            break;
        }
        if (this.graphicsConfig == null) {
            this.graphicsConfig = (X11GraphicsConfig)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[screenNum].getDefaultConfiguration();
        }
        return this.graphicsConfig;
    }

    protected boolean shouldFocusOnClick() {
        return true;
    }

    public void disableBackgroundErase() {
        this.eraseBackgroundDisabled = true;
    }

    @Override
    protected boolean doEraseBackground() {
        return !this.eraseBackgroundDisabled;
    }
}

