/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private TabStop[] tabs;
    private int hashCode = Integer.MAX_VALUE;

    public TabSet(TabStop[] tabs) {
        if (tabs != null) {
            int tabCount = tabs.length;
            this.tabs = new TabStop[tabCount];
            System.arraycopy(tabs, 0, this.tabs, 0, tabCount);
        } else {
            this.tabs = null;
        }
    }

    public int getTabCount() {
        return this.tabs == null ? 0 : this.tabs.length;
    }

    public TabStop getTab(int index) {
        int numTabs = this.getTabCount();
        if (index < 0 || index >= numTabs) {
            throw new IllegalArgumentException(index + " is outside the range of tabs");
        }
        return this.tabs[index];
    }

    public TabStop getTabAfter(float location) {
        int index = this.getTabIndexAfter(location);
        return index == -1 ? null : this.tabs[index];
    }

    public int getTabIndex(TabStop tab) {
        for (int counter = this.getTabCount() - 1; counter >= 0; --counter) {
            if (this.getTab(counter) != tab) continue;
            return counter;
        }
        return -1;
    }

    public int getTabIndexAfter(float location) {
        int min = 0;
        int max = this.getTabCount();
        while (min != max) {
            int current = (max - min) / 2 + min;
            if (location > this.tabs[current].getPosition()) {
                if (min == current) {
                    min = max;
                    continue;
                }
                min = current;
                continue;
            }
            if (current == 0 || location > this.tabs[current - 1].getPosition()) {
                return current;
            }
            max = current;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TabSet) {
            TabSet ts = (TabSet)o;
            int count = this.getTabCount();
            if (ts.getTabCount() != count) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                TabStop ts1 = this.getTab(i);
                TabStop ts2 = ts.getTab(i);
                if ((ts1 != null || ts2 == null) && (ts1 == null || this.getTab(i).equals(ts.getTab(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MAX_VALUE) {
            this.hashCode = 0;
            int len = this.getTabCount();
            for (int i = 0; i < len; ++i) {
                TabStop ts = this.getTab(i);
                this.hashCode ^= ts != null ? this.getTab(i).hashCode() : 0;
            }
            if (this.hashCode == Integer.MAX_VALUE) {
                --this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        int tabCount = this.getTabCount();
        StringBuilder buffer = new StringBuilder("[ ");
        for (int counter = 0; counter < tabCount; ++counter) {
            if (counter > 0) {
                buffer.append(" - ");
            }
            buffer.append(this.getTab(counter).toString());
        }
        buffer.append(" ]");
        return buffer.toString();
    }
}

