/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.httpbinding;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.exceptions.ServiceAccessException;
import amazon.fws.clicommando.httpbinding.AwsHttpBindingRequest;
import amazon.fws.clicommando.httpbinding.AwsHttpBindingServiceResponseHandler;
import amazon.fws.clicommando.httpbinding.AwsHttpBindingSigner;
import amazon.fws.clicommando.httpbinding.StreamUtils;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import amazon.fws.clicommando.security.AwsSignatureHelper;
import amazon.fws.clicommando.util.DateUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsHttpBindingCaller
extends AwsServiceCaller {
    static final String PARAM_NAME_ACCESS_KEY = "AWSAccessKeyId";
    static final String PARAM_NAME_SECRET_KEY = "AWSSecretKey";
    static final String HEADER_AUTHORIZATION = "Authorization";
    static final String HEADER_HOST = "Host";
    static final String HEADER_USER_AGENT = "User-Agent";
    private final AwsHttpBindingSigner restSigner;

    public AwsHttpBindingCaller(ServiceCallConfig awsCallConfig) {
        this(new AwsHttpBindingSigner(), awsCallConfig);
    }

    AwsHttpBindingCaller(AwsHttpBindingSigner restSigner, ServiceCallConfig awsCallConfig) {
        this.restSigner = restSigner;
        this.awsCallConfig = awsCallConfig;
    }

    @Override
    public void call(Command command) {
        URL serverAddress = AwsHttpBindingCaller.getServerAddressURL(this.awsCallConfig.getServiceUrl(), this.awsCallConfig.getParameters());
        AwsHttpBindingRequest.Builder requestBuilder = new AwsHttpBindingRequest.Builder().withCommand(command).withMethod(this.awsCallConfig.getHttpMethod()).withUrl(serverAddress).withAccessId(AwsHttpBindingCaller.getAccessId(command)).withSecretKey(AwsHttpBindingCaller.getSecretKey(command));
        AwsHttpBindingCaller.addDateHeader(requestBuilder);
        AwsHttpBindingCaller.addHostHeader(requestBuilder, serverAddress);
        this.addAuthorizationHeader(requestBuilder);
        this.addUserAgentHeader(requestBuilder);
        this.awsRequestUrl = serverAddress.toString();
        this.callService(requestBuilder.build());
    }

    private void callService(AwsHttpBindingRequest request) {
        HttpURLConnection connection = null;
        try {
            block10: {
                try {
                    connection = this.prepareConnection(request);
                    connection.connect();
                    this.responseHandler = new AwsHttpBindingServiceResponseHandler(connection.getResponseCode(), request.getUrl().toString());
                    if (this.responseHandler.isError()) break block10;
                    StreamUtils.copyStreamData(connection.getInputStream(), System.out);
                }
                catch (SocketTimeoutException e) {
                    throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.COMMAND_TIMEOUT, new String[0]);
                }
                catch (UnknownHostException uhe) {
                    throw new BadInputException(ErrorMessages.ErrorCode.UNKNOWN_TARGET_URL, uhe.getLocalizedMessage());
                }
                catch (IOException e) {
                    if (e.getMessage().contains("unable to find valid certification path to requested target") || e.getMessage().contains("No trusted certificate found")) {
                        throw new BadInputException(ErrorMessages.ErrorCode.SSL_NOT_AUTH, e.getLocalizedMessage());
                    }
                    if (e.getMessage().contains("Read timed out")) {
                        throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.COMMAND_TIMEOUT, new String[0]);
                    }
                    throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.ERROR_REACHING_AWS, e.getLocalizedMessage());
                }
            }
            Object var5_3 = null;
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
    }

    private HttpURLConnection prepareConnection(AwsHttpBindingRequest request) {
        HttpURLConnection connection = this.openHttpURLConnection(request);
        try {
            connection.setRequestMethod(request.getMethod());
        }
        catch (ProtocolException e) {
            throw new InternalErrorException("Some protocol problem reaching: " + request.getUrl().toString(), e);
        }
        connection.setReadTimeout(this.awsCallConfig.getTimeout());
        connection.setDoInput(true);
        connection.setUseCaches(false);
        for (Map.Entry<String, String> paramEntry : request.getHeaderParameters().entrySet()) {
            connection.setRequestProperty(paramEntry.getKey(), paramEntry.getValue());
        }
        return connection;
    }

    private void addAuthorizationHeader(AwsHttpBindingRequest.Builder requestBuilder) {
        String authorizationValue = this.restSigner.signRequestAndReturnAuthorizationValue(requestBuilder.build());
        requestBuilder.withHeaderParameter(HEADER_AUTHORIZATION, authorizationValue);
    }

    private void addUserAgentHeader(AwsHttpBindingRequest.Builder requestBuilder) {
        requestBuilder.withHeaderParameter(HEADER_USER_AGENT, this.awsCallConfig.getUserAgent());
    }

    private static String getSecretKey(Command command) {
        return command.getCurrentCommandConfig().getParameter(PARAM_NAME_SECRET_KEY).getValue();
    }

    private static String getAccessId(Command command) {
        return command.getCurrentCommandConfig().getParameter(PARAM_NAME_ACCESS_KEY).getValue();
    }

    private static void addHostHeader(AwsHttpBindingRequest.Builder requestBuilder, URL serviceUrl) {
        String host = serviceUrl.getHost();
        if (serviceUrl.getPort() != 80 && serviceUrl.getPort() != 443 && serviceUrl.getPort() > 0) {
            host = host + ":" + serviceUrl.getPort();
        }
        requestBuilder.withHeaderParameter(HEADER_HOST, host);
    }

    private static void addDateHeader(AwsHttpBindingRequest.Builder requestBuilder) {
        requestBuilder.withHeaderParameter("X-Amz-Date", DateUtils.getFormattedTimestampV4());
    }

    private static URL getServerAddressURL(String url, Map<String, String> queryMap) {
        String queryString = AwsHttpBindingCaller.createQueryString(queryMap);
        String connectionUrl = !queryString.isEmpty() ? url + "?" + queryString : url;
        try {
            return new URL(connectionUrl);
        }
        catch (MalformedURLException e) {
            int loc = connectionUrl.indexOf("/");
            String displayedUrl = loc <= 0 ? connectionUrl.substring(0, 30) + "..." : connectionUrl.substring(0, loc);
            throw new BadInputException(ErrorMessages.ErrorCode.MALFORMED_URL, displayedUrl);
        }
    }

    private static String createQueryString(Map<String, String> paramMap) {
        StringBuilder urlBld = new StringBuilder("");
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            urlBld.append(entry.getKey() + "=" + AwsSignatureHelper.urlEncode(entry.getValue(), false) + "&");
        }
        if (urlBld.length() != 0) {
            urlBld.deleteCharAt(urlBld.length() - 1);
        }
        return urlBld.toString();
    }

    protected HttpURLConnection openHttpURLConnection(AwsHttpBindingRequest request) {
        try {
            return (HttpURLConnection)request.getUrl().openConnection();
        }
        catch (IOException e) {
            throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.ERROR_REACHING_AWS, e.getLocalizedMessage());
        }
    }
}

