/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.httpbinding;

import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.httpbinding.AwsHttpBindingRequest;
import amazon.fws.clicommando.security.AwsSignatureHelper;
import amazon.fws.clicommando.util.DateUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsHttpBindingSigner {
    private static final String AUTH_SCHEME = "AWS4-HMAC-SHA256";
    private static final String SIGNATURE_ALGORITHM = "HmacSHA256";
    public static final String HEADER_DATE = "X-Amz-Date";

    public String signRequestAndReturnAuthorizationValue(AwsHttpBindingRequest request) {
        byte[] kDate;
        String credentialScope = AwsHttpBindingSigner.getCredentialScope(request);
        String kSecret = "AWS4" + request.getSecretKey();
        String stringToSign = AwsHttpBindingSigner.calculateStringToSignV4(request, credentialScope);
        try {
            kDate = AwsSignatureHelper.rawSignature(DateUtils.getToday(), kSecret.getBytes("UTF-8"), SIGNATURE_ALGORITHM);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] kRegion = AwsSignatureHelper.rawSignature(AwsHttpBindingSigner.determineRegion(request), kDate, SIGNATURE_ALGORITHM);
        byte[] kService = AwsSignatureHelper.rawSignature(AwsHttpBindingSigner.determineServiceSignatureName(request), kRegion, SIGNATURE_ALGORITHM);
        byte[] kSigning = AwsSignatureHelper.rawSignature("aws4_request", kService, SIGNATURE_ALGORITHM);
        String signature = AwsSignatureHelper.toHex(AwsSignatureHelper.rawSignature(stringToSign, kSigning, SIGNATURE_ALGORITHM));
        return AwsHttpBindingSigner.buildAuthorizationHeader(request.getAccessId() + "/" + credentialScope, AwsHttpBindingSigner.buildSignedHeadersAuthorizationString(request.getHeaderParameters()), signature);
    }

    private static String calculateStringToSignV4(AwsHttpBindingRequest request, String credentialScope) {
        String stringToSign = "AWS4-HMAC-SHA256\n";
        stringToSign = stringToSign + (String)request.getHeaderParameters().get(HEADER_DATE) + "\n";
        stringToSign = stringToSign + credentialScope + "\n";
        stringToSign = stringToSign + AwsHttpBindingSigner.sha256(AwsHttpBindingSigner.canonicalRequestV4(request));
        return stringToSign;
    }

    private static String determineRegion(AwsHttpBindingRequest request) {
        URI endpoint;
        String region;
        CommandConfig commandConfig = request.getCommand().getCurrentCommandConfig();
        if (commandConfig.doesParameterExist("Region") && !(region = commandConfig.getParameter("Region").getValue()).isEmpty()) {
            return region;
        }
        try {
            endpoint = request.getUrl().toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        String[] endpoint_components = endpoint.getHost().split("\\.");
        String region2 = "us-east-1";
        if (endpoint_components.length == 4) {
            region2 = endpoint_components[1];
        }
        return region2;
    }

    private static String determineServiceSignatureName(AwsHttpBindingRequest request) {
        URI endpoint;
        String service;
        CommandConfig commandConfig = request.getCommand().getCurrentCommandConfig();
        if (commandConfig.doesParameterExist("ServiceSignatureName") && !(service = commandConfig.getParameter("ServiceSignatureName").getValue()).isEmpty()) {
            return service;
        }
        try {
            endpoint = request.getUrl().toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        String[] endpoint_components = endpoint.getHost().split("\\.");
        return endpoint_components[0];
    }

    private static String canonicalRequestV4(AwsHttpBindingRequest request) {
        URI endpoint;
        try {
            endpoint = request.getUrl().toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        String requestToSign = request.getMethod() + "\n";
        requestToSign = requestToSign + (endpoint.getPath().length() == 0 ? "/" : endpoint.getPath()) + "\n";
        requestToSign = requestToSign + AwsHttpBindingSigner.canonicalQueryString(request.getQueryParameters()) + "\n";
        requestToSign = requestToSign + AwsHttpBindingSigner.canonicalHeadersString(request.getHeaderParameters()) + "\n";
        requestToSign = requestToSign + "\n";
        requestToSign = requestToSign + AwsHttpBindingSigner.buildSignedHeadersAuthorizationString(request.getHeaderParameters()) + "\n";
        requestToSign = requestToSign + AwsHttpBindingSigner.sha256("");
        return requestToSign;
    }

    private static String canonicalQueryString(SortedMap<String, String> parameters) {
        String query = "";
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            query = query + AwsHttpBindingSigner.urlEncode(param.getKey(), false) + "=" + AwsHttpBindingSigner.urlEncode(param.getValue(), false) + "&";
        }
        if (!query.isEmpty() && query.charAt(query.length() - 1) == '&') {
            query = query.substring(0, query.length() - 1);
        }
        return query;
    }

    private static String canonicalHeadersString(SortedMap<String, String> parameters) {
        String headers = "";
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            headers = headers + param.getKey().toLowerCase().trim() + ":" + param.getValue().trim() + "\n";
        }
        if (!headers.isEmpty() && headers.charAt(headers.length() - 1) == '\n') {
            headers = headers.substring(0, headers.length() - 1);
        }
        return headers;
    }

    private static String sha256(String input) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            return AwsHttpBindingSigner.toHex(sha256.digest(input.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get SHA-256 digest algorithm", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported.", e);
        }
    }

    private static String toHex(byte[] bytes) {
        String result = "";
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                result = result + "0";
            }
            result = result + hex;
        }
        return result;
    }

    private static String buildAuthorizationHeader(String credential, String signedHeaders, String signature) {
        StringBuilder sb = new StringBuilder();
        sb.append(AUTH_SCHEME);
        sb.append(",");
        sb.append("Credential=");
        sb.append(credential);
        sb.append(",");
        sb.append("SignedHeaders=");
        sb.append(signedHeaders);
        sb.append(",");
        sb.append("Signature=");
        sb.append(signature);
        return sb.toString();
    }

    private static String getCredentialScope(AwsHttpBindingRequest request) {
        String region = AwsHttpBindingSigner.determineRegion(request);
        String service = AwsHttpBindingSigner.determineServiceSignatureName(request);
        return DateUtils.getToday() + "/" + region + "/" + service + "/aws4_request";
    }

    public static String urlEncode(String value, boolean encodePath) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (encodePath) {
                encoded = encoded.replace("%2F", "/");
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return encoded;
    }

    private static String buildSignedHeadersAuthorizationString(SortedMap<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        for (String headerEntry : headers.keySet()) {
            sb.append(headerEntry.toLowerCase());
            sb.append(";");
        }
        if (sb.length() != 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }
}

