/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.processors.output.ResultPrinter;
import amazon.fws.clicommando.processors.output.ResultPrinterFactory;
import amazon.fws.clicommando.util.StringUtils;

public class OutputFormatCommandProcessor
implements CommandProcessor {
    private String valueForDisplay = "";

    public String getValueForDisplay() {
        return this.valueForDisplay;
    }

    public ResultPrinter.DisplayMethod getDisplayMethod(Command command) {
        ResultPrinter.DisplayMethod displayMethod = ResultPrinter.DisplayMethod.STDOUT;
        if (command.getCurrentCommandConfig().getParameterMap().containsKey("DisplayResultMethod")) {
            displayMethod = ResultPrinter.DisplayMethod.parse(command.getCurrentCommandConfig().getParameter("DisplayResultMethod").getValue());
        }
        return displayMethod;
    }

    public void setValueForDisplay(Command command) {
        ResultPrinter printer = ResultPrinterFactory.getPrinter(this.getDisplayMethod(command));
        this.valueForDisplay = printer.createOutputForPrinting(command);
    }

    public Command process(Command process) throws CliCommandoException {
        this.setValueForDisplay(process);
        if (StringUtils.notEmpty(this.valueForDisplay)) {
            if (this.valueForDisplay.lastIndexOf(10) == this.valueForDisplay.length() - 1) {
                System.out.print(this.valueForDisplay);
            } else {
                System.out.println(this.valueForDisplay);
            }
        }
        return process;
    }
}

