/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import java.io.IOException;
import java.util.Arrays;

class Instruction {
    protected byte[] bytes;
    protected int pc;
    protected int bc;
    protected int w;
    protected int length;
    protected boolean special;
    private static final byte[][] BC_LENGTH;
    private static final byte[][] BC_INDEX;
    private static final byte[][] BC_TAG;
    private static final byte[][] BC_BRANCH;
    private static final byte[][] BC_SLOT;
    private static final byte[][] BC_CON;
    private static final String[] BC_NAME;
    private static final String[][] BC_FORMAT;
    private static int BW;

    protected Instruction(byte[] bytes, int pc, int bc, int w, int length) {
        this.reset(bytes, pc, bc, w, length);
    }

    private void reset(byte[] bytes, int pc, int bc, int w, int length) {
        this.bytes = bytes;
        this.pc = pc;
        this.bc = bc;
        this.w = w;
        this.length = length;
    }

    public int getBC() {
        return this.bc;
    }

    public boolean isWide() {
        return this.w != 0;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getPC() {
        return this.pc;
    }

    public int getLength() {
        return this.length;
    }

    public int getNextPC() {
        return this.pc + this.length;
    }

    public Instruction next() {
        int npc = this.pc + this.length;
        if (npc == this.bytes.length) {
            return null;
        }
        return Instruction.at(this.bytes, npc, this);
    }

    public boolean isNonstandard() {
        return Instruction.isNonstandard(this.bc);
    }

    public void setNonstandardLength(int length) {
        assert (this.isNonstandard());
        this.length = length;
    }

    public Instruction forceNextPC(int nextpc) {
        int llength = nextpc - this.pc;
        return new Instruction(this.bytes, this.pc, -1, -1, llength);
    }

    public static Instruction at(byte[] bytes, int pc) {
        return Instruction.at(bytes, pc, null);
    }

    public static Instruction at(byte[] bytes, int pc, Instruction reuse) {
        int bc = Instruction.getByte(bytes, pc);
        int prefix = -1;
        int w = 0;
        byte length = BC_LENGTH[w][bc];
        if (length == 0) {
            switch (bc) {
                case 196: {
                    bc = Instruction.getByte(bytes, pc + 1);
                    w = 1;
                    length = BC_LENGTH[w][bc];
                    if (length != 0) break;
                    length = 1;
                    break;
                }
                case 170: {
                    return new TableSwitch(bytes, pc);
                }
                case 171: {
                    return new LookupSwitch(bytes, pc);
                }
                default: {
                    length = 1;
                }
            }
        }
        assert (length > 0);
        assert (pc + length <= bytes.length);
        if (reuse != null && !reuse.special) {
            reuse.reset(bytes, pc, bc, w, length);
            return reuse;
        }
        return new Instruction(bytes, pc, bc, w, length);
    }

    public byte getCPTag() {
        return BC_TAG[this.w][this.bc];
    }

    public int getCPIndex() {
        byte indexLoc = BC_INDEX[this.w][this.bc];
        if (indexLoc == 0) {
            return -1;
        }
        assert (this.w == 0);
        if (this.length == 2) {
            return Instruction.getByte(this.bytes, this.pc + indexLoc);
        }
        return Instruction.getShort(this.bytes, this.pc + indexLoc);
    }

    public void setCPIndex(int cpi) {
        byte indexLoc = BC_INDEX[this.w][this.bc];
        assert (indexLoc != 0);
        if (this.length == 2) {
            Instruction.setByte(this.bytes, this.pc + indexLoc, cpi);
        } else {
            Instruction.setShort(this.bytes, this.pc + indexLoc, cpi);
        }
        assert (this.getCPIndex() == cpi);
    }

    public ConstantPool.Entry getCPRef(ConstantPool.Entry[] cpMap) {
        int index = this.getCPIndex();
        return index < 0 ? null : cpMap[index];
    }

    public int getLocalSlot() {
        byte slotLoc = BC_SLOT[this.w][this.bc];
        if (slotLoc == 0) {
            return -1;
        }
        if (this.w == 0) {
            return Instruction.getByte(this.bytes, this.pc + slotLoc);
        }
        return Instruction.getShort(this.bytes, this.pc + slotLoc);
    }

    public int getBranchLabel() {
        byte branchLoc = BC_BRANCH[this.w][this.bc];
        if (branchLoc == 0) {
            return -1;
        }
        assert (this.w == 0);
        assert (this.length == 3 || this.length == 5);
        int offset = this.length == 3 ? (int)((short)Instruction.getShort(this.bytes, this.pc + branchLoc)) : Instruction.getInt(this.bytes, this.pc + branchLoc);
        assert (offset + this.pc >= 0);
        assert (offset + this.pc <= this.bytes.length);
        return offset + this.pc;
    }

    public void setBranchLabel(int targetPC) {
        byte branchLoc = BC_BRANCH[this.w][this.bc];
        assert (branchLoc != 0);
        if (this.length == 3) {
            Instruction.setShort(this.bytes, this.pc + branchLoc, targetPC - this.pc);
        } else {
            Instruction.setInt(this.bytes, this.pc + branchLoc, targetPC - this.pc);
        }
        assert (targetPC == this.getBranchLabel());
    }

    public int getConstant() {
        byte conLoc = BC_CON[this.w][this.bc];
        if (conLoc == 0) {
            return 0;
        }
        switch (this.length - conLoc) {
            case 1: {
                return (byte)Instruction.getByte(this.bytes, this.pc + conLoc);
            }
            case 2: {
                return (short)Instruction.getShort(this.bytes, this.pc + conLoc);
            }
        }
        assert (false);
        return 0;
    }

    public void setConstant(int con) {
        byte conLoc = BC_CON[this.w][this.bc];
        assert (conLoc != 0);
        switch (this.length - conLoc) {
            case 1: {
                Instruction.setByte(this.bytes, this.pc + conLoc, con);
                break;
            }
            case 2: {
                Instruction.setShort(this.bytes, this.pc + conLoc, con);
            }
        }
        assert (con == this.getConstant());
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == Instruction.class && this.equals((Instruction)o);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + Arrays.hashCode(this.bytes);
        hash = 11 * hash + this.pc;
        hash = 11 * hash + this.bc;
        hash = 11 * hash + this.w;
        hash = 11 * hash + this.length;
        return hash;
    }

    public boolean equals(Instruction that) {
        if (this.pc != that.pc) {
            return false;
        }
        if (this.bc != that.bc) {
            return false;
        }
        if (this.w != that.w) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        for (int i = 1; i < this.length; ++i) {
            if (this.bytes[this.pc + i] == that.bytes[that.pc + i]) continue;
            return false;
        }
        return true;
    }

    static String labstr(int pc) {
        if (pc >= 0 && pc < 100000) {
            return (100000 + pc + "").substring(1);
        }
        return pc + "";
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(ConstantPool.Entry[] cpMap) {
        int con;
        int lab;
        int slt;
        int idx;
        String bcname;
        String s = Instruction.labstr(this.pc) + ": ";
        if (this.bc >= 202) {
            s = s + Integer.toHexString(this.bc);
            return s;
        }
        if (this.w == 1) {
            s = s + "wide ";
        }
        String string = bcname = this.bc < BC_NAME.length ? BC_NAME[this.bc] : null;
        if (bcname == null) {
            return s + "opcode#" + this.bc;
        }
        s = s + bcname;
        byte tag = this.getCPTag();
        if (tag != 0) {
            s = s + " " + ConstantPool.tagName(tag) + ":";
        }
        if ((idx = this.getCPIndex()) >= 0) {
            s = s + (cpMap == null ? "" + idx : "=" + cpMap[idx].stringValue());
        }
        if ((slt = this.getLocalSlot()) >= 0) {
            s = s + " Local:" + slt;
        }
        if ((lab = this.getBranchLabel()) >= 0) {
            s = s + " To:" + Instruction.labstr(lab);
        }
        if ((con = this.getConstant()) != 0) {
            s = s + " Con:" + con;
        }
        return s;
    }

    public int getIntAt(int off) {
        return Instruction.getInt(this.bytes, this.pc + off);
    }

    public int getShortAt(int off) {
        return Instruction.getShort(this.bytes, this.pc + off);
    }

    public int getByteAt(int off) {
        return Instruction.getByte(this.bytes, this.pc + off);
    }

    public static int getInt(byte[] bytes, int pc) {
        return (Instruction.getShort(bytes, pc + 0) << 16) + (Instruction.getShort(bytes, pc + 2) << 0);
    }

    public static int getShort(byte[] bytes, int pc) {
        return (Instruction.getByte(bytes, pc + 0) << 8) + (Instruction.getByte(bytes, pc + 1) << 0);
    }

    public static int getByte(byte[] bytes, int pc) {
        return bytes[pc] & 0xFF;
    }

    public static void setInt(byte[] bytes, int pc, int x) {
        Instruction.setShort(bytes, pc + 0, x >> 16);
        Instruction.setShort(bytes, pc + 2, x >> 0);
    }

    public static void setShort(byte[] bytes, int pc, int x) {
        Instruction.setByte(bytes, pc + 0, x >> 8);
        Instruction.setByte(bytes, pc + 1, x >> 0);
    }

    public static void setByte(byte[] bytes, int pc, int x) {
        bytes[pc] = (byte)x;
    }

    public static boolean isNonstandard(int bc) {
        return BC_LENGTH[0][bc] < 0;
    }

    public static int opLength(int bc) {
        byte l = BC_LENGTH[0][bc];
        assert (l > 0);
        return l;
    }

    public static int opWideLength(int bc) {
        byte l = BC_LENGTH[1][bc];
        assert (l > 0);
        return l;
    }

    public static boolean isLocalSlotOp(int bc) {
        return bc < BC_SLOT[0].length && BC_SLOT[0][bc] > 0;
    }

    public static boolean isBranchOp(int bc) {
        return bc < BC_BRANCH[0].length && BC_BRANCH[0][bc] > 0;
    }

    public static boolean isCPRefOp(int bc) {
        if (bc < BC_INDEX[0].length && BC_INDEX[0][bc] > 0) {
            return true;
        }
        return bc >= 233 && bc < 240;
    }

    public static byte getCPRefOpTag(int bc) {
        if (bc < BC_INDEX[0].length && BC_INDEX[0][bc] > 0) {
            return BC_TAG[0][bc];
        }
        if (bc >= 233 && bc < 240) {
            return 20;
        }
        return 0;
    }

    public static boolean isFieldOp(int bc) {
        return bc >= 178 && bc <= 181;
    }

    public static boolean isInvokeInitOp(int bc) {
        return bc >= 230 && bc < 233;
    }

    public static boolean isSelfLinkerOp(int bc) {
        return bc >= 202 && bc < 230;
    }

    public static String byteName(int bc) {
        String iname;
        if (bc < BC_NAME.length && BC_NAME[bc] != null) {
            iname = BC_NAME[bc];
        } else if (Instruction.isSelfLinkerOp(bc)) {
            boolean isAload;
            boolean isSuper;
            int idx = bc - 202;
            boolean bl = isSuper = idx >= 14;
            if (isSuper) {
                idx -= 14;
            }
            boolean bl2 = isAload = idx >= 7;
            if (isAload) {
                idx -= 7;
            }
            int origBC = 178 + idx;
            assert (origBC >= 178 && origBC <= 184);
            iname = BC_NAME[origBC];
            iname = iname + (isSuper ? "_super" : "_this");
            if (isAload) {
                iname = "aload_0&" + iname;
            }
            iname = "*" + iname;
        } else if (Instruction.isInvokeInitOp(bc)) {
            int idx = bc - 230;
            switch (idx) {
                case 0: {
                    iname = "*invokespecial_init_this";
                    break;
                }
                case 1: {
                    iname = "*invokespecial_init_super";
                    break;
                }
                default: {
                    assert (idx == 2);
                    iname = "*invokespecial_init_new";
                    break;
                }
            }
        } else {
            switch (bc) {
                case 234: {
                    iname = "*ildc";
                    break;
                }
                case 235: {
                    iname = "*fldc";
                    break;
                }
                case 237: {
                    iname = "*ildc_w";
                    break;
                }
                case 238: {
                    iname = "*fldc_w";
                    break;
                }
                case 239: {
                    iname = "*dldc2_w";
                    break;
                }
                case 233: {
                    iname = "*cldc";
                    break;
                }
                case 236: {
                    iname = "*cldc_w";
                    break;
                }
                case 254: {
                    iname = "*byte_escape";
                    break;
                }
                case 253: {
                    iname = "*ref_escape";
                    break;
                }
                case 255: {
                    iname = "*end";
                    break;
                }
                default: {
                    iname = "*bc#" + bc;
                }
            }
        }
        return iname;
    }

    private static void def(String fmt, int bc) {
        Instruction.def(fmt, bc, bc);
    }

    private static void def(String fmt, int from_bc, int to_bc) {
        String[] fmts = new String[]{fmt, null};
        if (fmt.indexOf(119) > 0) {
            fmts[1] = fmt.substring(fmt.indexOf(119));
            fmts[0] = fmt.substring(0, fmt.indexOf(119));
        }
        for (int w = 0; w <= 1; ++w) {
            fmt = fmts[w];
            if (fmt == null) continue;
            int length = fmt.length();
            int index = Math.max(0, fmt.indexOf(107));
            int tag = 0;
            int branch = Math.max(0, fmt.indexOf(111));
            int slot = Math.max(0, fmt.indexOf(108));
            int con = Math.max(0, fmt.indexOf(120));
            if (index > 0 && index + 1 < length) {
                switch (fmt.charAt(index + 1)) {
                    case 'c': {
                        tag = 7;
                        break;
                    }
                    case 'k': {
                        tag = 20;
                        break;
                    }
                    case 'f': {
                        tag = 9;
                        break;
                    }
                    case 'm': {
                        tag = 10;
                        break;
                    }
                    case 'i': {
                        tag = 11;
                    }
                }
                assert (tag != 0);
            } else if (index > 0 && length == 2) {
                assert (from_bc == 18);
                tag = 20;
            }
            for (int bc = from_bc; bc <= to_bc; ++bc) {
                Instruction.BC_FORMAT[w][bc] = fmt;
                assert (BC_LENGTH[w][bc] == -1);
                Instruction.BC_LENGTH[w][bc] = (byte)length;
                Instruction.BC_INDEX[w][bc] = (byte)index;
                Instruction.BC_TAG[w][bc] = (byte)tag;
                assert (index != 0 || tag == 0);
                Instruction.BC_BRANCH[w][bc] = (byte)branch;
                Instruction.BC_SLOT[w][bc] = (byte)slot;
                assert (branch == 0 || slot == 0);
                assert (branch == 0 || index == 0);
                assert (slot == 0 || index == 0);
                Instruction.BC_CON[w][bc] = (byte)con;
            }
        }
    }

    public static void opcodeChecker(byte[] code) throws FormatException {
        for (Instruction i = Instruction.at(code, 0); i != null; i = i.next()) {
            int opcode = i.getBC();
            if (opcode != 186 && opcode >= 0 && opcode <= 201) continue;
            String message = "illegal opcode: " + opcode + " " + i;
            throw new FormatException(message);
        }
    }

    static {
        int i;
        BC_LENGTH = new byte[2][256];
        BC_INDEX = new byte[2][256];
        BC_TAG = new byte[2][256];
        BC_BRANCH = new byte[2][256];
        BC_SLOT = new byte[2][256];
        BC_CON = new byte[2][256];
        BC_NAME = new String[256];
        BC_FORMAT = new String[2][202];
        for (i = 0; i < 202; ++i) {
            Instruction.BC_LENGTH[0][i] = -1;
            Instruction.BC_LENGTH[1][i] = -1;
        }
        Instruction.def("b", 0, 15);
        Instruction.def("bx", 16);
        Instruction.def("bxx", 17);
        Instruction.def("bk", 18);
        Instruction.def("bkk", 19, 20);
        Instruction.def("blwbll", 21, 25);
        Instruction.def("b", 26, 53);
        Instruction.def("blwbll", 54, 58);
        Instruction.def("b", 59, 131);
        Instruction.def("blxwbllxx", 132);
        Instruction.def("b", 133, 152);
        Instruction.def("boo", 153, 168);
        Instruction.def("blwbll", 169);
        Instruction.def("", 170, 171);
        Instruction.def("b", 172, 177);
        Instruction.def("bkf", 178, 181);
        Instruction.def("bkm", 182, 184);
        Instruction.def("bkixx", 185);
        Instruction.def("", 186);
        Instruction.def("bkc", 187);
        Instruction.def("bx", 188);
        Instruction.def("bkc", 189);
        Instruction.def("b", 190, 191);
        Instruction.def("bkc", 192, 193);
        Instruction.def("b", 194, 195);
        Instruction.def("", 196);
        Instruction.def("bkcx", 197);
        Instruction.def("boo", 198, 199);
        Instruction.def("boooo", 200, 201);
        for (i = 0; i < 202; ++i) {
            if (BC_LENGTH[0][i] == -1) {
                assert (i == 186);
                continue;
            }
            if (BC_LENGTH[1][i] != -1) continue;
            Instruction.BC_LENGTH[1][i] = (byte)(1 + BC_LENGTH[0][i]);
        }
        String names = "nop aconst_null iconst_m1 iconst_0 iconst_1 iconst_2 iconst_3 iconst_4 iconst_5 lconst_0 lconst_1 fconst_0 fconst_1 fconst_2 dconst_0 dconst_1 bipush sipush ldc ldc_w ldc2_w iload lload fload dload aload iload_0 iload_1 iload_2 iload_3 lload_0 lload_1 lload_2 lload_3 fload_0 fload_1 fload_2 fload_3 dload_0 dload_1 dload_2 dload_3 aload_0 aload_1 aload_2 aload_3 iaload laload faload daload aaload baload caload saload istore lstore fstore dstore astore istore_0 istore_1 istore_2 istore_3 lstore_0 lstore_1 lstore_2 lstore_3 fstore_0 fstore_1 fstore_2 fstore_3 dstore_0 dstore_1 dstore_2 dstore_3 astore_0 astore_1 astore_2 astore_3 iastore lastore fastore dastore aastore bastore castore sastore pop pop2 dup dup_x1 dup_x2 dup2 dup2_x1 dup2_x2 swap iadd ladd fadd dadd isub lsub fsub dsub imul lmul fmul dmul idiv ldiv fdiv ddiv irem lrem frem drem ineg lneg fneg dneg ishl lshl ishr lshr iushr lushr iand land ior lor ixor lxor iinc i2l i2f i2d l2i l2f l2d f2i f2l f2d d2i d2l d2f i2b i2c i2s lcmp fcmpl fcmpg dcmpl dcmpg ifeq ifne iflt ifge ifgt ifle if_icmpeq if_icmpne if_icmplt if_icmpge if_icmpgt if_icmple if_acmpeq if_acmpne goto jsr ret tableswitch lookupswitch ireturn lreturn freturn dreturn areturn return getstatic putstatic getfield putfield invokevirtual invokespecial invokestatic invokeinterface xxxunusedxxx new newarray anewarray arraylength athrow checkcast instanceof monitorenter monitorexit wide multianewarray ifnull ifnonnull goto_w jsr_w ";
        int bc = 0;
        while (names.length() > 0) {
            int sp = names.indexOf(32);
            Instruction.BC_NAME[bc] = names.substring(0, sp);
            names = names.substring(sp + 1);
            ++bc;
        }
        BW = 4;
    }

    static class FormatException
    extends IOException {
        private static final long serialVersionUID = 3175572275651367015L;

        FormatException(String message) {
            super(message);
        }
    }

    public static class LookupSwitch
    extends Switch {
        @Override
        public int getCaseCount() {
            return this.intAt(1);
        }

        @Override
        public int getCaseValue(int n) {
            return this.intAt(2 + n * 2 + 0);
        }

        @Override
        public int getCaseLabel(int n) {
            return this.intAt(2 + n * 2 + 1) + this.pc;
        }

        @Override
        public void setCaseCount(int caseCount) {
            this.setIntAt(1, caseCount);
            this.length = this.getLength(caseCount);
        }

        @Override
        public void setCaseValue(int n, int val) {
            this.setIntAt(2 + n * 2 + 0, val);
        }

        @Override
        public void setCaseLabel(int n, int tpc) {
            this.setIntAt(2 + n * 2 + 1, tpc - this.pc);
        }

        LookupSwitch(byte[] bytes, int pc) {
            super(bytes, pc, 171);
        }

        @Override
        protected int getLength(int caseCount) {
            return this.apc - this.pc + (2 + caseCount * 2) * 4;
        }
    }

    public static class TableSwitch
    extends Switch {
        public int getLowCase() {
            return this.intAt(1);
        }

        public int getHighCase() {
            return this.intAt(2);
        }

        @Override
        public int getCaseCount() {
            return this.intAt(2) - this.intAt(1) + 1;
        }

        @Override
        public int getCaseValue(int n) {
            return this.getLowCase() + n;
        }

        @Override
        public int getCaseLabel(int n) {
            return this.intAt(3 + n) + this.pc;
        }

        public void setLowCase(int val) {
            this.setIntAt(1, val);
        }

        public void setHighCase(int val) {
            this.setIntAt(2, val);
        }

        @Override
        public void setCaseLabel(int n, int tpc) {
            this.setIntAt(3 + n, tpc - this.pc);
        }

        @Override
        public void setCaseCount(int caseCount) {
            this.setHighCase(this.getLowCase() + caseCount - 1);
            this.length = this.getLength(caseCount);
        }

        @Override
        public void setCaseValue(int n, int val) {
            if (n != 0) {
                throw new UnsupportedOperationException();
            }
            int caseCount = this.getCaseCount();
            this.setLowCase(val);
            this.setCaseCount(caseCount);
        }

        TableSwitch(byte[] bytes, int pc) {
            super(bytes, pc, 170);
        }

        @Override
        protected int getLength(int caseCount) {
            return this.apc - this.pc + (3 + caseCount) * 4;
        }
    }

    public static abstract class Switch
    extends Instruction {
        protected int apc;

        public abstract int getCaseCount();

        public abstract int getCaseValue(int var1);

        public abstract int getCaseLabel(int var1);

        public abstract void setCaseCount(int var1);

        public abstract void setCaseValue(int var1, int var2);

        public abstract void setCaseLabel(int var1, int var2);

        protected abstract int getLength(int var1);

        public int getDefaultLabel() {
            return this.intAt(0) + this.pc;
        }

        public void setDefaultLabel(int targetPC) {
            this.setIntAt(0, targetPC - this.pc);
        }

        protected int intAt(int n) {
            return Switch.getInt(this.bytes, this.apc + n * 4);
        }

        protected void setIntAt(int n, int x) {
            Switch.setInt(this.bytes, this.apc + n * 4, x);
        }

        protected Switch(byte[] bytes, int pc, int bc) {
            super(bytes, pc, bc, 0, 0);
            this.apc = Switch.alignPC(pc + 1);
            this.special = true;
            this.length = this.getLength(this.getCaseCount());
        }

        public int getAlignedPC() {
            return this.apc;
        }

        @Override
        public String toString() {
            String s = super.toString();
            s = s + " Default:" + Switch.labstr(this.getDefaultLabel());
            int caseCount = this.getCaseCount();
            for (int i = 0; i < caseCount; ++i) {
                s = s + "\n\tCase " + this.getCaseValue(i) + ":" + Switch.labstr(this.getCaseLabel(i));
            }
            return s;
        }

        public static int alignPC(int apc) {
            while (apc % 4 != 0) {
                ++apc;
            }
            return apc;
        }
    }
}

