/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.spi;

import com.sun.rowset.providers.RIOptimisticProvider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.sql.rowset.spi.ProviderImpl;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import sun.reflect.misc.ReflectUtil;

public class SyncFactory {
    public static final String ROWSET_SYNC_PROVIDER = "rowset.provider.classname";
    public static final String ROWSET_SYNC_VENDOR = "rowset.provider.vendor";
    public static final String ROWSET_SYNC_PROVIDER_VERSION = "rowset.provider.version";
    private static String ROWSET_PROPERTIES = "rowset.properties";
    private static String default_provider = "com.sun.rowset.providers.RIOptimisticProvider";
    private static final SQLPermission SET_SYNCFACTORY_PERMISSION = new SQLPermission("setSyncFactory");
    private static Context ic;
    private static volatile Logger rsLogger;
    private static Level rsLevel;
    private static Hashtable implementations;
    private static Object logSync;
    private static PrintWriter logWriter;
    private static String colon;
    private static String strFileSep;
    private static boolean debug;
    private static int providerImplIndex;
    private static boolean lazyJNDICtxRefresh;

    private SyncFactory() {
    }

    public static synchronized void registerProvider(String providerID) throws SyncFactoryException {
        ProviderImpl impl = new ProviderImpl();
        impl.setClassname(providerID);
        SyncFactory.initMapIfNecessary();
        implementations.put(providerID, impl);
    }

    public static SyncFactory getSyncFactory() {
        return SyncFactoryHolder.factory;
    }

    public static synchronized void unregisterProvider(String providerID) throws SyncFactoryException {
        SyncFactory.initMapIfNecessary();
        if (implementations.containsKey(providerID)) {
            implementations.remove(providerID);
        }
    }

    private static synchronized void initMapIfNecessary() throws SyncFactoryException {
        final Properties properties = new Properties();
        if (implementations == null) {
            String providerImpls;
            implementations = new Hashtable();
            try {
                String strRowsetProperties;
                try {
                    strRowsetProperties = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty("rowset.properties");
                        }
                    });
                }
                catch (Exception ex) {
                    System.out.println("errorget rowset.properties: " + ex);
                    strRowsetProperties = null;
                }
                if (strRowsetProperties != null) {
                    ROWSET_PROPERTIES = strRowsetProperties;
                    try (FileInputStream fis = new FileInputStream(ROWSET_PROPERTIES);){
                        properties.load(fis);
                    }
                    SyncFactory.parseProperties(properties);
                }
                ROWSET_PROPERTIES = "javax" + strFileSep + "sql" + strFileSep + "rowset" + strFileSep + "rowset.properties";
                final ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws SyncFactoryException, IOException, FileNotFoundException {
                            try (InputStream stream = cl == null ? ClassLoader.getSystemResourceAsStream(ROWSET_PROPERTIES) : cl.getResourceAsStream(ROWSET_PROPERTIES);){
                                if (stream == null) {
                                    throw new SyncFactoryException("Resource " + ROWSET_PROPERTIES + " not found");
                                }
                                properties.load(stream);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    Exception e = ex.getException();
                    if (e instanceof SyncFactoryException) {
                        throw (SyncFactoryException)e;
                    }
                    SyncFactoryException sfe = new SyncFactoryException();
                    sfe.initCause(ex.getException());
                    throw sfe;
                }
                SyncFactory.parseProperties(properties);
            }
            catch (FileNotFoundException e) {
                throw new SyncFactoryException("Cannot locate properties file: " + e);
            }
            catch (IOException e) {
                throw new SyncFactoryException("IOException: " + e);
            }
            properties.clear();
            try {
                providerImpls = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(SyncFactory.ROWSET_SYNC_PROVIDER);
                    }
                });
            }
            catch (Exception ex) {
                providerImpls = null;
            }
            if (providerImpls != null) {
                int i = 0;
                if (providerImpls.indexOf(colon) > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(providerImpls, colon);
                    while (tokenizer.hasMoreElements()) {
                        properties.put("rowset.provider.classname." + i, tokenizer.nextToken());
                        ++i;
                    }
                } else {
                    properties.put(ROWSET_SYNC_PROVIDER, providerImpls);
                }
                SyncFactory.parseProperties(properties);
            }
        }
    }

    private static void parseProperties(Properties p) {
        ProviderImpl impl = null;
        String key = null;
        String[] propertyNames = null;
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            int w = str.length();
            if (!str.startsWith(ROWSET_SYNC_PROVIDER)) continue;
            impl = new ProviderImpl();
            impl.setIndex(providerImplIndex++);
            propertyNames = w == ROWSET_SYNC_PROVIDER.length() ? SyncFactory.getPropertyNames(false) : SyncFactory.getPropertyNames(true, str.substring(w - 1));
            key = p.getProperty(propertyNames[0]);
            impl.setClassname(key);
            impl.setVendor(p.getProperty(propertyNames[1]));
            impl.setVersion(p.getProperty(propertyNames[2]));
            implementations.put(key, impl);
        }
    }

    private static String[] getPropertyNames(boolean append) {
        return SyncFactory.getPropertyNames(append, null);
    }

    private static String[] getPropertyNames(boolean append, String propertyIndex) {
        String dot = ".";
        String[] propertyNames = new String[]{ROWSET_SYNC_PROVIDER, ROWSET_SYNC_VENDOR, ROWSET_SYNC_PROVIDER_VERSION};
        if (append) {
            for (int i = 0; i < propertyNames.length; ++i) {
                propertyNames[i] = propertyNames[i] + dot + propertyIndex;
            }
            return propertyNames;
        }
        return propertyNames;
    }

    private static void showImpl(ProviderImpl impl) {
        System.out.println("Provider implementation:");
        System.out.println("Classname: " + impl.getClassname());
        System.out.println("Vendor: " + impl.getVendor());
        System.out.println("Version: " + impl.getVersion());
        System.out.println("Impl index: " + impl.getIndex());
    }

    public static SyncProvider getInstance(String providerID) throws SyncFactoryException {
        if (providerID == null) {
            throw new SyncFactoryException("The providerID cannot be null");
        }
        SyncFactory.initMapIfNecessary();
        SyncFactory.initJNDIContext();
        ProviderImpl impl = (ProviderImpl)implementations.get(providerID);
        if (impl == null) {
            return new RIOptimisticProvider();
        }
        try {
            ReflectUtil.checkPackageAccess(providerID);
        }
        catch (AccessControlException e) {
            SyncFactoryException sfe = new SyncFactoryException();
            sfe.initCause(e);
            throw sfe;
        }
        Class<?> c = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            c = Class.forName(providerID, true, cl);
            if (c != null) {
                return (SyncProvider)c.newInstance();
            }
            return new RIOptimisticProvider();
        }
        catch (IllegalAccessException e) {
            throw new SyncFactoryException("IllegalAccessException: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new SyncFactoryException("InstantiationException: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new SyncFactoryException("ClassNotFoundException: " + e.getMessage());
        }
    }

    public static Enumeration<SyncProvider> getRegisteredProviders() throws SyncFactoryException {
        SyncFactory.initMapIfNecessary();
        return implementations.elements();
    }

    public static void setLogger(Logger logger) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        if (logger == null) {
            throw new NullPointerException("You must provide a Logger");
        }
        rsLogger = logger;
    }

    public static void setLogger(Logger logger, Level level) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        if (logger == null) {
            throw new NullPointerException("You must provide a Logger");
        }
        logger.setLevel(level);
        rsLogger = logger;
    }

    public static Logger getLogger() throws SyncFactoryException {
        Logger result = rsLogger;
        if (result == null) {
            throw new SyncFactoryException("(SyncFactory) : No logger has been set");
        }
        return result;
    }

    public static synchronized void setJNDIContext(Context ctx) throws SyncFactoryException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        if (ctx == null) {
            throw new SyncFactoryException("Invalid JNDI context supplied");
        }
        ic = ctx;
    }

    private static synchronized void initJNDIContext() throws SyncFactoryException {
        if (ic != null && !lazyJNDICtxRefresh) {
            try {
                SyncFactory.parseProperties(SyncFactory.parseJNDIContext());
                lazyJNDICtxRefresh = true;
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new SyncFactoryException("SPI: NamingException: " + e.getExplanation());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SyncFactoryException("SPI: Exception: " + e.getMessage());
            }
        }
    }

    private static Properties parseJNDIContext() throws NamingException {
        NamingEnumeration<Binding> bindings = ic.listBindings("");
        Properties properties = new Properties();
        SyncFactory.enumerateBindings(bindings, properties);
        return properties;
    }

    private static void enumerateBindings(NamingEnumeration bindings, Properties properties) throws NamingException {
        boolean syncProviderObj = false;
        try {
            Binding bd = null;
            Object elementObj = null;
            String element = null;
            while (bindings.hasMore()) {
                bd = (Binding)bindings.next();
                element = bd.getName();
                elementObj = bd.getObject();
                if (!(ic.lookup(element) instanceof Context) && ic.lookup(element) instanceof SyncProvider) {
                    syncProviderObj = true;
                }
                if (!syncProviderObj) continue;
                SyncProvider sync = (SyncProvider)elementObj;
                properties.put(ROWSET_SYNC_PROVIDER, sync.getProviderID());
                syncProviderObj = false;
            }
        }
        catch (NotContextException e) {
            bindings.next();
            SyncFactory.enumerateBindings(bindings, properties);
        }
    }

    static {
        logSync = new Object();
        logWriter = null;
        colon = ":";
        strFileSep = "/";
        debug = false;
        providerImplIndex = 0;
        lazyJNDICtxRefresh = false;
    }

    private static class SyncFactoryHolder {
        static final SyncFactory factory = new SyncFactory();

        private SyncFactoryHolder() {
        }
    }
}

