/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import sun.security.action.LoadLibraryAction;

public class SCDynamicStoreConfig {
    private static native void installNotificationCallback();

    private static native Hashtable<String, Object> getKerberosConfig();

    private static Vector<String> unwrapHost(Collection<Hashtable<String, String>> c) {
        Vector<String> vector = new Vector<String>();
        for (Hashtable<String, String> m : c) {
            vector.add(m.get("host"));
        }
        return vector;
    }

    private static Hashtable<String, Object> convertRealmConfigs(Hashtable<String, ?> configs) {
        Hashtable<String, Object> realmsTable = new Hashtable<String, Object>();
        for (String realm : configs.keySet()) {
            Collection kadmin;
            Hashtable map = (Hashtable)configs.get(realm);
            Collection kdc = (Collection)map.get("kdc");
            Hashtable<String, Vector<String>> realmMap = new Hashtable<String, Vector<String>>();
            if (kdc != null) {
                realmMap.put("kdc", SCDynamicStoreConfig.unwrapHost(kdc));
            }
            if ((kadmin = (Collection)map.get("kadmin")) != null) {
                realmMap.put("admin_server", SCDynamicStoreConfig.unwrapHost(kadmin));
            }
            realmsTable.put(realm, realmMap);
        }
        return realmsTable;
    }

    public static Hashtable<String, Object> getConfig() throws IOException {
        Hashtable<String, Object> stanzaTable = SCDynamicStoreConfig.getKerberosConfig();
        if (stanzaTable == null) {
            throw new IOException("Could not load configuration from SCDynamicStore");
        }
        Hashtable realms = (Hashtable)stanzaTable.get("realms");
        if (realms != null) {
            stanzaTable.remove("realms");
            Hashtable<String, Object> realmsTable = SCDynamicStoreConfig.convertRealmConfigs(realms);
            stanzaTable.put("realms", realmsTable);
        }
        return stanzaTable;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("osx"));
        SCDynamicStoreConfig.installNotificationCallback();
    }
}

