/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.Attribute;
import javax.management.RuntimeOperationsException;

public class AttributeList
extends ArrayList<Object> {
    private volatile transient boolean typeSafe;
    private volatile transient boolean tainted;
    private static final long serialVersionUID = -4077085769279709076L;

    public AttributeList() {
    }

    public AttributeList(int initialCapacity) {
        super(initialCapacity);
    }

    public AttributeList(AttributeList list) {
        super(list);
    }

    public AttributeList(List<Attribute> list) {
        if (list == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.adding(list);
        super.addAll(list);
    }

    public List<Attribute> asList() {
        this.typeSafe = true;
        if (this.tainted) {
            this.adding(this);
        }
        return this;
    }

    public void add(Attribute object) {
        super.add(object);
    }

    @Override
    public void add(int index, Attribute object) {
        try {
            super.add(index, object);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeOperationsException(e, "The specified index is out of range");
        }
    }

    @Override
    public void set(int index, Attribute object) {
        try {
            super.set(index, object);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeOperationsException(e, "The specified index is out of range");
        }
    }

    public boolean addAll(AttributeList list) {
        return super.addAll(list);
    }

    public boolean addAll(int index, AttributeList list) {
        try {
            return super.addAll(index, list);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeOperationsException(e, "The specified index is out of range");
        }
    }

    @Override
    public boolean add(Object element) {
        this.adding(element);
        return super.add(element);
    }

    @Override
    public void add(int index, Object element) {
        this.adding(element);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        this.adding(c);
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        this.adding(c);
        return super.addAll(index, c);
    }

    @Override
    public Object set(int index, Object element) {
        this.adding(element);
        return super.set(index, element);
    }

    private void adding(Object x) {
        if (x == null || x instanceof Attribute) {
            return;
        }
        if (this.typeSafe) {
            throw new IllegalArgumentException("Not an Attribute: " + x);
        }
        this.tainted = true;
    }

    private void adding(Collection<?> c) {
        for (Object x : c) {
            this.adding(x);
        }
    }
}

