/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Color;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLSurfaceData;

public class OGLSurfaceDataProxy
extends SurfaceDataProxy {
    OGLGraphicsConfig oglgc;
    int transparency;

    public static SurfaceDataProxy createProxy(SurfaceData srcData, OGLGraphicsConfig dstConfig) {
        if (srcData instanceof OGLSurfaceData) {
            return UNCACHED;
        }
        return new OGLSurfaceDataProxy(dstConfig, srcData.getTransparency());
    }

    public OGLSurfaceDataProxy(OGLGraphicsConfig oglgc, int transparency) {
        this.oglgc = oglgc;
        this.transparency = transparency;
    }

    @Override
    public SurfaceData validateSurfaceData(SurfaceData srcData, SurfaceData cachedData, int w, int h) {
        if (cachedData == null) {
            try {
                cachedData = this.oglgc.createManagedSurface(w, h, this.transparency);
            }
            catch (OutOfMemoryError er) {
                return null;
            }
        }
        return cachedData;
    }

    @Override
    public boolean isSupportedOperation(SurfaceData srcData, int txtype, CompositeType comp, Color bgColor) {
        return comp.isDerivedFrom(CompositeType.AnyAlpha) && (bgColor == null || this.transparency == 1);
    }
}

