/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class IndexedCollectionCertStore
extends CertStoreSpi {
    private Map<X500Principal, Object> certSubjects;
    private Map<X500Principal, Object> crlIssuers;
    private Set<Certificate> otherCertificates;
    private Set<CRL> otherCRLs;

    public IndexedCollectionCertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (!(params instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be CollectionCertStoreParameters");
        }
        Collection<?> coll = ((CollectionCertStoreParameters)params).getCollection();
        if (coll == null) {
            throw new InvalidAlgorithmParameterException("Collection must not be null");
        }
        this.buildIndex(coll);
    }

    private void buildIndex(Collection<?> coll) {
        this.certSubjects = new HashMap<X500Principal, Object>();
        this.crlIssuers = new HashMap<X500Principal, Object>();
        this.otherCertificates = null;
        this.otherCRLs = null;
        for (Object obj : coll) {
            if (obj instanceof X509Certificate) {
                this.indexCertificate((X509Certificate)obj);
                continue;
            }
            if (obj instanceof X509CRL) {
                this.indexCRL((X509CRL)obj);
                continue;
            }
            if (obj instanceof Certificate) {
                if (this.otherCertificates == null) {
                    this.otherCertificates = new HashSet<Certificate>();
                }
                this.otherCertificates.add((Certificate)obj);
                continue;
            }
            if (!(obj instanceof CRL)) continue;
            if (this.otherCRLs == null) {
                this.otherCRLs = new HashSet<CRL>();
            }
            this.otherCRLs.add((CRL)obj);
        }
        if (this.otherCertificates == null) {
            this.otherCertificates = Collections.emptySet();
        }
        if (this.otherCRLs == null) {
            this.otherCRLs = Collections.emptySet();
        }
    }

    private void indexCertificate(X509Certificate cert) {
        X500Principal subject = cert.getSubjectX500Principal();
        Object oldEntry = this.certSubjects.put(subject, cert);
        if (oldEntry != null) {
            if (oldEntry instanceof X509Certificate) {
                if (cert.equals(oldEntry)) {
                    return;
                }
                ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(2);
                list.add(cert);
                list.add((X509Certificate)oldEntry);
                this.certSubjects.put(subject, list);
            } else {
                List list = (List)oldEntry;
                if (!list.contains(cert)) {
                    list.add(cert);
                }
                this.certSubjects.put(subject, list);
            }
        }
    }

    private void indexCRL(X509CRL crl) {
        X500Principal issuer = crl.getIssuerX500Principal();
        Object oldEntry = this.crlIssuers.put(issuer, crl);
        if (oldEntry != null) {
            if (oldEntry instanceof X509CRL) {
                if (crl.equals(oldEntry)) {
                    return;
                }
                ArrayList<X509CRL> list = new ArrayList<X509CRL>(2);
                list.add(crl);
                list.add((X509CRL)oldEntry);
                this.crlIssuers.put(issuer, list);
            } else {
                List list = (List)oldEntry;
                if (!list.contains(crl)) {
                    list.add(crl);
                }
                this.crlIssuers.put(issuer, list);
            }
        }
    }

    @Override
    public Collection<? extends Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        if (selector == null) {
            HashSet<Certificate> matches = new HashSet<Certificate>();
            this.matchX509Certs(new X509CertSelector(), matches);
            matches.addAll(this.otherCertificates);
            return matches;
        }
        if (!(selector instanceof X509CertSelector)) {
            HashSet<Certificate> matches = new HashSet<Certificate>();
            this.matchX509Certs(selector, matches);
            for (Certificate cert : this.otherCertificates) {
                if (!selector.match(cert)) continue;
                matches.add(cert);
            }
            return matches;
        }
        if (this.certSubjects.isEmpty()) {
            return Collections.emptySet();
        }
        X509CertSelector x509Selector = (X509CertSelector)selector;
        X509Certificate matchCert = x509Selector.getCertificate();
        X500Principal subject = matchCert != null ? matchCert.getSubjectX500Principal() : x509Selector.getSubject();
        if (subject != null) {
            Object entry = this.certSubjects.get(subject);
            if (entry == null) {
                return Collections.emptySet();
            }
            if (entry instanceof X509Certificate) {
                X509Certificate x509Entry = (X509Certificate)entry;
                if (x509Selector.match(x509Entry)) {
                    return Collections.singleton(x509Entry);
                }
                return Collections.emptySet();
            }
            List list = (List)entry;
            HashSet<X509Certificate> matches = new HashSet<X509Certificate>(16);
            for (X509Certificate cert : list) {
                if (!x509Selector.match(cert)) continue;
                matches.add(cert);
            }
            return matches;
        }
        HashSet<Certificate> matches = new HashSet<Certificate>(16);
        this.matchX509Certs(x509Selector, matches);
        return matches;
    }

    private void matchX509Certs(CertSelector selector, Collection<Certificate> matches) {
        for (Object obj : this.certSubjects.values()) {
            if (obj instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)obj;
                if (!selector.match(cert)) continue;
                matches.add(cert);
                continue;
            }
            List list = (List)obj;
            for (X509Certificate cert : list) {
                if (!selector.match(cert)) continue;
                matches.add(cert);
            }
        }
    }

    public Collection<CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (selector == null) {
            HashSet<CRL> matches = new HashSet<CRL>();
            this.matchX509CRLs(new X509CRLSelector(), matches);
            matches.addAll(this.otherCRLs);
            return matches;
        }
        if (!(selector instanceof X509CRLSelector)) {
            HashSet<CRL> matches = new HashSet<CRL>();
            this.matchX509CRLs(selector, matches);
            for (CRL crl : this.otherCRLs) {
                if (!selector.match(crl)) continue;
                matches.add(crl);
            }
            return matches;
        }
        if (this.crlIssuers.isEmpty()) {
            return Collections.emptySet();
        }
        X509CRLSelector x509Selector = (X509CRLSelector)selector;
        Collection<X500Principal> issuers = x509Selector.getIssuers();
        if (issuers != null) {
            HashSet<CRL> matches = new HashSet<CRL>(16);
            for (X500Principal issuer : issuers) {
                Object entry = this.crlIssuers.get(issuer);
                if (entry == null) continue;
                if (entry instanceof X509CRL) {
                    X509CRL crl = (X509CRL)entry;
                    if (!x509Selector.match(crl)) continue;
                    matches.add(crl);
                    continue;
                }
                List list = (List)entry;
                for (X509CRL crl : list) {
                    if (!x509Selector.match(crl)) continue;
                    matches.add(crl);
                }
            }
            return matches;
        }
        HashSet<CRL> matches = new HashSet<CRL>(16);
        this.matchX509CRLs(x509Selector, matches);
        return matches;
    }

    private void matchX509CRLs(CRLSelector selector, Collection<CRL> matches) {
        for (Object obj : this.crlIssuers.values()) {
            if (obj instanceof X509CRL) {
                X509CRL crl = (X509CRL)obj;
                if (!selector.match(crl)) continue;
                matches.add(crl);
                continue;
            }
            List list = (List)obj;
            for (X509CRL crl : list) {
                if (!selector.match(crl)) continue;
                matches.add(crl);
            }
        }
    }
}

