/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Vector;

public class Book
implements Pageable {
    private Vector mPages = new Vector();

    @Override
    public int getNumberOfPages() {
        return this.mPages.size();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.getPage(pageIndex).getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this.getPage(pageIndex).getPrintable();
    }

    public void setPage(int pageIndex, Printable painter, PageFormat page) throws IndexOutOfBoundsException {
        if (painter == null) {
            throw new NullPointerException("painter is null");
        }
        if (page == null) {
            throw new NullPointerException("page is null");
        }
        this.mPages.setElementAt(new BookPage(painter, page), pageIndex);
    }

    public void append(Printable painter, PageFormat page) {
        this.mPages.addElement(new BookPage(painter, page));
    }

    public void append(Printable painter, PageFormat page, int numPages) {
        BookPage bookPage = new BookPage(painter, page);
        int pageIndex = this.mPages.size();
        int newSize = pageIndex + numPages;
        this.mPages.setSize(newSize);
        for (int i = pageIndex; i < newSize; ++i) {
            this.mPages.setElementAt(bookPage, i);
        }
    }

    private BookPage getPage(int pageIndex) throws ArrayIndexOutOfBoundsException {
        return (BookPage)this.mPages.elementAt(pageIndex);
    }

    private class BookPage {
        private PageFormat mFormat;
        private Printable mPainter;

        BookPage(Printable painter, PageFormat format) {
            if (painter == null || format == null) {
                throw new NullPointerException();
            }
            this.mFormat = format;
            this.mPainter = painter;
        }

        Printable getPrintable() {
            return this.mPainter;
        }

        PageFormat getPageFormat() {
            return this.mFormat;
        }
    }
}

