/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public final class UntrustedCertificates {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String ALGORITHM_KEY = "Algorithm";
    private static final Properties props = new Properties();
    private static final String algorithm;

    private static String stripColons(Object input) {
        String s = (String)input;
        char[] letters = s.toCharArray();
        int pos = 0;
        for (int i = 0; i < letters.length; ++i) {
            if (letters[i] == ':') continue;
            if (i != pos) {
                letters[pos] = letters[i];
            }
            ++pos;
        }
        if (pos == letters.length) {
            return s;
        }
        return new String(letters, 0, pos);
    }

    public static boolean isUntrusted(X509Certificate cert) {
        String key;
        if (algorithm == null) {
            return false;
        }
        if (cert instanceof X509CertImpl) {
            key = ((X509CertImpl)cert).getFingerprint(algorithm);
        } else {
            try {
                key = new X509CertImpl(cert.getEncoded()).getFingerprint(algorithm);
            }
            catch (CertificateException cee) {
                return false;
            }
        }
        return props.containsKey(key);
    }

    private UntrustedCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block15: {
                    File f = new File(System.getProperty("java.home"), "lib/security/blacklisted.certs");
                    try (FileInputStream fin = new FileInputStream(f);){
                        props.load(fin);
                        for (Map.Entry entry : props.entrySet()) {
                            entry.setValue(UntrustedCertificates.stripColons(entry.getValue()));
                        }
                    }
                    catch (IOException fnfe) {
                        if (debug == null) break block15;
                        debug.println("Error parsing blacklisted.certs");
                    }
                }
                return null;
            }
        });
        algorithm = props.getProperty(ALGORITHM_KEY);
    }
}

