/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import sun.invoke.util.Wrapper;

public class BytecodeDescriptor {
    private BytecodeDescriptor() {
    }

    public static List<Class<?>> parseMethod(String bytecodeSignature, ClassLoader loader) {
        return BytecodeDescriptor.parseMethod(bytecodeSignature, 0, bytecodeSignature.length(), loader);
    }

    static List<Class<?>> parseMethod(String bytecodeSignature, int start, int end, ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String str = bytecodeSignature;
        int[] i = new int[]{start};
        ArrayList ptypes = new ArrayList();
        if (i[0] < end && str.charAt(i[0]) == '(') {
            i[0] = i[0] + 1;
            while (i[0] < end && str.charAt(i[0]) != ')') {
                Class<?> pt = BytecodeDescriptor.parseSig(str, i, end, loader);
                if (pt == null || pt == Void.TYPE) {
                    BytecodeDescriptor.parseError(str, "bad argument type");
                }
                ptypes.add(pt);
            }
            i[0] = i[0] + 1;
        } else {
            BytecodeDescriptor.parseError(str, "not a method type");
        }
        Class<?> rtype = BytecodeDescriptor.parseSig(str, i, end, loader);
        if (rtype == null || i[0] != end) {
            BytecodeDescriptor.parseError(str, "bad return type");
        }
        ptypes.add(rtype);
        return ptypes;
    }

    private static void parseError(String str, String msg) {
        throw new IllegalArgumentException("bad signature: " + str + ": " + msg);
    }

    private static Class<?> parseSig(String str, int[] i, int end, ClassLoader loader) {
        if (i[0] == end) {
            return null;
        }
        int n = i[0];
        i[0] = n + 1;
        char c = str.charAt(n);
        if (c == 'L') {
            int begc = i[0];
            int endc = str.indexOf(59, begc);
            if (endc < 0) {
                return null;
            }
            i[0] = endc + 1;
            String name = str.substring(begc, endc).replace('/', '.');
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                throw new TypeNotPresentException(name, ex);
            }
        }
        if (c == '[') {
            Class<?> t = BytecodeDescriptor.parseSig(str, i, end, loader);
            if (t != null) {
                t = Array.newInstance(t, 0).getClass();
            }
            return t;
        }
        return Wrapper.forBasicType(c).primitiveType();
    }

    public static String unparse(Class<?> type) {
        StringBuilder sb = new StringBuilder();
        BytecodeDescriptor.unparseSig(type, sb);
        return sb.toString();
    }

    public static String unparse(MethodType type) {
        return BytecodeDescriptor.unparseMethod(type.returnType(), type.parameterList());
    }

    public static String unparse(Object type) {
        if (type instanceof Class) {
            return BytecodeDescriptor.unparse((Class)type);
        }
        if (type instanceof MethodType) {
            return BytecodeDescriptor.unparse((MethodType)type);
        }
        return (String)type;
    }

    public static String unparseMethod(Class<?> rtype, List<Class<?>> ptypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Class<?> pt : ptypes) {
            BytecodeDescriptor.unparseSig(pt, sb);
        }
        sb.append(')');
        BytecodeDescriptor.unparseSig(rtype, sb);
        return sb.toString();
    }

    private static void unparseSig(Class<?> t, StringBuilder sb) {
        char c = Wrapper.forBasicType(t).basicTypeChar();
        if (c != 'L') {
            sb.append(c);
        } else {
            boolean lsemi;
            boolean bl = lsemi = !t.isArray();
            if (lsemi) {
                sb.append('L');
            }
            sb.append(t.getName().replace('.', '/'));
            if (lsemi) {
                sb.append(';');
            }
        }
    }
}

