/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XIMCallback
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    @Override
    public int getDataSize() {
        return XIMCallback.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XIMCallback(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XIMCallback() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XIMCallback.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_client_data(int index) {
        log.finest("");
        return Native.getLong(this.pData + 0L) + (long)(index * Native.getLongSize());
    }

    public long get_client_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_client_data(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public long get_callback(int index) {
        log.finest("");
        return Native.getLong(this.pData + 8L) + (long)(index * Native.getLongSize());
    }

    public long get_callback() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_callback(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    @Override
    String getName() {
        return "XIMCallback";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(80);
        ret.append("client_data = ").append(this.get_client_data()).append(", ");
        ret.append("callback = ").append(this.get_callback()).append(", ");
        return ret.toString();
    }
}

