/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.management.remote.TargetedNotification;

public class NotificationResult
implements Serializable {
    private static final long serialVersionUID = 1191800228721395279L;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private TargetedNotification[] targetedNotifications;

    public NotificationResult(long earliestSequenceNumber, long nextSequenceNumber, TargetedNotification[] targetedNotifications) {
        NotificationResult.validate(targetedNotifications, earliestSequenceNumber, nextSequenceNumber);
        this.earliestSequenceNumber = earliestSequenceNumber;
        this.nextSequenceNumber = nextSequenceNumber;
        this.targetedNotifications = targetedNotifications.length == 0 ? targetedNotifications : (TargetedNotification[])targetedNotifications.clone();
    }

    public long getEarliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    public long getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public TargetedNotification[] getTargetedNotifications() {
        return this.targetedNotifications.length == 0 ? this.targetedNotifications : (TargetedNotification[])this.targetedNotifications.clone();
    }

    public String toString() {
        return "NotificationResult: earliest=" + this.getEarliestSequenceNumber() + "; next=" + this.getNextSequenceNumber() + "; nnotifs=" + this.getTargetedNotifications().length;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            NotificationResult.validate(this.targetedNotifications, this.earliestSequenceNumber, this.nextSequenceNumber);
            this.targetedNotifications = this.targetedNotifications.length == 0 ? this.targetedNotifications : (TargetedNotification[])this.targetedNotifications.clone();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    private static void validate(TargetedNotification[] targetedNotifications, long earliestSequenceNumber, long nextSequenceNumber) throws IllegalArgumentException {
        if (targetedNotifications == null) {
            String msg = "Notifications null";
            throw new IllegalArgumentException("Notifications null");
        }
        if (earliestSequenceNumber < 0L || nextSequenceNumber < 0L) {
            throw new IllegalArgumentException("Bad sequence numbers");
        }
    }
}

