/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import sun.misc.Unsafe;
import sun.nio.ch.IOUtil;

class KQueue {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int SIZEOF_KQUEUEEVENT = KQueue.keventSize();
    private static final int OFFSET_IDENT = KQueue.identOffset();
    private static final int OFFSET_FILTER = KQueue.filterOffset();
    private static final int OFFSET_FLAGS = KQueue.flagsOffset();
    static final int EVFILT_READ = -1;
    static final int EVFILT_WRITE = -2;
    static final int EV_ADD = 1;
    static final int EV_ONESHOT = 16;
    static final int EV_CLEAR = 32;

    private KQueue() {
    }

    static long allocatePollArray(int count) {
        return unsafe.allocateMemory(count * SIZEOF_KQUEUEEVENT);
    }

    static void freePollArray(long address) {
        unsafe.freeMemory(address);
    }

    static long getEvent(long address, int i) {
        return address + (long)(SIZEOF_KQUEUEEVENT * i);
    }

    static int getDescriptor(long address) {
        return unsafe.getInt(address + (long)OFFSET_IDENT);
    }

    static int getFilter(long address) {
        return unsafe.getShort(address + (long)OFFSET_FILTER);
    }

    static int getFlags(long address) {
        return unsafe.getShort(address + (long)OFFSET_FLAGS);
    }

    private static native int keventSize();

    private static native int identOffset();

    private static native int filterOffset();

    private static native int flagsOffset();

    static native int kqueue() throws IOException;

    static native int keventRegister(int var0, int var1, int var2, int var3);

    static native int keventPoll(int var0, long var1, int var3) throws IOException;

    static {
        IOUtil.load();
    }
}

