/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.ValueExp;

class NumericValueExp
extends QueryEval
implements ValueExp {
    private static final long oldSerialVersionUID = -6227876276058904000L;
    private static final long newSerialVersionUID = -4679739485102359104L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("longVal", Long.TYPE), new ObjectStreamField("doubleVal", Double.TYPE), new ObjectStreamField("valIsLong", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("val", Number.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private Number val = 0.0;
    private static boolean compat;

    public NumericValueExp() {
    }

    NumericValueExp(Number val) {
        this.val = val;
    }

    public double doubleValue() {
        if (this.val instanceof Long || this.val instanceof Integer) {
            return this.val.longValue();
        }
        return this.val.doubleValue();
    }

    public long longValue() {
        if (this.val instanceof Long || this.val instanceof Integer) {
            return this.val.longValue();
        }
        return (long)this.val.doubleValue();
    }

    public boolean isLong() {
        return this.val instanceof Long || this.val instanceof Integer;
    }

    public String toString() {
        if (this.val == null) {
            return "null";
        }
        if (this.val instanceof Long || this.val instanceof Integer) {
            return Long.toString(this.val.longValue());
        }
        double d = this.val.doubleValue();
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "(1.0 / 0.0)" : "(-1.0 / 0.0)";
        }
        if (Double.isNaN(d)) {
            return "(0.0 / 0.0)";
        }
        return Double.toString(d);
    }

    @Override
    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        return this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            double doubleVal = fields.get("doubleVal", 0.0);
            if (fields.defaulted("doubleVal")) {
                throw new NullPointerException("doubleVal");
            }
            long longVal = fields.get("longVal", 0L);
            if (fields.defaulted("longVal")) {
                throw new NullPointerException("longVal");
            }
            boolean isLong = fields.get("valIsLong", false);
            if (fields.defaulted("valIsLong")) {
                throw new NullPointerException("valIsLong");
            }
            this.val = isLong ? (Number)longVal : (Number)doubleVal;
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("doubleVal", this.doubleValue());
            fields.put("longVal", this.longValue());
            fields.put("valIsLong", this.isLong());
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    @Override
    @Deprecated
    public void setMBeanServer(MBeanServer s) {
        super.setMBeanServer(s);
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -6227876276058904000L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -4679739485102359104L;
        }
    }
}

