/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.httpbinding;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.httpbinding.AwsHttpBindingCaller;
import amazon.fws.clicommando.processors.service.AbstractScaffoldCallProcessor;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.ServiceCaller;
import amazon.fws.clicommando.processors.service.ServiceScaffold;
import amazon.fws.clicommando.util.AwsConventionsHelper;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsHttpBindingCallProcessor
extends AbstractScaffoldCallProcessor
implements ServiceScaffold {
    static final String SSL_ENCRYPTION_ONLY_PARAMETER = "SSLEncryptionOnly";
    static final String URI_PATH = "uri-path";
    String uriPath;

    @Override
    public void configureScaffold(Map<String, String> config) {
        this.awsCallConfig = new ServiceCallConfig();
        this.uriPath = config.get(URI_PATH);
        this.awsCallConfig.setTimeout(30);
        this.awsCallConfig.setServiceUrl(config.get("url"));
        this.awsCallConfig.setHttpMethod(config.get("http-method"));
        if (this.uriPath == null) {
            throw new IllegalArgumentException("Cannot determine resource uri.");
        }
        if (this.awsCallConfig.getHttpMethod() == null || this.awsCallConfig.getHttpMethod().isEmpty()) {
            throw new IllegalArgumentException("Cannot determine http method.");
        }
        if (this.awsCallConfig.getServiceUrl() == null || this.awsCallConfig.getServiceUrl().isEmpty()) {
            throw new IllegalArgumentException("Cannot determine base service url.");
        }
    }

    @Override
    public void processParameterMap(Command command) {
        this.updateSslForEncryptionOnlyFlag(command);
        this.updateUriPath(command);
        this.setUserAgent(command);
        this.callService(this.getServiceCaller(), command);
    }

    private void updateSslForEncryptionOnlyFlag(Command command) {
        String sslEncryptFlag = command.getCurrentCommandConfig().getParameter(SSL_ENCRYPTION_ONLY_PARAMETER).getValue();
        if (StringUtils.notEmpty(sslEncryptFlag)) {
            this.awsCallConfig.setSslEncryptionOnly(Boolean.parseBoolean(sslEncryptFlag));
        }
    }

    private void updateUriPath(Command command) {
        String originalURI = this.getServiceUrl(command.getCurrentCommandConfig());
        Collection<String> parameterNames = AwsHttpBindingCallProcessor.getParametersFromPath(this.uriPath);
        CommandConfig commandConfig = command.getCurrentCommandConfig();
        StringBuilder resultingUri = new StringBuilder();
        String additionalURI = this.uriPath;
        resultingUri.append(originalURI);
        for (String parameterName : parameterNames) {
            ParamConfig parameter = commandConfig.getParameter(parameterName);
            commandConfig.getParameters().remove(parameterName);
            additionalURI = additionalURI.replace("{" + parameterName + "}", parameter.getValue());
        }
        resultingUri.append(additionalURI);
        this.awsCallConfig.setServiceUrl(resultingUri.toString());
    }

    private void setUserAgent(Command command) {
        String userAgent;
        if (command.getVersion() == null) {
            userAgent = "Amazon CLI";
        } else {
            int loc;
            String version = command.getVersion().toString();
            if (version.charAt(0) == 'A' && (loc = (version = version.trim()).indexOf("Amazon")) == 0) {
                version = version.substring("Amazon".length()).trim();
            }
            userAgent = "Amazon CLI/" + version;
        }
        this.awsCallConfig.setUserAgent(userAgent);
    }

    private static Collection<String> getParametersFromPath(String path) {
        LinkedList<String> parameterNames = new LinkedList<String>();
        String[] rawParameterNames = path.split("\\{");
        for (int i = 1; i < rawParameterNames.length; ++i) {
            String rawParameterName = rawParameterNames[i];
            parameterNames.add(rawParameterName.split("\\}")[0]);
        }
        return parameterNames;
    }

    protected ServiceCaller getServiceCaller() {
        return new AwsHttpBindingCaller(this.awsCallConfig);
    }

    ServiceCallConfig getServiceCallConfig() {
        return this.awsCallConfig;
    }

    private String getServiceUrl(CommandConfig commandConfig) {
        String url = this.awsCallConfig.getServiceUrl();
        if (url != null) {
            String region = commandConfig.doesParameterExist("Region") ? commandConfig.getParameter("Region").getValue() : null;
            return AwsConventionsHelper.setUrlRegion(url, region);
        }
        return url;
    }
}

