/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class FileTime
implements Comparable<FileTime> {
    private final long value;
    private final TimeUnit unit;
    private String valueAsString;
    private DaysAndNanos daysAndNanos;

    private DaysAndNanos asDaysAndNanos() {
        if (this.daysAndNanos == null) {
            this.daysAndNanos = new DaysAndNanos(this.value, this.unit);
        }
        return this.daysAndNanos;
    }

    private FileTime(long value, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        this.value = value;
        this.unit = unit;
    }

    public static FileTime from(long value, TimeUnit unit) {
        return new FileTime(value, unit);
    }

    public static FileTime fromMillis(long value) {
        return new FileTime(value, TimeUnit.MILLISECONDS);
    }

    public long to(TimeUnit unit) {
        return unit.convert(this.value, this.unit);
    }

    public long toMillis() {
        return this.unit.toMillis(this.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof FileTime ? this.compareTo((FileTime)obj) == 0 : false;
    }

    public int hashCode() {
        return this.asDaysAndNanos().hashCode();
    }

    @Override
    public int compareTo(FileTime other) {
        if (this.unit == other.unit) {
            return this.value < other.value ? -1 : (this.value == other.value ? 0 : 1);
        }
        return this.asDaysAndNanos().compareTo(other.asDaysAndNanos());
    }

    public String toString() {
        String v = this.valueAsString;
        if (v == null) {
            long fraction;
            long ms = this.toMillis();
            String fractionAsString = "";
            if (this.unit.compareTo(TimeUnit.SECONDS) < 0 && (fraction = this.asDaysAndNanos().fractionOfSecondInNanos()) != 0L) {
                if (fraction < 0L) {
                    long MAX_FRACTION_PLUS_1 = 1000000000L;
                    fraction += 1000000000L;
                    if (ms != Long.MIN_VALUE) {
                        --ms;
                    }
                }
                String s = Long.toString(fraction);
                int len = s.length();
                int width = 9 - len;
                StringBuilder sb = new StringBuilder(".");
                while (width-- > 0) {
                    sb.append('0');
                }
                if (s.charAt(len - 1) == '0') {
                    --len;
                    while (s.charAt(len - 1) == '0') {
                        --len;
                    }
                    sb.append(s.substring(0, len));
                } else {
                    sb.append(s);
                }
                fractionAsString = sb.toString();
            }
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT);
            if (this.value < 0L) {
                cal.setGregorianChange(new Date(Long.MIN_VALUE));
            }
            cal.setTimeInMillis(ms);
            String sign = cal.get(0) == 0 ? "-" : "";
            this.valueAsString = v = new Formatter(Locale.ROOT).format("%s%tFT%tR:%tS%sZ", sign, cal, cal, cal, fractionAsString).toString();
        }
        return v;
    }

    private static class DaysAndNanos
    implements Comparable<DaysAndNanos> {
        private static final long C0 = 1L;
        private static final long C1 = 24L;
        private static final long C2 = 1440L;
        private static final long C3 = 86400L;
        private static final long C4 = 86400000L;
        private static final long C5 = 86400000000L;
        private static final long C6 = 86400000000000L;
        private final long days;
        private final long excessNanos;

        DaysAndNanos(long value, TimeUnit unit) {
            long scale;
            switch (unit) {
                case DAYS: {
                    scale = 1L;
                    break;
                }
                case HOURS: {
                    scale = 24L;
                    break;
                }
                case MINUTES: {
                    scale = 1440L;
                    break;
                }
                case SECONDS: {
                    scale = 86400L;
                    break;
                }
                case MILLISECONDS: {
                    scale = 86400000L;
                    break;
                }
                case MICROSECONDS: {
                    scale = 86400000000L;
                    break;
                }
                case NANOSECONDS: {
                    scale = 86400000000000L;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unit not handled");
                }
            }
            this.days = unit.toDays(value);
            this.excessNanos = unit.toNanos(value - this.days * scale);
        }

        long fractionOfSecondInNanos() {
            return this.excessNanos % 1000000000L;
        }

        public boolean equals(Object obj) {
            return obj instanceof DaysAndNanos ? this.compareTo((DaysAndNanos)obj) == 0 : false;
        }

        public int hashCode() {
            return (int)(this.days ^ this.days >>> 32 ^ this.excessNanos ^ this.excessNanos >>> 32);
        }

        @Override
        public int compareTo(DaysAndNanos other) {
            if (this.days != other.days) {
                return this.days < other.days ? -1 : 1;
            }
            return this.excessNanos < other.excessNanos ? -1 : (this.excessNanos == other.excessNanos ? 0 : 1);
        }
    }
}

