/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import java.io.IOException;
import java.io.Serializable;

public class ObjectIdReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _idType;
    public final PropertyName propertyName;
    public final ObjectIdGenerator<?> generator;
    protected final JsonDeserializer<Object> _deserializer;
    public final SettableBeanProperty idProperty;

    protected ObjectIdReader(JavaType t, PropertyName propName, ObjectIdGenerator<?> gen, JsonDeserializer<?> deser, SettableBeanProperty idProp) {
        this._idType = t;
        this.propertyName = propName;
        this.generator = gen;
        this._deserializer = deser;
        this.idProperty = idProp;
    }

    @Deprecated
    protected ObjectIdReader(JavaType t, String propName, ObjectIdGenerator<?> gen, JsonDeserializer<?> deser, SettableBeanProperty idProp) {
        this(t, new PropertyName(propName), gen, deser, idProp);
    }

    public static ObjectIdReader construct(JavaType idType, PropertyName propName, ObjectIdGenerator<?> generator, JsonDeserializer<?> deser, SettableBeanProperty idProp) {
        return new ObjectIdReader(idType, propName, generator, deser, idProp);
    }

    @Deprecated
    public static ObjectIdReader construct(JavaType idType, String propName, ObjectIdGenerator<?> generator, JsonDeserializer<?> deser, SettableBeanProperty idProp) {
        return ObjectIdReader.construct(idType, new PropertyName(propName), generator, deser, idProp);
    }

    public JsonDeserializer<Object> getDeserializer() {
        return this._deserializer;
    }

    public JavaType getIdType() {
        return this._idType;
    }

    public Object readObjectReference(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserializer.deserialize(jp, ctxt);
    }
}

