/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import sun.font.CharToGlyphMapper;
import sun.font.DelegateStrike;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeGlyphMapper;
import sun.font.NativeStrike;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;
import sun.font.SunFontManager;

public class NativeFont
extends PhysicalFont {
    String encoding;
    private int numGlyphs = -1;
    boolean isBitmapDelegate;
    PhysicalFont delegateFont;

    public NativeFont(String platName, boolean bitmapDelegate) throws FontFormatException {
        super(platName, null);
        this.isBitmapDelegate = bitmapDelegate;
        if (GraphicsEnvironment.isHeadless()) {
            throw new FontFormatException("Native font in headless toolkit");
        }
        this.fontRank = 5;
        this.initNames();
        if (this.getNumGlyphs() == 0) {
            throw new FontFormatException("Couldn't locate font" + platName);
        }
    }

    private void initNames() throws FontFormatException {
        int[] hPos = new int[14];
        int hyphenCnt = 1;
        int pos = 1;
        String xlfd = this.platName.toLowerCase(Locale.ENGLISH);
        if (xlfd.startsWith("-")) {
            while (pos != -1 && hyphenCnt < 14) {
                if ((pos = xlfd.indexOf(45, pos)) == -1) continue;
                hPos[hyphenCnt++] = pos++;
            }
        }
        if (hyphenCnt == 14 && pos != -1) {
            String tmpFamily = xlfd.substring(hPos[1] + 1, hPos[2]);
            StringBuilder sBuffer = new StringBuilder(tmpFamily);
            char ch = Character.toUpperCase(sBuffer.charAt(0));
            sBuffer.replace(0, 1, String.valueOf(ch));
            for (int i = 1; i < sBuffer.length() - 1; ++i) {
                if (sBuffer.charAt(i) != ' ') continue;
                ch = Character.toUpperCase(sBuffer.charAt(i + 1));
                sBuffer.replace(i + 1, i + 2, String.valueOf(ch));
            }
            this.familyName = sBuffer.toString();
            String tmpWeight = xlfd.substring(hPos[2] + 1, hPos[3]);
            String tmpSlant = xlfd.substring(hPos[3] + 1, hPos[4]);
            String styleStr = null;
            if (tmpWeight.indexOf("bold") >= 0 || tmpWeight.indexOf("demi") >= 0) {
                this.style |= 1;
                styleStr = "Bold";
            }
            if (tmpSlant.equals("i") || tmpSlant.indexOf("italic") >= 0) {
                this.style |= 2;
                styleStr = styleStr == null ? "Italic" : styleStr + " Italic";
            } else if (tmpSlant.equals("o") || tmpSlant.indexOf("oblique") >= 0) {
                this.style |= 2;
                styleStr = styleStr == null ? "Oblique" : styleStr + " Oblique";
            }
            this.fullName = styleStr == null ? this.familyName : this.familyName + " " + styleStr;
            this.encoding = xlfd.substring(hPos[12] + 1);
            if (this.encoding.startsWith("-")) {
                this.encoding = xlfd.substring(hPos[13] + 1);
            }
            if (this.encoding.indexOf("fontspecific") >= 0) {
                this.encoding = tmpFamily.indexOf("dingbats") >= 0 ? "dingbats" : (tmpFamily.indexOf("symbol") >= 0 ? "symbol" : "iso8859-1");
            }
        } else {
            throw new FontFormatException("Bad native name " + this.platName);
        }
    }

    static boolean hasExternalBitmaps(String platName) {
        StringBuilder sb = new StringBuilder(platName);
        int pos = sb.indexOf("-0-");
        while (pos >= 0) {
            sb.replace(pos + 1, pos + 2, "*");
            pos = sb.indexOf("-0-", pos);
        }
        String xlfd = sb.toString();
        byte[] bytes = null;
        try {
            bytes = xlfd.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = xlfd.getBytes();
        }
        return NativeFont.haveBitmapFonts(bytes);
    }

    public static boolean fontExists(String xlfd) {
        byte[] bytes = null;
        try {
            bytes = xlfd.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = xlfd.getBytes();
        }
        return NativeFont.fontExists(bytes);
    }

    private static native boolean haveBitmapFonts(byte[] var0);

    private static native boolean fontExists(byte[] var0);

    @Override
    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            if (this.isBitmapDelegate) {
                this.mapper = new NativeGlyphMapper(this);
            } else {
                SunFontManager fm = SunFontManager.getInstance();
                this.delegateFont = fm.getDefaultPhysicalFont();
                this.mapper = this.delegateFont.getMapper();
            }
        }
        return this.mapper;
    }

    @Override
    FontStrike createStrike(FontStrikeDesc desc) {
        if (this.isBitmapDelegate) {
            return new NativeStrike(this, desc);
        }
        if (this.delegateFont == null) {
            SunFontManager fm = SunFontManager.getInstance();
            this.delegateFont = fm.getDefaultPhysicalFont();
        }
        if (this.delegateFont instanceof NativeFont) {
            return new NativeStrike((NativeFont)this.delegateFont, desc);
        }
        FontStrike delegate = this.delegateFont.createStrike(desc);
        return new DelegateStrike(this, desc, delegate);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext frc) {
        return null;
    }

    @Override
    native StrikeMetrics getFontMetrics(long var1);

    @Override
    native float getGlyphAdvance(long var1, int var3);

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(long pScalerContext, int glyphCode) {
        return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public GeneralPath getGlyphOutline(long pScalerContext, int glyphCode, float x, float y) {
        return null;
    }

    @Override
    native long getGlyphImage(long var1, int var3);

    native long getGlyphImageNoDefault(long var1, int var3);

    @Override
    void getGlyphMetrics(long pScalerContext, int glyphCode, Point2D.Float metrics) {
        throw new RuntimeException("this should be called on the strike");
    }

    @Override
    public GeneralPath getGlyphVectorOutline(long pScalerContext, int[] glyphs, int numGlyphs, float x, float y) {
        return null;
    }

    private native int countGlyphs(byte[] var1, int var2);

    @Override
    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            byte[] bytes = this.getPlatformNameBytes(8);
            this.numGlyphs = this.countGlyphs(bytes, 8);
        }
        return this.numGlyphs;
    }

    PhysicalFont getDelegateFont() {
        if (this.delegateFont == null) {
            SunFontManager fm = SunFontManager.getInstance();
            this.delegateFont = fm.getDefaultPhysicalFont();
        }
        return this.delegateFont;
    }

    byte[] getPlatformNameBytes(int ptSize) {
        int[] hPos = new int[14];
        int hyphenCnt = 1;
        int pos = 1;
        while (pos != -1 && hyphenCnt < 14) {
            if ((pos = this.platName.indexOf(45, pos)) == -1) continue;
            hPos[hyphenCnt++] = pos++;
        }
        String sizeStr = Integer.toString(Math.abs(ptSize) * 10);
        StringBuilder sb = new StringBuilder(this.platName);
        sb.replace(hPos[11] + 1, hPos[12], "*");
        sb.replace(hPos[9] + 1, hPos[10], "72");
        sb.replace(hPos[8] + 1, hPos[9], "72");
        sb.replace(hPos[7] + 1, hPos[8], sizeStr);
        sb.replace(hPos[6] + 1, hPos[7], "*");
        if (hPos[0] == 0 && hPos[1] == 1) {
            sb.replace(hPos[0] + 1, hPos[1], "*");
        }
        String xlfd = sb.toString();
        byte[] bytes = null;
        try {
            bytes = xlfd.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = xlfd.getBytes();
        }
        return bytes;
    }

    public String toString() {
        return " ** Native Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + " nativeName=" + this.platName;
    }
}

