/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.NumberFormatter;
import sun.print.DocumentPropertiesUI;
import sun.print.PrinterJobWrapper;
import sun.print.SunAlternateMedia;
import sun.print.SunPageSelection;

public class ServiceDialog
extends JDialog
implements ActionListener {
    public static final int WAITING = 0;
    public static final int APPROVE = 1;
    public static final int CANCEL = 2;
    private static final String strBundle = "sun.print.resources.serviceui";
    private static final Insets panelInsets = new Insets(6, 6, 6, 6);
    private static final Insets compInsets = new Insets(3, 6, 3, 6);
    private static ResourceBundle messageRB;
    private JTabbedPane tpTabs;
    private JButton btnCancel;
    private JButton btnApprove;
    private PrintService[] services;
    private int defaultServiceIndex;
    private PrintRequestAttributeSet asOriginal;
    private HashPrintRequestAttributeSet asCurrent;
    private PrintService psCurrent;
    private DocFlavor docFlavor;
    private int status;
    private ValidatingFileChooser jfc;
    private GeneralPanel pnlGeneral;
    private PageSetupPanel pnlPageSetup;
    private AppearancePanel pnlAppearance;
    private boolean isAWT = false;
    static Class _keyEventClazz;

    public ServiceDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, int defaultServiceIndex, DocFlavor flavor, PrintRequestAttributeSet attributes, Dialog dialog) {
        super(dialog, ServiceDialog.getMsg("dialog.printtitle"), true, gc);
        this.initPrintDialog(x, y, services, defaultServiceIndex, flavor, attributes);
    }

    public ServiceDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, int defaultServiceIndex, DocFlavor flavor, PrintRequestAttributeSet attributes, Frame frame) {
        super(frame, ServiceDialog.getMsg("dialog.printtitle"), true, gc);
        this.initPrintDialog(x, y, services, defaultServiceIndex, flavor, attributes);
    }

    void initPrintDialog(int x, int y, PrintService[] services, int defaultServiceIndex, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        this.services = services;
        this.defaultServiceIndex = defaultServiceIndex;
        this.asOriginal = attributes;
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        this.psCurrent = services[defaultServiceIndex];
        this.docFlavor = flavor;
        SunPageSelection pages = (SunPageSelection)attributes.get(SunPageSelection.class);
        if (pages != null) {
            this.isAWT = true;
        }
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.tpTabs = new JTabbedPane();
        this.tpTabs.setBorder(new EmptyBorder(5, 5, 5, 5));
        String gkey = ServiceDialog.getMsg("tab.general");
        int gmnemonic = ServiceDialog.getVKMnemonic("tab.general");
        this.pnlGeneral = new GeneralPanel();
        this.tpTabs.add(gkey, this.pnlGeneral);
        this.tpTabs.setMnemonicAt(0, gmnemonic);
        String pkey = ServiceDialog.getMsg("tab.pagesetup");
        int pmnemonic = ServiceDialog.getVKMnemonic("tab.pagesetup");
        this.pnlPageSetup = new PageSetupPanel();
        this.tpTabs.add(pkey, this.pnlPageSetup);
        this.tpTabs.setMnemonicAt(1, pmnemonic);
        String akey = ServiceDialog.getMsg("tab.appearance");
        int amnemonic = ServiceDialog.getVKMnemonic("tab.appearance");
        this.pnlAppearance = new AppearancePanel();
        this.tpTabs.add(akey, this.pnlAppearance);
        this.tpTabs.setMnemonicAt(2, amnemonic);
        c.add((Component)this.tpTabs, "Center");
        this.updatePanels();
        JPanel pnlSouth = new JPanel(new FlowLayout(4));
        this.btnApprove = ServiceDialog.createExitButton("button.print", this);
        pnlSouth.add(this.btnApprove);
        this.getRootPane().setDefaultButton(this.btnApprove);
        this.btnCancel = ServiceDialog.createExitButton("button.cancel", this);
        this.handleEscKey(this.btnCancel);
        pnlSouth.add(this.btnCancel);
        c.add((Component)pnlSouth, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ServiceDialog.this.dispose(2);
            }
        });
        this.getAccessibleContext().setAccessibleDescription(ServiceDialog.getMsg("dialog.printtitle"));
        this.setResizable(false);
        this.setLocation(x, y);
        this.pack();
    }

    public ServiceDialog(GraphicsConfiguration gc, int x, int y, PrintService ps, DocFlavor flavor, PrintRequestAttributeSet attributes, Dialog dialog) {
        super(dialog, ServiceDialog.getMsg("dialog.pstitle"), true, gc);
        this.initPageDialog(x, y, ps, flavor, attributes);
    }

    public ServiceDialog(GraphicsConfiguration gc, int x, int y, PrintService ps, DocFlavor flavor, PrintRequestAttributeSet attributes, Frame frame) {
        super(frame, ServiceDialog.getMsg("dialog.pstitle"), true, gc);
        this.initPageDialog(x, y, ps, flavor, attributes);
    }

    void initPageDialog(int x, int y, PrintService ps, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        this.psCurrent = ps;
        this.docFlavor = flavor;
        this.asOriginal = attributes;
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.pnlPageSetup = new PageSetupPanel();
        c.add((Component)this.pnlPageSetup, "Center");
        this.pnlPageSetup.updateInfo();
        JPanel pnlSouth = new JPanel(new FlowLayout(4));
        this.btnApprove = ServiceDialog.createExitButton("button.ok", this);
        pnlSouth.add(this.btnApprove);
        this.getRootPane().setDefaultButton(this.btnApprove);
        this.btnCancel = ServiceDialog.createExitButton("button.cancel", this);
        this.handleEscKey(this.btnCancel);
        pnlSouth.add(this.btnCancel);
        c.add((Component)pnlSouth, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ServiceDialog.this.dispose(2);
            }
        });
        this.getAccessibleContext().setAccessibleDescription(ServiceDialog.getMsg("dialog.pstitle"));
        this.setResizable(false);
        this.setLocation(x, y);
        this.pack();
    }

    private void handleEscKey(JButton btnCancel) {
        AbstractAction cancelKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceDialog.this.dispose(2);
            }
        };
        KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = btnCancel.getInputMap(2);
        ActionMap actionMap = btnCancel.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(cancelKeyStroke, "cancel");
            actionMap.put("cancel", cancelKeyAction);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public PrintRequestAttributeSet getAttributes() {
        if (this.status == 1) {
            return this.asCurrent;
        }
        return this.asOriginal;
    }

    public PrintService getPrintService() {
        if (this.status == 1) {
            return this.psCurrent;
        }
        return null;
    }

    public void dispose(int status) {
        this.status = status;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        boolean approved = false;
        if (source == this.btnApprove) {
            approved = true;
            if (this.pnlGeneral != null) {
                if (this.pnlGeneral.isPrintToFileRequested()) {
                    approved = this.showFileChooser();
                } else {
                    this.asCurrent.remove(Destination.class);
                }
            }
        }
        this.dispose(approved ? 1 : 2);
    }

    private boolean showFileChooser() {
        File fileDest;
        Class<Destination> dstCategory = Destination.class;
        Destination dst = (Destination)this.asCurrent.get(dstCategory);
        if (dst == null && (dst = (Destination)this.asOriginal.get(dstCategory)) == null && (dst = (Destination)this.psCurrent.getDefaultAttributeValue(dstCategory)) == null) {
            try {
                dst = new Destination(new URI("file:out.prn"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (dst != null) {
            try {
                fileDest = new File(dst.getURI());
            }
            catch (Exception e) {
                fileDest = new File("out.prn");
            }
        } else {
            fileDest = new File("out.prn");
        }
        ValidatingFileChooser jfc = new ValidatingFileChooser();
        jfc.setApproveButtonText(ServiceDialog.getMsg("button.ok"));
        jfc.setDialogTitle(ServiceDialog.getMsg("dialog.printtofile"));
        jfc.setDialogType(1);
        jfc.setSelectedFile(fileDest);
        int returnVal = jfc.showDialog(this, null);
        if (returnVal == 0) {
            fileDest = jfc.getSelectedFile();
            try {
                this.asCurrent.add(new Destination(fileDest.toURI()));
            }
            catch (Exception e) {
                this.asCurrent.remove(dstCategory);
            }
        } else {
            this.asCurrent.remove(dstCategory);
        }
        return returnVal == 0;
    }

    private void updatePanels() {
        this.pnlGeneral.updateInfo();
        this.pnlPageSetup.updateInfo();
        this.pnlAppearance.updateInfo();
    }

    public static void initResource() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    messageRB = ResourceBundle.getBundle(ServiceDialog.strBundle);
                    return null;
                }
                catch (MissingResourceException e) {
                    throw new Error("Fatal: Resource for ServiceUI is missing");
                }
            }
        });
    }

    public static String getMsg(String key) {
        try {
            return ServiceDialog.removeMnemonics(messageRB.getString(key));
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for ServiceUI is broken; there is no " + key + " key in resource");
        }
    }

    private static String removeMnemonics(String s) {
        int i = s.indexOf(38);
        int len = s.length();
        if (i < 0 || i == len - 1) {
            return s;
        }
        int j = s.indexOf(38, i + 1);
        if (j == i + 1) {
            if (j + 1 == len) {
                return s.substring(0, i + 1);
            }
            return s.substring(0, i + 1) + ServiceDialog.removeMnemonics(s.substring(j + 1));
        }
        if (i == 0) {
            return ServiceDialog.removeMnemonics(s.substring(1));
        }
        return s.substring(0, i) + ServiceDialog.removeMnemonics(s.substring(i + 1));
    }

    private static char getMnemonic(String key) {
        String str = messageRB.getString(key).replace("&&", "");
        int index = str.indexOf(38);
        if (0 <= index && index < str.length() - 1) {
            char c = str.charAt(index + 1);
            return Character.toUpperCase(c);
        }
        return '\u0000';
    }

    private static int getVKMnemonic(String key) {
        String s = String.valueOf(ServiceDialog.getMnemonic(key));
        if (s == null || s.length() != 1) {
            return 0;
        }
        String vkString = "VK_" + s.toUpperCase();
        try {
            if (_keyEventClazz == null) {
                _keyEventClazz = Class.forName("java.awt.event.KeyEvent", true, ServiceDialog.class.getClassLoader());
            }
            Field field = _keyEventClazz.getDeclaredField(vkString);
            int value = field.getInt(null);
            return value;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static URL getImageResource(final String key) {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL url = ServiceDialog.class.getResource("resources/" + key);
                return url;
            }
        });
        if (url == null) {
            throw new Error("Fatal: Resource for ServiceUI is broken; there is no " + key + " key in resource");
        }
        return url;
    }

    private static JButton createButton(String key, ActionListener al) {
        JButton btn = new JButton(ServiceDialog.getMsg(key));
        btn.setMnemonic(ServiceDialog.getMnemonic(key));
        btn.addActionListener(al);
        return btn;
    }

    private static JButton createExitButton(String key, ActionListener al) {
        String str = ServiceDialog.getMsg(key);
        JButton btn = new JButton(str);
        btn.addActionListener(al);
        btn.getAccessibleContext().setAccessibleDescription(str);
        return btn;
    }

    private static JCheckBox createCheckBox(String key, ActionListener al) {
        JCheckBox cb = new JCheckBox(ServiceDialog.getMsg(key));
        cb.setMnemonic(ServiceDialog.getMnemonic(key));
        cb.addActionListener(al);
        return cb;
    }

    private static JRadioButton createRadioButton(String key, ActionListener al) {
        JRadioButton rb = new JRadioButton(ServiceDialog.getMsg(key));
        rb.setMnemonic(ServiceDialog.getMnemonic(key));
        rb.addActionListener(al);
        return rb;
    }

    public static void showNoPrintService(GraphicsConfiguration gc) {
        Frame dlgFrame = new Frame(gc);
        JOptionPane.showMessageDialog(dlgFrame, ServiceDialog.getMsg("dialog.noprintermsg"));
        dlgFrame.dispose();
    }

    private static void addToGB(Component comp, Container cont, GridBagLayout gridbag, GridBagConstraints constraints) {
        gridbag.setConstraints(comp, constraints);
        cont.add(comp);
    }

    private static void addToBG(AbstractButton button, Container cont, ButtonGroup bg) {
        bg.add(button);
        cont.add(button);
    }

    static {
        ServiceDialog.initResource();
        _keyEventClazz = null;
    }

    private class ValidatingFileChooser
    extends JFileChooser {
        private ValidatingFileChooser() {
        }

        @Override
        public void approveSelection() {
            int val;
            boolean exists;
            File selected = this.getSelectedFile();
            try {
                exists = selected.exists();
            }
            catch (SecurityException e) {
                exists = false;
            }
            if (exists && (val = JOptionPane.showConfirmDialog(this, ServiceDialog.getMsg("dialog.overwrite"), ServiceDialog.getMsg("dialog.owtitle"), 0)) != 0) {
                return;
            }
            try {
                if (selected.createNewFile()) {
                    selected.delete();
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ServiceDialog.getMsg("dialog.writeerror") + " " + selected, ServiceDialog.getMsg("dialog.owtitle"), 2);
                return;
            }
            catch (SecurityException ioe) {
                // empty catch block
            }
            File pFile = selected.getParentFile();
            if (selected.exists() && (!selected.isFile() || !selected.canWrite()) || pFile != null && (!pFile.exists() || pFile.exists() && !pFile.canWrite())) {
                JOptionPane.showMessageDialog(this, ServiceDialog.getMsg("dialog.writeerror") + " " + selected, ServiceDialog.getMsg("dialog.owtitle"), 2);
                return;
            }
            super.approveSelection();
        }
    }

    private class IconRadioButton
    extends JPanel {
        private JRadioButton rb;
        private JLabel lbl;

        public IconRadioButton(String key, String img, boolean selected, ButtonGroup bg, ActionListener al) {
            super(new FlowLayout(3));
            final URL imgURL = ServiceDialog.getImageResource(img);
            Icon icon = (Icon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ImageIcon icon = new ImageIcon(imgURL);
                    return icon;
                }
            });
            this.lbl = new JLabel(icon);
            this.add(this.lbl);
            this.rb = ServiceDialog.createRadioButton(key, al);
            this.rb.setSelected(selected);
            ServiceDialog.addToBG(this.rb, this, bg);
        }

        public void addActionListener(ActionListener al) {
            this.rb.addActionListener(al);
        }

        public boolean isSameAs(Object source) {
            return this.rb == source;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.rb.setEnabled(enabled);
            this.lbl.setEnabled(enabled);
        }

        public boolean isSelected() {
            return this.rb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.rb.setSelected(selected);
        }
    }

    private class JobAttributesPanel
    extends JPanel
    implements ActionListener,
    ChangeListener,
    FocusListener {
        private final String strTitle = ServiceDialog.getMsg("border.jobattributes");
        private JLabel lblPriority;
        private JLabel lblJobName;
        private JLabel lblUserName;
        private JSpinner spinPriority;
        private SpinnerNumberModel snModel;
        private JCheckBox cbJobSheets;
        private JTextField tfJobName;
        private JTextField tfUserName;

        public JobAttributesPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 0;
            c.insets = compInsets;
            c.weighty = 1.0;
            this.cbJobSheets = ServiceDialog.createCheckBox("checkbox.jobsheets", this);
            c.anchor = 21;
            ServiceDialog.addToGB(this.cbJobSheets, this, gridbag, c);
            JPanel pnlTop = new JPanel();
            this.lblPriority = new JLabel(ServiceDialog.getMsg("label.priority"), 11);
            this.lblPriority.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.priority"));
            pnlTop.add(this.lblPriority);
            this.snModel = new SpinnerNumberModel(1, 1, 100, 1);
            this.spinPriority = new JSpinner(this.snModel);
            this.lblPriority.setLabelFor(this.spinPriority);
            ((JSpinner.NumberEditor)this.spinPriority.getEditor()).getTextField().setColumns(3);
            this.spinPriority.addChangeListener(this);
            pnlTop.add(this.spinPriority);
            c.anchor = 22;
            c.gridwidth = 0;
            pnlTop.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.priority"));
            ServiceDialog.addToGB(pnlTop, this, gridbag, c);
            c.fill = 2;
            c.anchor = 10;
            c.weightx = 0.0;
            c.gridwidth = 1;
            char jmnemonic = ServiceDialog.getMnemonic("label.jobname");
            this.lblJobName = new JLabel(ServiceDialog.getMsg("label.jobname"), 11);
            this.lblJobName.setDisplayedMnemonic(jmnemonic);
            ServiceDialog.addToGB(this.lblJobName, this, gridbag, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.tfJobName = new JTextField();
            this.lblJobName.setLabelFor(this.tfJobName);
            this.tfJobName.addFocusListener(this);
            this.tfJobName.setFocusAccelerator(jmnemonic);
            this.tfJobName.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.jobname"));
            ServiceDialog.addToGB(this.tfJobName, this, gridbag, c);
            c.weightx = 0.0;
            c.gridwidth = 1;
            char umnemonic = ServiceDialog.getMnemonic("label.username");
            this.lblUserName = new JLabel(ServiceDialog.getMsg("label.username"), 11);
            this.lblUserName.setDisplayedMnemonic(umnemonic);
            ServiceDialog.addToGB(this.lblUserName, this, gridbag, c);
            c.gridwidth = 0;
            this.tfUserName = new JTextField();
            this.lblUserName.setLabelFor(this.tfUserName);
            this.tfUserName.addFocusListener(this);
            this.tfUserName.setFocusAccelerator(umnemonic);
            this.tfUserName.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.username"));
            ServiceDialog.addToGB(this.tfUserName, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.cbJobSheets.isSelected()) {
                ServiceDialog.this.asCurrent.add(JobSheets.STANDARD);
            } else {
                ServiceDialog.this.asCurrent.add(JobSheets.NONE);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ServiceDialog.this.asCurrent.add(new JobPriority(this.snModel.getNumber().intValue()));
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == this.tfJobName) {
                ServiceDialog.this.asCurrent.add(new JobName(this.tfJobName.getText(), Locale.getDefault()));
            } else if (source == this.tfUserName) {
                ServiceDialog.this.asCurrent.add(new RequestingUserName(this.tfUserName.getText(), Locale.getDefault()));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        public void updateInfo() {
            RequestingUserName un;
            JobName jn;
            int value;
            JobPriority jp;
            JobSheets js;
            Class<JobSheets> jsCategory = JobSheets.class;
            Class<JobPriority> jpCategory = JobPriority.class;
            Class<JobName> jnCategory = JobName.class;
            Class<RequestingUserName> unCategory = RequestingUserName.class;
            boolean jsSupported = false;
            boolean jpSupported = false;
            boolean jnSupported = false;
            boolean unSupported = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(jsCategory)) {
                jsSupported = true;
            }
            if ((js = (JobSheets)ServiceDialog.this.asCurrent.get(jsCategory)) == null && (js = (JobSheets)ServiceDialog.this.psCurrent.getDefaultAttributeValue(jsCategory)) == null) {
                js = JobSheets.NONE;
            }
            this.cbJobSheets.setSelected(js != JobSheets.NONE);
            this.cbJobSheets.setEnabled(jsSupported);
            if (!ServiceDialog.this.isAWT && ServiceDialog.this.psCurrent.isAttributeCategorySupported(jpCategory)) {
                jpSupported = true;
            }
            if ((jp = (JobPriority)ServiceDialog.this.asCurrent.get(jpCategory)) == null && (jp = (JobPriority)ServiceDialog.this.psCurrent.getDefaultAttributeValue(jpCategory)) == null) {
                jp = new JobPriority(1);
            }
            if ((value = jp.getValue()) < 1 || value > 100) {
                value = 1;
            }
            this.snModel.setValue(new Integer(value));
            this.lblPriority.setEnabled(jpSupported);
            this.spinPriority.setEnabled(jpSupported);
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(jnCategory)) {
                jnSupported = true;
            }
            if ((jn = (JobName)ServiceDialog.this.asCurrent.get(jnCategory)) == null && (jn = (JobName)ServiceDialog.this.psCurrent.getDefaultAttributeValue(jnCategory)) == null) {
                jn = new JobName("", Locale.getDefault());
            }
            this.tfJobName.setText(jn.getValue());
            this.tfJobName.setEnabled(jnSupported);
            this.lblJobName.setEnabled(jnSupported);
            if (!ServiceDialog.this.isAWT && ServiceDialog.this.psCurrent.isAttributeCategorySupported(unCategory)) {
                unSupported = true;
            }
            if ((un = (RequestingUserName)ServiceDialog.this.asCurrent.get(unCategory)) == null && (un = (RequestingUserName)ServiceDialog.this.psCurrent.getDefaultAttributeValue(unCategory)) == null) {
                un = new RequestingUserName("", Locale.getDefault());
            }
            this.tfUserName.setText(un.getValue());
            this.tfUserName.setEnabled(unSupported);
            this.lblUserName.setEnabled(unSupported);
        }
    }

    private class SidesPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.getMsg("border.sides");
        private IconRadioButton rbOneSide;
        private IconRadioButton rbTumble;
        private IconRadioButton rbDuplex;

        public SidesPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 1;
            c.insets = compInsets;
            c.weighty = 1.0;
            c.gridwidth = 0;
            ButtonGroup bg = new ButtonGroup();
            this.rbOneSide = new IconRadioButton("radiobutton.oneside", "oneside.png", true, bg, this);
            this.rbOneSide.addActionListener(this);
            ServiceDialog.addToGB(this.rbOneSide, this, gridbag, c);
            this.rbTumble = new IconRadioButton("radiobutton.tumble", "tumble.png", false, bg, this);
            this.rbTumble.addActionListener(this);
            ServiceDialog.addToGB(this.rbTumble, this, gridbag, c);
            this.rbDuplex = new IconRadioButton("radiobutton.duplex", "duplex.png", false, bg, this);
            this.rbDuplex.addActionListener(this);
            c.gridwidth = 0;
            ServiceDialog.addToGB(this.rbDuplex, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.rbOneSide.isSameAs(source)) {
                ServiceDialog.this.asCurrent.add(Sides.ONE_SIDED);
            } else if (this.rbTumble.isSameAs(source)) {
                ServiceDialog.this.asCurrent.add(Sides.TUMBLE);
            } else if (this.rbDuplex.isSameAs(source)) {
                ServiceDialog.this.asCurrent.add(Sides.DUPLEX);
            }
        }

        public void updateInfo() {
            Object values;
            Class<Sides> sdCategory = Sides.class;
            boolean osSupported = false;
            boolean tSupported = false;
            boolean dSupported = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(sdCategory) && (values = ServiceDialog.this.psCurrent.getSupportedAttributeValues(sdCategory, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof Sides[]) {
                Sides[] svalues = (Sides[])values;
                for (int i = 0; i < svalues.length; ++i) {
                    Sides value = svalues[i];
                    if (value == Sides.ONE_SIDED) {
                        osSupported = true;
                        continue;
                    }
                    if (value == Sides.TUMBLE) {
                        tSupported = true;
                        continue;
                    }
                    if (value != Sides.DUPLEX) continue;
                    dSupported = true;
                }
            }
            this.rbOneSide.setEnabled(osSupported);
            this.rbTumble.setEnabled(tSupported);
            this.rbDuplex.setEnabled(dSupported);
            Sides sd = (Sides)ServiceDialog.this.asCurrent.get(sdCategory);
            if (sd == null && (sd = (Sides)ServiceDialog.this.psCurrent.getDefaultAttributeValue(sdCategory)) == null) {
                sd = Sides.ONE_SIDED;
            }
            if (sd == Sides.ONE_SIDED) {
                this.rbOneSide.setSelected(true);
            } else if (sd == Sides.TUMBLE) {
                this.rbTumble.setSelected(true);
            } else {
                this.rbDuplex.setSelected(true);
            }
        }
    }

    private class QualityPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.getMsg("border.quality");
        private JRadioButton rbDraft;
        private JRadioButton rbNormal;
        private JRadioButton rbHigh;

        public QualityPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 1;
            c.gridwidth = 0;
            c.weighty = 1.0;
            ButtonGroup bg = new ButtonGroup();
            this.rbDraft = ServiceDialog.createRadioButton("radiobutton.draftq", this);
            bg.add(this.rbDraft);
            ServiceDialog.addToGB(this.rbDraft, this, gridbag, c);
            this.rbNormal = ServiceDialog.createRadioButton("radiobutton.normalq", this);
            this.rbNormal.setSelected(true);
            bg.add(this.rbNormal);
            ServiceDialog.addToGB(this.rbNormal, this, gridbag, c);
            this.rbHigh = ServiceDialog.createRadioButton("radiobutton.highq", this);
            bg.add(this.rbHigh);
            ServiceDialog.addToGB(this.rbHigh, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.rbDraft) {
                ServiceDialog.this.asCurrent.add(PrintQuality.DRAFT);
            } else if (source == this.rbNormal) {
                ServiceDialog.this.asCurrent.add(PrintQuality.NORMAL);
            } else if (source == this.rbHigh) {
                ServiceDialog.this.asCurrent.add(PrintQuality.HIGH);
            }
        }

        public void updateInfo() {
            Object values;
            Class<PrintQuality> pqCategory = PrintQuality.class;
            boolean draftSupported = false;
            boolean normalSupported = false;
            boolean highSupported = false;
            if (ServiceDialog.this.isAWT) {
                draftSupported = true;
                normalSupported = true;
                highSupported = true;
            } else if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(pqCategory) && (values = ServiceDialog.this.psCurrent.getSupportedAttributeValues(pqCategory, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof PrintQuality[]) {
                PrintQuality[] qvalues = (PrintQuality[])values;
                for (int i = 0; i < qvalues.length; ++i) {
                    PrintQuality value = qvalues[i];
                    if (value == PrintQuality.DRAFT) {
                        draftSupported = true;
                        continue;
                    }
                    if (value == PrintQuality.NORMAL) {
                        normalSupported = true;
                        continue;
                    }
                    if (value != PrintQuality.HIGH) continue;
                    highSupported = true;
                }
            }
            this.rbDraft.setEnabled(draftSupported);
            this.rbNormal.setEnabled(normalSupported);
            this.rbHigh.setEnabled(highSupported);
            PrintQuality pq = (PrintQuality)ServiceDialog.this.asCurrent.get(pqCategory);
            if (pq == null && (pq = (PrintQuality)ServiceDialog.this.psCurrent.getDefaultAttributeValue(pqCategory)) == null) {
                pq = PrintQuality.NORMAL;
            }
            if (pq == PrintQuality.DRAFT) {
                this.rbDraft.setSelected(true);
            } else if (pq == PrintQuality.NORMAL) {
                this.rbNormal.setSelected(true);
            } else {
                this.rbHigh.setSelected(true);
            }
        }
    }

    private class ChromaticityPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.getMsg("border.chromaticity");
        private JRadioButton rbMonochrome;
        private JRadioButton rbColor;

        public ChromaticityPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 1;
            c.gridwidth = 0;
            c.weighty = 1.0;
            ButtonGroup bg = new ButtonGroup();
            this.rbMonochrome = ServiceDialog.createRadioButton("radiobutton.monochrome", this);
            this.rbMonochrome.setSelected(true);
            bg.add(this.rbMonochrome);
            ServiceDialog.addToGB(this.rbMonochrome, this, gridbag, c);
            this.rbColor = ServiceDialog.createRadioButton("radiobutton.color", this);
            bg.add(this.rbColor);
            ServiceDialog.addToGB(this.rbColor, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.rbMonochrome) {
                ServiceDialog.this.asCurrent.add(Chromaticity.MONOCHROME);
            } else if (source == this.rbColor) {
                ServiceDialog.this.asCurrent.add(Chromaticity.COLOR);
            }
        }

        public void updateInfo() {
            Object values;
            Class<Chromaticity> chCategory = Chromaticity.class;
            boolean monoSupported = false;
            boolean colorSupported = false;
            if (ServiceDialog.this.isAWT) {
                monoSupported = true;
                colorSupported = true;
            } else if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(chCategory) && (values = ServiceDialog.this.psCurrent.getSupportedAttributeValues(chCategory, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof Chromaticity[]) {
                Chromaticity[] cvalues = (Chromaticity[])values;
                for (int i = 0; i < cvalues.length; ++i) {
                    Chromaticity value = cvalues[i];
                    if (value == Chromaticity.MONOCHROME) {
                        monoSupported = true;
                        continue;
                    }
                    if (value != Chromaticity.COLOR) continue;
                    colorSupported = true;
                }
            }
            this.rbMonochrome.setEnabled(monoSupported);
            this.rbColor.setEnabled(colorSupported);
            Chromaticity ch = (Chromaticity)ServiceDialog.this.asCurrent.get(chCategory);
            if (ch == null && (ch = (Chromaticity)ServiceDialog.this.psCurrent.getDefaultAttributeValue(chCategory)) == null) {
                ch = Chromaticity.MONOCHROME;
            }
            if (ch == Chromaticity.MONOCHROME) {
                this.rbMonochrome.setSelected(true);
            } else {
                this.rbColor.setSelected(true);
            }
        }
    }

    private class AppearancePanel
    extends JPanel {
        private ChromaticityPanel pnlChromaticity;
        private QualityPanel pnlQuality;
        private JobAttributesPanel pnlJobAttributes;
        private SidesPanel pnlSides;

        public AppearancePanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            c.fill = 1;
            c.insets = panelInsets;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = -1;
            this.pnlChromaticity = new ChromaticityPanel();
            ServiceDialog.addToGB(this.pnlChromaticity, this, gridbag, c);
            c.gridwidth = 0;
            this.pnlQuality = new QualityPanel();
            ServiceDialog.addToGB(this.pnlQuality, this, gridbag, c);
            c.gridwidth = 1;
            this.pnlSides = new SidesPanel();
            ServiceDialog.addToGB(this.pnlSides, this, gridbag, c);
            c.gridwidth = 0;
            this.pnlJobAttributes = new JobAttributesPanel();
            ServiceDialog.addToGB(this.pnlJobAttributes, this, gridbag, c);
        }

        public void updateInfo() {
            this.pnlChromaticity.updateInfo();
            this.pnlQuality.updateInfo();
            this.pnlSides.updateInfo();
            this.pnlJobAttributes.updateInfo();
        }
    }

    private class OrientationPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.getMsg("border.orientation");
        private IconRadioButton rbPortrait;
        private IconRadioButton rbLandscape;
        private IconRadioButton rbRevPortrait;
        private IconRadioButton rbRevLandscape;
        private MarginsPanel pnlMargins = null;

        public OrientationPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 1;
            c.insets = compInsets;
            c.weighty = 1.0;
            c.gridwidth = 0;
            ButtonGroup bg = new ButtonGroup();
            this.rbPortrait = new IconRadioButton("radiobutton.portrait", "orientPortrait.png", true, bg, this);
            this.rbPortrait.addActionListener(this);
            ServiceDialog.addToGB(this.rbPortrait, this, gridbag, c);
            this.rbLandscape = new IconRadioButton("radiobutton.landscape", "orientLandscape.png", false, bg, this);
            this.rbLandscape.addActionListener(this);
            ServiceDialog.addToGB(this.rbLandscape, this, gridbag, c);
            this.rbRevPortrait = new IconRadioButton("radiobutton.revportrait", "orientRevPortrait.png", false, bg, this);
            this.rbRevPortrait.addActionListener(this);
            ServiceDialog.addToGB(this.rbRevPortrait, this, gridbag, c);
            this.rbRevLandscape = new IconRadioButton("radiobutton.revlandscape", "orientRevLandscape.png", false, bg, this);
            this.rbRevLandscape.addActionListener(this);
            ServiceDialog.addToGB(this.rbRevLandscape, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.rbPortrait.isSameAs(source)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.PORTRAIT);
            } else if (this.rbLandscape.isSameAs(source)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.LANDSCAPE);
            } else if (this.rbRevPortrait.isSameAs(source)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.REVERSE_PORTRAIT);
            } else if (this.rbRevLandscape.isSameAs(source)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.REVERSE_LANDSCAPE);
            }
            if (this.pnlMargins != null) {
                this.pnlMargins.updateInfo();
            }
        }

        void addOrientationListener(MarginsPanel pnl) {
            this.pnlMargins = pnl;
        }

        public void updateInfo() {
            Object values;
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            boolean pSupported = false;
            boolean lSupported = false;
            boolean rpSupported = false;
            boolean rlSupported = false;
            if (ServiceDialog.this.isAWT) {
                pSupported = true;
                lSupported = true;
            } else if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(orCategory) && (values = ServiceDialog.this.psCurrent.getSupportedAttributeValues(orCategory, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof OrientationRequested[]) {
                OrientationRequested[] ovalues = (OrientationRequested[])values;
                for (int i = 0; i < ovalues.length; ++i) {
                    OrientationRequested value = ovalues[i];
                    if (value == OrientationRequested.PORTRAIT) {
                        pSupported = true;
                        continue;
                    }
                    if (value == OrientationRequested.LANDSCAPE) {
                        lSupported = true;
                        continue;
                    }
                    if (value == OrientationRequested.REVERSE_PORTRAIT) {
                        rpSupported = true;
                        continue;
                    }
                    if (value != OrientationRequested.REVERSE_LANDSCAPE) continue;
                    rlSupported = true;
                }
            }
            this.rbPortrait.setEnabled(pSupported);
            this.rbLandscape.setEnabled(lSupported);
            this.rbRevPortrait.setEnabled(rpSupported);
            this.rbRevLandscape.setEnabled(rlSupported);
            OrientationRequested or = (OrientationRequested)ServiceDialog.this.asCurrent.get(orCategory);
            if (or == null || !ServiceDialog.this.psCurrent.isAttributeValueSupported(or, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) {
                or = (OrientationRequested)ServiceDialog.this.psCurrent.getDefaultAttributeValue(orCategory);
                if (or != null && !ServiceDialog.this.psCurrent.isAttributeValueSupported(or, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) {
                    OrientationRequested[] orValues;
                    or = null;
                    Object values2 = ServiceDialog.this.psCurrent.getSupportedAttributeValues(orCategory, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent);
                    if (values2 instanceof OrientationRequested[] && (orValues = (OrientationRequested[])values2).length > 1) {
                        or = orValues[0];
                    }
                }
                if (or == null) {
                    or = OrientationRequested.PORTRAIT;
                }
                ServiceDialog.this.asCurrent.add(or);
            }
            if (or == OrientationRequested.PORTRAIT) {
                this.rbPortrait.setSelected(true);
            } else if (or == OrientationRequested.LANDSCAPE) {
                this.rbLandscape.setSelected(true);
            } else if (or == OrientationRequested.REVERSE_PORTRAIT) {
                this.rbRevPortrait.setSelected(true);
            } else {
                this.rbRevLandscape.setSelected(true);
            }
        }
    }

    private class MediaPanel
    extends JPanel
    implements ItemListener {
        private final String strTitle = ServiceDialog.getMsg("border.media");
        private JLabel lblSize;
        private JLabel lblSource;
        private JComboBox cbSize;
        private JComboBox cbSource;
        private Vector sizes = new Vector();
        private Vector sources = new Vector();
        private MarginsPanel pnlMargins = null;

        public MediaPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            this.cbSize = new JComboBox();
            this.cbSource = new JComboBox();
            c.fill = 1;
            c.insets = compInsets;
            c.weighty = 1.0;
            c.weightx = 0.0;
            this.lblSize = new JLabel(ServiceDialog.getMsg("label.size"), 11);
            this.lblSize.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.size"));
            this.lblSize.setLabelFor(this.cbSize);
            ServiceDialog.addToGB(this.lblSize, this, gridbag, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            ServiceDialog.addToGB(this.cbSize, this, gridbag, c);
            c.weightx = 0.0;
            c.gridwidth = 1;
            this.lblSource = new JLabel(ServiceDialog.getMsg("label.source"), 11);
            this.lblSource.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.source"));
            this.lblSource.setLabelFor(this.cbSource);
            ServiceDialog.addToGB(this.lblSource, this, gridbag, c);
            c.gridwidth = 0;
            ServiceDialog.addToGB(this.cbSource, this, gridbag, c);
        }

        private String getMediaName(String key) {
            try {
                String newkey = key.replace(' ', '-');
                newkey = newkey.replace('#', 'n');
                return messageRB.getString(newkey);
            }
            catch (MissingResourceException e) {
                return key;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (e.getStateChange() == 1) {
                if (source == this.cbSize) {
                    int index = this.cbSize.getSelectedIndex();
                    if (index >= 0 && index < this.sizes.size()) {
                        if (this.cbSource.getItemCount() > 1 && this.cbSource.getSelectedIndex() >= 1) {
                            int src = this.cbSource.getSelectedIndex() - 1;
                            MediaTray mt = (MediaTray)this.sources.get(src);
                            ServiceDialog.this.asCurrent.add(new SunAlternateMedia(mt));
                        }
                        ServiceDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(index));
                    }
                } else if (source == this.cbSource) {
                    int index = this.cbSource.getSelectedIndex();
                    if (index >= 1 && index < this.sources.size() + 1) {
                        ServiceDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        MediaTray newTray = (MediaTray)this.sources.get(index - 1);
                        Media m = (Media)ServiceDialog.this.asCurrent.get(Media.class);
                        if (m == null || m instanceof MediaTray) {
                            ServiceDialog.this.asCurrent.add(newTray);
                        } else if (m instanceof MediaSizeName) {
                            MediaSizeName msn = (MediaSizeName)m;
                            Media def = (Media)ServiceDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
                            if (def instanceof MediaSizeName && def.equals(msn)) {
                                ServiceDialog.this.asCurrent.add(newTray);
                            } else {
                                ServiceDialog.this.asCurrent.add(new SunAlternateMedia(newTray));
                            }
                        }
                    } else if (index == 0) {
                        ServiceDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        if (this.cbSize.getItemCount() > 0) {
                            int size = this.cbSize.getSelectedIndex();
                            ServiceDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(size));
                        }
                    }
                }
                if (this.pnlMargins != null) {
                    this.pnlMargins.updateInfo();
                }
            }
        }

        public void addMediaListener(MarginsPanel pnl) {
            this.pnlMargins = pnl;
        }

        public void updateInfo() {
            Class<Media> mdCategory = Media.class;
            Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
            boolean mediaSupported = false;
            this.cbSize.removeItemListener(this);
            this.cbSize.removeAllItems();
            this.cbSource.removeItemListener(this);
            this.cbSource.removeAllItems();
            this.cbSource.addItem(this.getMediaName("auto-select"));
            this.sizes.clear();
            this.sources.clear();
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(mdCategory)) {
                mediaSupported = true;
                Object values = ServiceDialog.this.psCurrent.getSupportedAttributeValues(mdCategory, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent);
                if (values instanceof Media[]) {
                    Media[] media = (Media[])values;
                    for (int i = 0; i < media.length; ++i) {
                        Media medium = media[i];
                        if (medium instanceof MediaSizeName) {
                            this.sizes.add(medium);
                            this.cbSize.addItem(this.getMediaName(medium.toString()));
                            continue;
                        }
                        if (!(medium instanceof MediaTray)) continue;
                        this.sources.add(medium);
                        this.cbSource.addItem(this.getMediaName(medium.toString()));
                    }
                }
            }
            boolean msSupported = mediaSupported && this.sizes.size() > 0;
            this.lblSize.setEnabled(msSupported);
            this.cbSize.setEnabled(msSupported);
            if (ServiceDialog.this.isAWT) {
                this.cbSource.setEnabled(false);
                this.lblSource.setEnabled(false);
            } else {
                this.cbSource.setEnabled(mediaSupported);
            }
            if (mediaSupported) {
                int selIndex;
                MediaTray mt;
                Media md;
                Media medium = (Media)ServiceDialog.this.asCurrent.get(mdCategory);
                Media defMedia = (Media)ServiceDialog.this.psCurrent.getDefaultAttributeValue(mdCategory);
                if (defMedia instanceof MediaSizeName) {
                    this.cbSize.setSelectedIndex(this.sizes.size() > 0 ? this.sizes.indexOf(defMedia) : -1);
                }
                if (medium == null || !ServiceDialog.this.psCurrent.isAttributeValueSupported(medium, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) {
                    medium = defMedia;
                    if (medium == null && this.sizes.size() > 0) {
                        medium = (Media)this.sizes.get(0);
                    }
                    if (medium != null) {
                        ServiceDialog.this.asCurrent.add(medium);
                    }
                }
                if (medium != null) {
                    if (medium instanceof MediaSizeName) {
                        MediaSizeName ms = (MediaSizeName)medium;
                        this.cbSize.setSelectedIndex(this.sizes.indexOf(ms));
                    } else if (medium instanceof MediaTray) {
                        MediaTray mt2 = (MediaTray)medium;
                        this.cbSource.setSelectedIndex(this.sources.indexOf(mt2) + 1);
                    }
                } else {
                    this.cbSize.setSelectedIndex(this.sizes.size() > 0 ? 0 : -1);
                    this.cbSource.setSelectedIndex(0);
                }
                SunAlternateMedia alt = (SunAlternateMedia)ServiceDialog.this.asCurrent.get(amCategory);
                if (alt != null && (md = alt.getMedia()) instanceof MediaTray) {
                    mt = (MediaTray)md;
                    this.cbSource.setSelectedIndex(this.sources.indexOf(mt) + 1);
                }
                if ((selIndex = this.cbSize.getSelectedIndex()) >= 0 && selIndex < this.sizes.size()) {
                    ServiceDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(selIndex));
                }
                if ((selIndex = this.cbSource.getSelectedIndex()) >= 1 && selIndex < this.sources.size() + 1) {
                    mt = (MediaTray)this.sources.get(selIndex - 1);
                    if (medium instanceof MediaTray) {
                        ServiceDialog.this.asCurrent.add(mt);
                    } else {
                        ServiceDialog.this.asCurrent.add(new SunAlternateMedia(mt));
                    }
                }
            }
            this.cbSize.addItemListener(this);
            this.cbSource.addItemListener(this);
        }
    }

    private class MarginsPanel
    extends JPanel
    implements ActionListener,
    FocusListener {
        private final String strTitle = ServiceDialog.getMsg("border.margins");
        private JFormattedTextField leftMargin;
        private JFormattedTextField rightMargin;
        private JFormattedTextField topMargin;
        private JFormattedTextField bottomMargin;
        private JLabel lblLeft;
        private JLabel lblRight;
        private JLabel lblTop;
        private JLabel lblBottom;
        private int units = 1000;
        private float lmVal = -1.0f;
        private float rmVal = -1.0f;
        private float tmVal = -1.0f;
        private float bmVal = -1.0f;
        private Float lmObj;
        private Float rmObj;
        private Float tmObj;
        private Float bmObj;

        public MarginsPanel() {
            DecimalFormat format;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = compInsets;
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            String unitsKey = "label.millimetres";
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                unitsKey = "label.inches";
                this.units = 25400;
            }
            String unitsMsg = ServiceDialog.getMsg(unitsKey);
            if (this.units == 1000) {
                format = new DecimalFormat("###.##");
                format.setMaximumIntegerDigits(3);
            } else {
                format = new DecimalFormat("##.##");
                format.setMaximumIntegerDigits(2);
            }
            format.setMinimumFractionDigits(1);
            format.setMaximumFractionDigits(2);
            format.setMinimumIntegerDigits(1);
            format.setParseIntegerOnly(false);
            format.setDecimalSeparatorAlwaysShown(true);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(new Float(0.0f));
            nf.setMaximum(new Float(999.0f));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.leftMargin = new JFormattedTextField(nf);
            this.leftMargin.addFocusListener(this);
            this.leftMargin.addActionListener(this);
            this.leftMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.leftmargin"));
            this.rightMargin = new JFormattedTextField(nf);
            this.rightMargin.addFocusListener(this);
            this.rightMargin.addActionListener(this);
            this.rightMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.rightmargin"));
            this.topMargin = new JFormattedTextField(nf);
            this.topMargin.addFocusListener(this);
            this.topMargin.addActionListener(this);
            this.topMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.topmargin"));
            this.topMargin = new JFormattedTextField(nf);
            this.bottomMargin = new JFormattedTextField(nf);
            this.bottomMargin.addFocusListener(this);
            this.bottomMargin.addActionListener(this);
            this.bottomMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.bottommargin"));
            this.topMargin = new JFormattedTextField(nf);
            c.gridwidth = -1;
            this.lblLeft = new JLabel(ServiceDialog.getMsg("label.leftmargin") + " " + unitsMsg, 10);
            this.lblLeft.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.leftmargin"));
            this.lblLeft.setLabelFor(this.leftMargin);
            ServiceDialog.addToGB(this.lblLeft, this, gridbag, c);
            c.gridwidth = 0;
            this.lblRight = new JLabel(ServiceDialog.getMsg("label.rightmargin") + " " + unitsMsg, 10);
            this.lblRight.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.rightmargin"));
            this.lblRight.setLabelFor(this.rightMargin);
            ServiceDialog.addToGB(this.lblRight, this, gridbag, c);
            c.gridwidth = -1;
            ServiceDialog.addToGB(this.leftMargin, this, gridbag, c);
            c.gridwidth = 0;
            ServiceDialog.addToGB(this.rightMargin, this, gridbag, c);
            ServiceDialog.addToGB(new JPanel(), this, gridbag, c);
            c.gridwidth = -1;
            this.lblTop = new JLabel(ServiceDialog.getMsg("label.topmargin") + " " + unitsMsg, 10);
            this.lblTop.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.topmargin"));
            this.lblTop.setLabelFor(this.topMargin);
            ServiceDialog.addToGB(this.lblTop, this, gridbag, c);
            c.gridwidth = 0;
            this.lblBottom = new JLabel(ServiceDialog.getMsg("label.bottommargin") + " " + unitsMsg, 10);
            this.lblBottom.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.bottommargin"));
            this.lblBottom.setLabelFor(this.bottomMargin);
            ServiceDialog.addToGB(this.lblBottom, this, gridbag, c);
            c.gridwidth = -1;
            ServiceDialog.addToGB(this.topMargin, this, gridbag, c);
            c.gridwidth = 0;
            ServiceDialog.addToGB(this.bottomMargin, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        public void updateMargins(Object source) {
            if (!(source instanceof JFormattedTextField)) {
                return;
            }
            JFormattedTextField tf = (JFormattedTextField)source;
            Float val = (Float)tf.getValue();
            if (val == null) {
                return;
            }
            if (tf == this.leftMargin && val.equals(this.lmObj)) {
                return;
            }
            if (tf == this.rightMargin && val.equals(this.rmObj)) {
                return;
            }
            if (tf == this.topMargin && val.equals(this.tmObj)) {
                return;
            }
            if (tf == this.bottomMargin && val.equals(this.bmObj)) {
                return;
            }
            Float lmTmpObj = (Float)this.leftMargin.getValue();
            Float rmTmpObj = (Float)this.rightMargin.getValue();
            Float tmTmpObj = (Float)this.topMargin.getValue();
            Float bmTmpObj = (Float)this.bottomMargin.getValue();
            float lm = lmTmpObj.floatValue();
            float rm = rmTmpObj.floatValue();
            float tm = tmTmpObj.floatValue();
            float bm = bmTmpObj.floatValue();
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            OrientationRequested or = (OrientationRequested)ServiceDialog.this.asCurrent.get(orCategory);
            if (or == null) {
                or = (OrientationRequested)ServiceDialog.this.psCurrent.getDefaultAttributeValue(orCategory);
            }
            if (or == OrientationRequested.REVERSE_PORTRAIT) {
                float tmp = lm;
                lm = rm;
                rm = tmp;
                tmp = tm;
                tm = bm;
                bm = tmp;
            } else if (or == OrientationRequested.LANDSCAPE) {
                float tmp = lm;
                lm = tm;
                tm = rm;
                rm = bm;
                bm = tmp;
            } else if (or == OrientationRequested.REVERSE_LANDSCAPE) {
                float tmp = lm;
                lm = bm;
                bm = rm;
                rm = tm;
                tm = tmp;
            }
            MediaPrintableArea mpa = this.validateMargins(lm, rm, tm, bm);
            if (mpa != null) {
                ServiceDialog.this.asCurrent.add(mpa);
                this.lmVal = lm;
                this.rmVal = rm;
                this.tmVal = tm;
                this.bmVal = bm;
                this.lmObj = lmTmpObj;
                this.rmObj = rmTmpObj;
                this.tmObj = tmTmpObj;
                this.bmObj = bmTmpObj;
            } else {
                if (this.lmObj == null || this.rmObj == null || this.tmObj == null || this.rmObj == null) {
                    return;
                }
                this.leftMargin.setValue(this.lmObj);
                this.rightMargin.setValue(this.rmObj);
                this.topMargin.setValue(this.tmObj);
                this.bottomMargin.setValue(this.bmObj);
            }
        }

        private MediaPrintableArea validateMargins(float lm, float rm, float tm, float bm) {
            Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
            MediaPrintableArea mpaMax = null;
            MediaSize mediaSize = null;
            Media media = (Media)ServiceDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)ServiceDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media != null && media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(msn);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(ServiceDialog.this.asCurrent);
                tmpASet.add(media);
                Object values = ServiceDialog.this.psCurrent.getSupportedAttributeValues(mpaCategory, ServiceDialog.this.docFlavor, tmpASet);
                if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                    mpaMax = ((MediaPrintableArea[])values)[0];
                }
            }
            if (mpaMax == null) {
                mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float wid = mediaSize.getX(this.units);
            float hgt = mediaSize.getY(this.units);
            float pax = lm;
            float pay = tm;
            float paw = wid - lm - rm;
            float pah = hgt - tm - bm;
            if (paw <= 0.0f || pah <= 0.0f || pax < 0.0f || pay < 0.0f || pax < mpaMax.getX(this.units) || paw > mpaMax.getWidth(this.units) || pay < mpaMax.getY(this.units) || pah > mpaMax.getHeight(this.units)) {
                return null;
            }
            return new MediaPrintableArea(lm, tm, paw, pah, this.units);
        }

        public void updateInfo() {
            if (ServiceDialog.this.isAWT) {
                this.leftMargin.setEnabled(false);
                this.rightMargin.setEnabled(false);
                this.topMargin.setEnabled(false);
                this.bottomMargin.setEnabled(false);
                this.lblLeft.setEnabled(false);
                this.lblRight.setEnabled(false);
                this.lblTop.setEnabled(false);
                this.lblBottom.setEnabled(false);
                return;
            }
            Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
            MediaPrintableArea mpa = (MediaPrintableArea)ServiceDialog.this.asCurrent.get(mpaCategory);
            MediaPrintableArea mpaMax = null;
            MediaSize mediaSize = null;
            Media media = (Media)ServiceDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)ServiceDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media != null && media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(msn);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(ServiceDialog.this.asCurrent);
                tmpASet.add(media);
                Object values = ServiceDialog.this.psCurrent.getSupportedAttributeValues(mpaCategory, ServiceDialog.this.docFlavor, tmpASet);
                if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                    mpaMax = ((MediaPrintableArea[])values)[0];
                } else if (values instanceof MediaPrintableArea) {
                    mpaMax = (MediaPrintableArea)values;
                }
            }
            if (mpaMax == null) {
                mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float wid = mediaSize.getX(25400);
            float hgt = mediaSize.getY(25400);
            float maxMarginRatio = 5.0f;
            float xMgn = wid > maxMarginRatio ? 1.0f : wid / maxMarginRatio;
            float yMgn = hgt > maxMarginRatio ? 1.0f : hgt / maxMarginRatio;
            if (mpa == null) {
                mpa = new MediaPrintableArea(xMgn, yMgn, wid - 2.0f * xMgn, hgt - 2.0f * yMgn, 25400);
                ServiceDialog.this.asCurrent.add(mpa);
            }
            float pax = mpa.getX(this.units);
            float pay = mpa.getY(this.units);
            float paw = mpa.getWidth(this.units);
            float pah = mpa.getHeight(this.units);
            float paxMax = mpaMax.getX(this.units);
            float payMax = mpaMax.getY(this.units);
            float pawMax = mpaMax.getWidth(this.units);
            float pahMax = mpaMax.getHeight(this.units);
            boolean invalid = false;
            wid = mediaSize.getX(this.units);
            hgt = mediaSize.getY(this.units);
            if (this.lmVal >= 0.0f) {
                invalid = true;
                if (this.lmVal + this.rmVal > wid) {
                    if (paw > pawMax) {
                        paw = pawMax;
                    }
                    pax = (wid - paw) / 2.0f;
                } else {
                    pax = this.lmVal >= paxMax ? this.lmVal : paxMax;
                    paw = wid - pax - this.rmVal;
                }
                if (this.tmVal + this.bmVal > hgt) {
                    if (pah > pahMax) {
                        pah = pahMax;
                    }
                    pay = (hgt - pah) / 2.0f;
                } else {
                    pay = this.tmVal >= payMax ? this.tmVal : payMax;
                    pah = hgt - pay - this.bmVal;
                }
            }
            if (pax < paxMax) {
                invalid = true;
                pax = paxMax;
            }
            if (pay < payMax) {
                invalid = true;
                pay = payMax;
            }
            if (paw > pawMax) {
                invalid = true;
                paw = pawMax;
            }
            if (pah > pahMax) {
                invalid = true;
                pah = pahMax;
            }
            if (pax + paw > paxMax + pawMax || paw <= 0.0f) {
                invalid = true;
                pax = paxMax;
                paw = pawMax;
            }
            if (pay + pah > payMax + pahMax || pah <= 0.0f) {
                invalid = true;
                pay = payMax;
                pah = pahMax;
            }
            if (invalid) {
                mpa = new MediaPrintableArea(pax, pay, paw, pah, this.units);
                ServiceDialog.this.asCurrent.add(mpa);
            }
            this.lmVal = pax;
            this.tmVal = pay;
            this.rmVal = mediaSize.getX(this.units) - pax - paw;
            this.bmVal = mediaSize.getY(this.units) - pay - pah;
            this.lmObj = new Float(this.lmVal);
            this.rmObj = new Float(this.rmVal);
            this.tmObj = new Float(this.tmVal);
            this.bmObj = new Float(this.bmVal);
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            OrientationRequested or = (OrientationRequested)ServiceDialog.this.asCurrent.get(orCategory);
            if (or == null) {
                or = (OrientationRequested)ServiceDialog.this.psCurrent.getDefaultAttributeValue(orCategory);
            }
            if (or == OrientationRequested.REVERSE_PORTRAIT) {
                Float tmp = this.lmObj;
                this.lmObj = this.rmObj;
                this.rmObj = tmp;
                tmp = this.tmObj;
                this.tmObj = this.bmObj;
                this.bmObj = tmp;
            } else if (or == OrientationRequested.LANDSCAPE) {
                Float tmp = this.lmObj;
                this.lmObj = this.bmObj;
                this.bmObj = this.rmObj;
                this.rmObj = this.tmObj;
                this.tmObj = tmp;
            } else if (or == OrientationRequested.REVERSE_LANDSCAPE) {
                Float tmp = this.lmObj;
                this.lmObj = this.tmObj;
                this.tmObj = this.rmObj;
                this.rmObj = this.bmObj;
                this.bmObj = tmp;
            }
            this.leftMargin.setValue(this.lmObj);
            this.rightMargin.setValue(this.rmObj);
            this.topMargin.setValue(this.tmObj);
            this.bottomMargin.setValue(this.bmObj);
        }
    }

    private class PageSetupPanel
    extends JPanel {
        private MediaPanel pnlMedia;
        private OrientationPanel pnlOrientation;
        private MarginsPanel pnlMargins;

        public PageSetupPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            c.fill = 1;
            c.insets = panelInsets;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            this.pnlMedia = new MediaPanel();
            ServiceDialog.addToGB(this.pnlMedia, this, gridbag, c);
            this.pnlOrientation = new OrientationPanel();
            c.gridwidth = -1;
            ServiceDialog.addToGB(this.pnlOrientation, this, gridbag, c);
            this.pnlMargins = new MarginsPanel();
            this.pnlOrientation.addOrientationListener(this.pnlMargins);
            this.pnlMedia.addMediaListener(this.pnlMargins);
            c.gridwidth = 0;
            ServiceDialog.addToGB(this.pnlMargins, this, gridbag, c);
        }

        public void updateInfo() {
            this.pnlMedia.updateInfo();
            this.pnlOrientation.updateInfo();
            this.pnlMargins.updateInfo();
        }
    }

    private class CopiesPanel
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private final String strTitle = ServiceDialog.getMsg("border.copies");
        private SpinnerNumberModel snModel;
        private JSpinner spinCopies;
        private JLabel lblCopies;
        private JCheckBox cbCollate;
        private boolean scSupported;

        public CopiesPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 2;
            c.insets = compInsets;
            this.lblCopies = new JLabel(ServiceDialog.getMsg("label.numcopies"), 11);
            this.lblCopies.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.numcopies"));
            this.lblCopies.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.numcopies"));
            ServiceDialog.addToGB(this.lblCopies, this, gridbag, c);
            this.snModel = new SpinnerNumberModel(1, 1, 999, 1);
            this.spinCopies = new JSpinner(this.snModel);
            this.lblCopies.setLabelFor(this.spinCopies);
            ((JSpinner.NumberEditor)this.spinCopies.getEditor()).getTextField().setColumns(3);
            this.spinCopies.addChangeListener(this);
            c.gridwidth = 0;
            ServiceDialog.addToGB(this.spinCopies, this, gridbag, c);
            this.cbCollate = ServiceDialog.createCheckBox("checkbox.collate", this);
            this.cbCollate.setEnabled(false);
            ServiceDialog.addToGB(this.cbCollate, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.cbCollate.isSelected()) {
                ServiceDialog.this.asCurrent.add(SheetCollate.COLLATED);
            } else {
                ServiceDialog.this.asCurrent.add(SheetCollate.UNCOLLATED);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateCollateCB();
            ServiceDialog.this.asCurrent.add(new Copies(this.snModel.getNumber().intValue()));
        }

        private void updateCollateCB() {
            int num = this.snModel.getNumber().intValue();
            if (ServiceDialog.this.isAWT) {
                this.cbCollate.setEnabled(true);
            } else {
                this.cbCollate.setEnabled(num > 1 && this.scSupported);
            }
        }

        public void updateInfo() {
            SheetCollate sc;
            int max;
            int min;
            Copies cp;
            CopiesSupported cs;
            Class<Copies> cpCategory = Copies.class;
            Class<CopiesSupported> csCategory = CopiesSupported.class;
            Class<SheetCollate> scCategory = SheetCollate.class;
            boolean cpSupported = false;
            this.scSupported = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(cpCategory)) {
                cpSupported = true;
            }
            if ((cs = (CopiesSupported)ServiceDialog.this.psCurrent.getSupportedAttributeValues(cpCategory, null, null)) == null) {
                cs = new CopiesSupported(1, 999);
            }
            if ((cp = (Copies)ServiceDialog.this.asCurrent.get(cpCategory)) == null && (cp = (Copies)ServiceDialog.this.psCurrent.getDefaultAttributeValue(cpCategory)) == null) {
                cp = new Copies(1);
            }
            this.spinCopies.setEnabled(cpSupported);
            this.lblCopies.setEnabled(cpSupported);
            int[][] members = cs.getMembers();
            if (members.length > 0 && members[0].length > 0) {
                min = members[0][0];
                max = members[0][1];
            } else {
                min = 1;
                max = Integer.MAX_VALUE;
            }
            this.snModel.setMinimum(new Integer(min));
            this.snModel.setMaximum(new Integer(max));
            int value = cp.getValue();
            if (value < min || value > max) {
                value = min;
            }
            this.snModel.setValue(new Integer(value));
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(scCategory)) {
                this.scSupported = true;
            }
            if ((sc = (SheetCollate)ServiceDialog.this.asCurrent.get(scCategory)) == null && (sc = (SheetCollate)ServiceDialog.this.psCurrent.getDefaultAttributeValue(scCategory)) == null) {
                sc = SheetCollate.UNCOLLATED;
            }
            this.cbCollate.setSelected(sc == SheetCollate.COLLATED);
            this.updateCollateCB();
        }
    }

    private class PrintRangePanel
    extends JPanel
    implements ActionListener,
    FocusListener {
        private final String strTitle = ServiceDialog.getMsg("border.printrange");
        private final PageRanges prAll = new PageRanges(1, Integer.MAX_VALUE);
        private JRadioButton rbAll;
        private JRadioButton rbPages;
        private JRadioButton rbSelect;
        private JFormattedTextField tfRangeFrom;
        private JFormattedTextField tfRangeTo;
        private JLabel lblRangeTo;
        private boolean prSupported;

        public PrintRangePanel() {
            NumberFormatter nfto;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            c.fill = 1;
            c.insets = compInsets;
            c.gridwidth = 0;
            ButtonGroup bg = new ButtonGroup();
            JPanel pnlTop = new JPanel(new FlowLayout(3));
            this.rbAll = ServiceDialog.createRadioButton("radiobutton.rangeall", this);
            this.rbAll.setSelected(true);
            bg.add(this.rbAll);
            pnlTop.add(this.rbAll);
            ServiceDialog.addToGB(pnlTop, this, gridbag, c);
            JPanel pnlBottom = new JPanel(new FlowLayout(3));
            this.rbPages = ServiceDialog.createRadioButton("radiobutton.rangepages", this);
            bg.add(this.rbPages);
            pnlBottom.add(this.rbPages);
            DecimalFormat format = new DecimalFormat("####0");
            format.setMinimumFractionDigits(0);
            format.setMaximumFractionDigits(0);
            format.setMinimumIntegerDigits(0);
            format.setMaximumIntegerDigits(5);
            format.setParseIntegerOnly(true);
            format.setDecimalSeparatorAlwaysShown(false);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(new Integer(1));
            nf.setMaximum(new Integer(Integer.MAX_VALUE));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.tfRangeFrom = new JFormattedTextField(nf);
            this.tfRangeFrom.setColumns(4);
            this.tfRangeFrom.setEnabled(false);
            this.tfRangeFrom.addActionListener(this);
            this.tfRangeFrom.addFocusListener(this);
            this.tfRangeFrom.setFocusLostBehavior(3);
            this.tfRangeFrom.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("radiobutton.rangepages"));
            pnlBottom.add(this.tfRangeFrom);
            this.lblRangeTo = new JLabel(ServiceDialog.getMsg("label.rangeto"));
            this.lblRangeTo.setEnabled(false);
            pnlBottom.add(this.lblRangeTo);
            try {
                nfto = (NumberFormatter)nf.clone();
            }
            catch (CloneNotSupportedException e) {
                nfto = new NumberFormatter();
            }
            this.tfRangeTo = new JFormattedTextField(nfto);
            this.tfRangeTo.setColumns(4);
            this.tfRangeTo.setEnabled(false);
            this.tfRangeTo.addFocusListener(this);
            this.tfRangeTo.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.rangeto"));
            pnlBottom.add(this.tfRangeTo);
            ServiceDialog.addToGB(pnlBottom, this, gridbag, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            SunPageSelection select = SunPageSelection.ALL;
            this.setupRangeWidgets();
            if (source == this.rbAll) {
                ServiceDialog.this.asCurrent.add(this.prAll);
            } else if (source == this.rbSelect) {
                select = SunPageSelection.SELECTION;
            } else if (source == this.rbPages || source == this.tfRangeFrom || source == this.tfRangeTo) {
                this.updateRangeAttribute();
                select = SunPageSelection.RANGE;
            }
            if (ServiceDialog.this.isAWT) {
                ServiceDialog.this.asCurrent.add(select);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == this.tfRangeFrom || source == this.tfRangeTo) {
                this.updateRangeAttribute();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        private void setupRangeWidgets() {
            boolean rangeEnabled = this.rbPages.isSelected() && this.prSupported;
            this.tfRangeFrom.setEnabled(rangeEnabled);
            this.tfRangeTo.setEnabled(rangeEnabled);
            this.lblRangeTo.setEnabled(rangeEnabled);
        }

        private void updateRangeAttribute() {
            int max;
            int min;
            String strFrom = this.tfRangeFrom.getText();
            String strTo = this.tfRangeTo.getText();
            try {
                min = Integer.parseInt(strFrom);
            }
            catch (NumberFormatException e) {
                min = 1;
            }
            try {
                max = Integer.parseInt(strTo);
            }
            catch (NumberFormatException e) {
                max = min;
            }
            if (min < 1) {
                min = 1;
                this.tfRangeFrom.setValue(new Integer(1));
            }
            if (max < min) {
                max = min;
                this.tfRangeTo.setValue(new Integer(min));
            }
            PageRanges pr = new PageRanges(min, max);
            ServiceDialog.this.asCurrent.add(pr);
        }

        public void updateInfo() {
            Class<PageRanges> prCategory = PageRanges.class;
            this.prSupported = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(prCategory) || ServiceDialog.this.isAWT) {
                this.prSupported = true;
            }
            SunPageSelection select = SunPageSelection.ALL;
            int min = 1;
            int max = 1;
            PageRanges pr = (PageRanges)ServiceDialog.this.asCurrent.get(prCategory);
            if (pr != null && !pr.equals(this.prAll)) {
                select = SunPageSelection.RANGE;
                int[][] members = pr.getMembers();
                if (members.length > 0 && members[0].length > 1) {
                    min = members[0][0];
                    max = members[0][1];
                }
            }
            if (ServiceDialog.this.isAWT) {
                select = (SunPageSelection)ServiceDialog.this.asCurrent.get(SunPageSelection.class);
            }
            if (select == SunPageSelection.ALL) {
                this.rbAll.setSelected(true);
            } else if (select != SunPageSelection.SELECTION) {
                this.rbPages.setSelected(true);
            }
            this.tfRangeFrom.setValue(new Integer(min));
            this.tfRangeTo.setValue(new Integer(max));
            this.rbAll.setEnabled(this.prSupported);
            this.rbPages.setEnabled(this.prSupported);
            this.setupRangeWidgets();
        }
    }

    private class PrintServicePanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    PopupMenuListener {
        private final String strTitle = ServiceDialog.getMsg("border.printservice");
        private FilePermission printToFilePermission;
        private JButton btnProperties;
        private JCheckBox cbPrintToFile;
        private JComboBox cbName;
        private JLabel lblType;
        private JLabel lblStatus;
        private JLabel lblInfo;
        private ServiceUIFactory uiFactory;
        private boolean changedService = false;
        private boolean filePermission;

        public PrintServicePanel() {
            this.uiFactory = ServiceDialog.this.psCurrent.getServiceUIFactory();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            String[] psnames = new String[ServiceDialog.this.services.length];
            for (int i = 0; i < psnames.length; ++i) {
                psnames[i] = ServiceDialog.this.services[i].getName();
            }
            this.cbName = new JComboBox<String>(psnames);
            this.cbName.setSelectedIndex(ServiceDialog.this.defaultServiceIndex);
            this.cbName.addItemListener(this);
            this.cbName.addPopupMenuListener(this);
            c.fill = 1;
            c.insets = compInsets;
            c.weightx = 0.0;
            JLabel lblName = new JLabel(ServiceDialog.getMsg("label.psname"), 11);
            lblName.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.psname"));
            lblName.setLabelFor(this.cbName);
            ServiceDialog.addToGB(lblName, this, gridbag, c);
            c.weightx = 1.0;
            c.gridwidth = -1;
            ServiceDialog.addToGB(this.cbName, this, gridbag, c);
            c.weightx = 0.0;
            c.gridwidth = 0;
            this.btnProperties = ServiceDialog.createButton("button.properties", this);
            ServiceDialog.addToGB(this.btnProperties, this, gridbag, c);
            c.weighty = 1.0;
            this.lblStatus = this.addLabel(ServiceDialog.getMsg("label.status"), gridbag, c);
            this.lblStatus.setLabelFor(null);
            this.lblType = this.addLabel(ServiceDialog.getMsg("label.pstype"), gridbag, c);
            this.lblType.setLabelFor(null);
            c.gridwidth = 1;
            ServiceDialog.addToGB(new JLabel(ServiceDialog.getMsg("label.info"), 11), this, gridbag, c);
            c.gridwidth = -1;
            this.lblInfo = new JLabel();
            this.lblInfo.setLabelFor(null);
            ServiceDialog.addToGB(this.lblInfo, this, gridbag, c);
            c.gridwidth = 0;
            this.cbPrintToFile = ServiceDialog.createCheckBox("checkbox.printtofile", this);
            ServiceDialog.addToGB(this.cbPrintToFile, this, gridbag, c);
            this.filePermission = this.allowedToPrintToFile();
        }

        public boolean isPrintToFileSelected() {
            return this.cbPrintToFile.isSelected();
        }

        private JLabel addLabel(String text, GridBagLayout gridbag, GridBagConstraints c) {
            c.gridwidth = 1;
            ServiceDialog.addToGB(new JLabel(text, 11), this, gridbag, c);
            c.gridwidth = 0;
            JLabel label = new JLabel();
            ServiceDialog.addToGB(label, this, gridbag, c);
            return label;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.btnProperties && this.uiFactory != null) {
                JDialog dialog = (JDialog)this.uiFactory.getUI(3, "javax.swing.JDialog");
                if (dialog != null) {
                    dialog.show();
                } else {
                    DocumentPropertiesUI docPropertiesUI = null;
                    try {
                        docPropertiesUI = (DocumentPropertiesUI)this.uiFactory.getUI(199, DocumentPropertiesUI.DOCPROPERTIESCLASSNAME);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (docPropertiesUI != null) {
                        PrinterJobWrapper wrapper = (PrinterJobWrapper)ServiceDialog.this.asCurrent.get(PrinterJobWrapper.class);
                        if (wrapper == null) {
                            return;
                        }
                        PrinterJob job = wrapper.getPrinterJob();
                        if (job == null) {
                            return;
                        }
                        PrintRequestAttributeSet newAttrs = docPropertiesUI.showDocumentProperties(job, ServiceDialog.this, ServiceDialog.this.psCurrent, ServiceDialog.this.asCurrent);
                        if (newAttrs != null) {
                            ServiceDialog.this.asCurrent.addAll(newAttrs);
                            ServiceDialog.this.updatePanels();
                        }
                    }
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int index;
            if (e.getStateChange() == 1 && (index = this.cbName.getSelectedIndex()) >= 0 && index < ServiceDialog.this.services.length && !ServiceDialog.this.services[index].equals(ServiceDialog.this.psCurrent)) {
                ServiceDialog.this.psCurrent = ServiceDialog.this.services[index];
                this.uiFactory = ServiceDialog.this.psCurrent.getServiceUIFactory();
                this.changedService = true;
                Destination dest = (Destination)ServiceDialog.this.asOriginal.get(Destination.class);
                if ((dest != null || this.isPrintToFileSelected()) && ServiceDialog.this.psCurrent.isAttributeCategorySupported(Destination.class)) {
                    if (dest != null) {
                        ServiceDialog.this.asCurrent.add(dest);
                    } else {
                        dest = (Destination)ServiceDialog.this.psCurrent.getDefaultAttributeValue(Destination.class);
                        if (dest == null) {
                            try {
                                dest = new Destination(new URI("file:out.prn"));
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                        }
                        if (dest != null) {
                            ServiceDialog.this.asCurrent.add(dest);
                        }
                    }
                } else {
                    ServiceDialog.this.asCurrent.remove(Destination.class);
                }
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.changedService = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this.changedService) {
                this.changedService = false;
                ServiceDialog.this.updatePanels();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private boolean allowedToPrintToFile() {
            try {
                this.throwPrintToFile();
                return true;
            }
            catch (SecurityException e) {
                return false;
            }
        }

        private void throwPrintToFile() {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                if (this.printToFilePermission == null) {
                    this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
                }
                security.checkPermission(this.printToFilePermission);
            }
        }

        public void updateInfo() {
            PrinterInfo info;
            PrinterIsAcceptingJobs status;
            Destination dst;
            boolean dstAllowed;
            Class<Destination> dstCategory = Destination.class;
            boolean dstSupported = false;
            boolean dstSelected = false;
            boolean bl = dstAllowed = this.filePermission ? this.allowedToPrintToFile() : false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(dstCategory)) {
                dstSupported = true;
            }
            if ((dst = (Destination)ServiceDialog.this.asCurrent.get(dstCategory)) != null) {
                dstSelected = true;
            }
            this.cbPrintToFile.setEnabled(dstSupported && dstAllowed);
            this.cbPrintToFile.setSelected(dstSelected && dstAllowed && dstSupported);
            PrinterMakeAndModel type = ServiceDialog.this.psCurrent.getAttribute(PrinterMakeAndModel.class);
            if (type != null) {
                this.lblType.setText(((Object)type).toString());
            }
            if ((status = ServiceDialog.this.psCurrent.getAttribute(PrinterIsAcceptingJobs.class)) != null) {
                this.lblStatus.setText(ServiceDialog.getMsg(((Object)status).toString()));
            }
            if ((info = ServiceDialog.this.psCurrent.getAttribute(PrinterInfo.class)) != null) {
                this.lblInfo.setText(((Object)info).toString());
            }
            this.btnProperties.setEnabled(this.uiFactory != null);
        }
    }

    private class GeneralPanel
    extends JPanel {
        private PrintServicePanel pnlPrintService;
        private PrintRangePanel pnlPrintRange;
        private CopiesPanel pnlCopies;

        public GeneralPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            c.fill = 1;
            c.insets = panelInsets;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            this.pnlPrintService = new PrintServicePanel();
            ServiceDialog.addToGB(this.pnlPrintService, this, gridbag, c);
            c.gridwidth = -1;
            this.pnlPrintRange = new PrintRangePanel();
            ServiceDialog.addToGB(this.pnlPrintRange, this, gridbag, c);
            c.gridwidth = 0;
            this.pnlCopies = new CopiesPanel();
            ServiceDialog.addToGB(this.pnlCopies, this, gridbag, c);
        }

        public boolean isPrintToFileRequested() {
            return this.pnlPrintService.isPrintToFileSelected();
        }

        public void updateInfo() {
            this.pnlPrintService.updateInfo();
            this.pnlPrintRange.updateInfo();
            this.pnlCopies.updateInfo();
        }
    }
}

