/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class WildcardTypeImpl
extends LazyReflectiveObjectGenerator
implements WildcardType {
    private Type[] upperBounds;
    private Type[] lowerBounds;
    private FieldTypeSignature[] upperBoundASTs;
    private FieldTypeSignature[] lowerBoundASTs;

    private WildcardTypeImpl(FieldTypeSignature[] ubs, FieldTypeSignature[] lbs, GenericsFactory f) {
        super(f);
        this.upperBoundASTs = ubs;
        this.lowerBoundASTs = lbs;
    }

    public static WildcardTypeImpl make(FieldTypeSignature[] ubs, FieldTypeSignature[] lbs, GenericsFactory f) {
        return new WildcardTypeImpl(ubs, lbs, f);
    }

    private FieldTypeSignature[] getUpperBoundASTs() {
        assert (this.upperBounds == null);
        return this.upperBoundASTs;
    }

    private FieldTypeSignature[] getLowerBoundASTs() {
        assert (this.lowerBounds == null);
        return this.lowerBoundASTs;
    }

    @Override
    public Type[] getUpperBounds() {
        if (this.upperBounds == null) {
            FieldTypeSignature[] fts = this.getUpperBoundASTs();
            Type[] ts = new Type[fts.length];
            for (int j = 0; j < fts.length; ++j) {
                Reifier r = this.getReifier();
                fts[j].accept(r);
                ts[j] = r.getResult();
            }
            this.upperBounds = ts;
        }
        return (Type[])this.upperBounds.clone();
    }

    @Override
    public Type[] getLowerBounds() {
        if (this.lowerBounds == null) {
            FieldTypeSignature[] fts = this.getLowerBoundASTs();
            Type[] ts = new Type[fts.length];
            for (int j = 0; j < fts.length; ++j) {
                Reifier r = this.getReifier();
                fts[j].accept(r);
                ts[j] = r.getResult();
            }
            this.lowerBounds = ts;
        }
        return (Type[])this.lowerBounds.clone();
    }

    public String toString() {
        Type[] lowerBounds;
        Type[] bounds = lowerBounds = this.getLowerBounds();
        StringBuilder sb = new StringBuilder();
        if (lowerBounds.length > 0) {
            sb.append("? super ");
        } else {
            Type[] upperBounds = this.getUpperBounds();
            if (upperBounds.length > 0 && !upperBounds[0].equals(Object.class)) {
                bounds = upperBounds;
                sb.append("? extends ");
            } else {
                return "?";
            }
        }
        assert (bounds.length > 0);
        boolean first = true;
        for (Type bound : bounds) {
            if (!first) {
                sb.append(" & ");
            }
            first = false;
            if (bound instanceof Class) {
                sb.append(((Class)bound).getName());
                continue;
            }
            sb.append(bound.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardType) {
            WildcardType that = (WildcardType)o;
            return Arrays.equals(this.getLowerBounds(), that.getLowerBounds()) && Arrays.equals(this.getUpperBounds(), that.getUpperBounds());
        }
        return false;
    }

    public int hashCode() {
        Object[] lowerBounds = this.getLowerBounds();
        Object[] upperBounds = this.getUpperBounds();
        return Arrays.hashCode(lowerBounds) ^ Arrays.hashCode(upperBounds);
    }
}

