/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingChooser;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.FixedList;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageReader;
import com.sun.java.util.jar.pack.PackageWriter;
import com.sun.java.util.jar.pack.PopulationCoding;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class BandStructure {
    static final int MAX_EFFORT = 9;
    static final int MIN_EFFORT = 1;
    static final int DEFAULT_EFFORT = 5;
    PropMap p200 = Utils.currentPropMap();
    int verbose = this.p200.getInteger("com.sun.java.util.jar.pack.verbose");
    int effort = this.p200.getInteger("pack.effort");
    boolean optDumpBands;
    boolean optDebugBands;
    boolean optVaryCodings;
    boolean optBigStrings;
    private int packageMajver;
    private final boolean isReader;
    static final Coding BYTE1;
    static final Coding CHAR3;
    static final Coding BCI5;
    static final Coding BRANCH5;
    static final Coding UNSIGNED5;
    static final Coding UDELTA5;
    static final Coding SIGNED5;
    static final Coding DELTA5;
    static final Coding MDELTA5;
    private static final Coding[] basicCodings;
    private static final Map<Coding, Integer> basicCodingIndexes;
    protected byte[] bandHeaderBytes;
    protected int bandHeaderBytePos;
    protected int bandHeaderBytePos0;
    static final int SHORT_BAND_HEURISTIC = 100;
    public static final int NO_PHASE = 0;
    public static final int COLLECT_PHASE = 1;
    public static final int FROZEN_PHASE = 3;
    public static final int WRITE_PHASE = 5;
    public static final int EXPECT_PHASE = 2;
    public static final int READ_PHASE = 4;
    public static final int DISBURSE_PHASE = 6;
    public static final int DONE_PHASE = 8;
    private final List<CPRefBand> allKQBands;
    private List<Object[]> needPredefIndex;
    private CodingChooser codingChooser;
    static final byte[] defaultMetaCoding;
    static final byte[] noMetaCoding;
    ByteCounter outputCounter;
    protected int archiveOptions;
    protected long archiveSize0;
    protected long archiveSize1;
    protected int archiveNextCount;
    static final int AH_LENGTH_0 = 3;
    static final int AH_ARCHIVE_SIZE_HI = 0;
    static final int AH_ARCHIVE_SIZE_LO = 1;
    static final int AH_LENGTH_S = 2;
    static final int AH_LENGTH = 26;
    static final int AH_FILE_HEADER_LEN = 5;
    static final int AH_SPECIAL_FORMAT_LEN = 2;
    static final int AH_CP_NUMBER_LEN = 4;
    static final int AH_LENGTH_MIN = 15;
    static final int AB_FLAGS_HI = 0;
    static final int AB_FLAGS_LO = 1;
    static final int AB_ATTR_COUNT = 2;
    static final int AB_ATTR_INDEXES = 3;
    static final int AB_ATTR_CALLS = 4;
    private static final boolean NULL_IS_OK = true;
    MultiBand all_bands;
    ByteBand archive_magic;
    IntBand archive_header_0;
    IntBand archive_header_S;
    IntBand archive_header_1;
    ByteBand band_headers;
    MultiBand cp_bands;
    IntBand cp_Utf8_prefix;
    IntBand cp_Utf8_suffix;
    IntBand cp_Utf8_chars;
    IntBand cp_Utf8_big_suffix;
    MultiBand cp_Utf8_big_chars;
    IntBand cp_Int;
    IntBand cp_Float;
    IntBand cp_Long_hi;
    IntBand cp_Long_lo;
    IntBand cp_Double_hi;
    IntBand cp_Double_lo;
    CPRefBand cp_String;
    CPRefBand cp_Class;
    CPRefBand cp_Signature_form;
    CPRefBand cp_Signature_classes;
    CPRefBand cp_Descr_name;
    CPRefBand cp_Descr_type;
    CPRefBand cp_Field_class;
    CPRefBand cp_Field_desc;
    CPRefBand cp_Method_class;
    CPRefBand cp_Method_desc;
    CPRefBand cp_Imethod_class;
    CPRefBand cp_Imethod_desc;
    MultiBand attr_definition_bands;
    ByteBand attr_definition_headers;
    CPRefBand attr_definition_name;
    CPRefBand attr_definition_layout;
    MultiBand ic_bands;
    CPRefBand ic_this_class;
    IntBand ic_flags;
    CPRefBand ic_outer_class;
    CPRefBand ic_name;
    MultiBand class_bands;
    CPRefBand class_this;
    CPRefBand class_super;
    IntBand class_interface_count;
    CPRefBand class_interface;
    IntBand class_field_count;
    IntBand class_method_count;
    CPRefBand field_descr;
    MultiBand field_attr_bands;
    IntBand field_flags_hi;
    IntBand field_flags_lo;
    IntBand field_attr_count;
    IntBand field_attr_indexes;
    IntBand field_attr_calls;
    CPRefBand field_ConstantValue_KQ;
    CPRefBand field_Signature_RS;
    MultiBand field_metadata_bands;
    CPRefBand method_descr;
    MultiBand method_attr_bands;
    IntBand method_flags_hi;
    IntBand method_flags_lo;
    IntBand method_attr_count;
    IntBand method_attr_indexes;
    IntBand method_attr_calls;
    IntBand method_Exceptions_N;
    CPRefBand method_Exceptions_RC;
    CPRefBand method_Signature_RS;
    MultiBand method_metadata_bands;
    MultiBand class_attr_bands;
    IntBand class_flags_hi;
    IntBand class_flags_lo;
    IntBand class_attr_count;
    IntBand class_attr_indexes;
    IntBand class_attr_calls;
    CPRefBand class_SourceFile_RUN;
    CPRefBand class_EnclosingMethod_RC;
    CPRefBand class_EnclosingMethod_RDN;
    CPRefBand class_Signature_RS;
    MultiBand class_metadata_bands;
    IntBand class_InnerClasses_N;
    CPRefBand class_InnerClasses_RC;
    IntBand class_InnerClasses_F;
    CPRefBand class_InnerClasses_outer_RCN;
    CPRefBand class_InnerClasses_name_RUN;
    IntBand class_ClassFile_version_minor_H;
    IntBand class_ClassFile_version_major_H;
    MultiBand code_bands;
    ByteBand code_headers;
    IntBand code_max_stack;
    IntBand code_max_na_locals;
    IntBand code_handler_count;
    IntBand code_handler_start_P;
    IntBand code_handler_end_PO;
    IntBand code_handler_catch_PO;
    CPRefBand code_handler_class_RCN;
    MultiBand code_attr_bands;
    IntBand code_flags_hi;
    IntBand code_flags_lo;
    IntBand code_attr_count;
    IntBand code_attr_indexes;
    IntBand code_attr_calls;
    MultiBand stackmap_bands;
    IntBand code_StackMapTable_N;
    IntBand code_StackMapTable_frame_T;
    IntBand code_StackMapTable_local_N;
    IntBand code_StackMapTable_stack_N;
    IntBand code_StackMapTable_offset;
    IntBand code_StackMapTable_T;
    CPRefBand code_StackMapTable_RC;
    IntBand code_StackMapTable_P;
    IntBand code_LineNumberTable_N;
    IntBand code_LineNumberTable_bci_P;
    IntBand code_LineNumberTable_line;
    IntBand code_LocalVariableTable_N;
    IntBand code_LocalVariableTable_bci_P;
    IntBand code_LocalVariableTable_span_O;
    CPRefBand code_LocalVariableTable_name_RU;
    CPRefBand code_LocalVariableTable_type_RS;
    IntBand code_LocalVariableTable_slot;
    IntBand code_LocalVariableTypeTable_N;
    IntBand code_LocalVariableTypeTable_bci_P;
    IntBand code_LocalVariableTypeTable_span_O;
    CPRefBand code_LocalVariableTypeTable_name_RU;
    CPRefBand code_LocalVariableTypeTable_type_RS;
    IntBand code_LocalVariableTypeTable_slot;
    MultiBand bc_bands;
    ByteBand bc_codes;
    IntBand bc_case_count;
    IntBand bc_case_value;
    ByteBand bc_byte;
    IntBand bc_short;
    IntBand bc_local;
    IntBand bc_label;
    CPRefBand bc_intref;
    CPRefBand bc_floatref;
    CPRefBand bc_longref;
    CPRefBand bc_doubleref;
    CPRefBand bc_stringref;
    CPRefBand bc_classref;
    CPRefBand bc_fieldref;
    CPRefBand bc_methodref;
    CPRefBand bc_imethodref;
    CPRefBand bc_thisfield;
    CPRefBand bc_superfield;
    CPRefBand bc_thismethod;
    CPRefBand bc_supermethod;
    IntBand bc_initref;
    CPRefBand bc_escref;
    IntBand bc_escrefsize;
    IntBand bc_escsize;
    ByteBand bc_escbyte;
    MultiBand file_bands;
    CPRefBand file_name;
    IntBand file_size_hi;
    IntBand file_size_lo;
    IntBand file_modtime;
    IntBand file_options;
    ByteBand file_bits;
    protected MultiBand[] metadataBands;
    public static final int ADH_CONTEXT_MASK = 3;
    public static final int ADH_BIT_SHIFT = 2;
    public static final int ADH_BIT_IS_LSB = 1;
    public static final int ATTR_INDEX_OVERFLOW = -1;
    public int[] attrIndexLimit;
    protected long[] attrFlagMask;
    protected long[] attrDefSeen;
    protected int[] attrOverflowMask;
    protected int attrClassFileVersionMask;
    protected Map<Attribute.Layout, Band[]> attrBandTable;
    protected final Attribute.Layout attrCodeEmpty;
    protected final Attribute.Layout attrInnerClassesEmpty;
    protected final Attribute.Layout attrClassFileVersion;
    protected final Attribute.Layout attrConstantValue;
    Map<Attribute.Layout, Integer> attrIndexTable;
    protected List<List<Attribute.Layout>> attrDefs;
    protected MultiBand[] attrBands;
    private static final int[][] shortCodeLimits;
    public final int shortCodeHeader_h_limit;
    static final int LONG_CODE_HEADER = 0;
    static int nextSeqForDebug;
    static File dumpDir;
    private Map<Band, Band> prevForAssertMap;

    protected abstract ConstantPool.Index getCPIndex(byte var1);

    public void initPackageMajver(int packageMajver) throws IOException {
        assert (packageMajver > 0 && packageMajver < 65536);
        if (this.packageMajver > 0) {
            throw new IOException("Package majver is already initialized to " + this.packageMajver + "; new setting is " + packageMajver);
        }
        this.packageMajver = packageMajver;
        this.adjustToMajver();
    }

    public int getPackageMajver() {
        if (this.packageMajver < 0) {
            throw new RuntimeException("Package majver not yet initialized");
        }
        return this.packageMajver;
    }

    protected BandStructure() {
        int i;
        if (this.effort == 0) {
            this.effort = 5;
        }
        this.optDumpBands = this.p200.getBoolean("com.sun.java.util.jar.pack.dump.bands");
        this.optDebugBands = this.p200.getBoolean("com.sun.java.util.jar.pack.debug.bands");
        this.optVaryCodings = !this.p200.getBoolean("com.sun.java.util.jar.pack.no.vary.codings");
        this.optBigStrings = !this.p200.getBoolean("com.sun.java.util.jar.pack.no.big.strings");
        this.packageMajver = -1;
        this.isReader = this instanceof PackageReader;
        this.allKQBands = new ArrayList<CPRefBand>();
        this.needPredefIndex = new ArrayList<Object[]>();
        this.all_bands = (MultiBand)new MultiBand("(package)", UNSIGNED5).init();
        this.archive_magic = this.all_bands.newByteBand("archive_magic");
        this.archive_header_0 = this.all_bands.newIntBand("archive_header_0", UNSIGNED5);
        this.archive_header_S = this.all_bands.newIntBand("archive_header_S", UNSIGNED5);
        this.archive_header_1 = this.all_bands.newIntBand("archive_header_1", UNSIGNED5);
        this.band_headers = this.all_bands.newByteBand("band_headers");
        this.cp_bands = this.all_bands.newMultiBand("(constant_pool)", DELTA5);
        this.cp_Utf8_prefix = this.cp_bands.newIntBand("cp_Utf8_prefix");
        this.cp_Utf8_suffix = this.cp_bands.newIntBand("cp_Utf8_suffix", UNSIGNED5);
        this.cp_Utf8_chars = this.cp_bands.newIntBand("cp_Utf8_chars", CHAR3);
        this.cp_Utf8_big_suffix = this.cp_bands.newIntBand("cp_Utf8_big_suffix");
        this.cp_Utf8_big_chars = this.cp_bands.newMultiBand("(cp_Utf8_big_chars)", DELTA5);
        this.cp_Int = this.cp_bands.newIntBand("cp_Int", UDELTA5);
        this.cp_Float = this.cp_bands.newIntBand("cp_Float", UDELTA5);
        this.cp_Long_hi = this.cp_bands.newIntBand("cp_Long_hi", UDELTA5);
        this.cp_Long_lo = this.cp_bands.newIntBand("cp_Long_lo");
        this.cp_Double_hi = this.cp_bands.newIntBand("cp_Double_hi", UDELTA5);
        this.cp_Double_lo = this.cp_bands.newIntBand("cp_Double_lo");
        this.cp_String = this.cp_bands.newCPRefBand("cp_String", UDELTA5, (byte)1);
        this.cp_Class = this.cp_bands.newCPRefBand("cp_Class", UDELTA5, (byte)1);
        this.cp_Signature_form = this.cp_bands.newCPRefBand("cp_Signature_form", (byte)1);
        this.cp_Signature_classes = this.cp_bands.newCPRefBand("cp_Signature_classes", UDELTA5, (byte)7);
        this.cp_Descr_name = this.cp_bands.newCPRefBand("cp_Descr_name", (byte)1);
        this.cp_Descr_type = this.cp_bands.newCPRefBand("cp_Descr_type", UDELTA5, (byte)13);
        this.cp_Field_class = this.cp_bands.newCPRefBand("cp_Field_class", (byte)7);
        this.cp_Field_desc = this.cp_bands.newCPRefBand("cp_Field_desc", UDELTA5, (byte)12);
        this.cp_Method_class = this.cp_bands.newCPRefBand("cp_Method_class", (byte)7);
        this.cp_Method_desc = this.cp_bands.newCPRefBand("cp_Method_desc", UDELTA5, (byte)12);
        this.cp_Imethod_class = this.cp_bands.newCPRefBand("cp_Imethod_class", (byte)7);
        this.cp_Imethod_desc = this.cp_bands.newCPRefBand("cp_Imethod_desc", UDELTA5, (byte)12);
        this.attr_definition_bands = this.all_bands.newMultiBand("(attr_definition_bands)", UNSIGNED5);
        this.attr_definition_headers = this.attr_definition_bands.newByteBand("attr_definition_headers");
        this.attr_definition_name = this.attr_definition_bands.newCPRefBand("attr_definition_name", (byte)1);
        this.attr_definition_layout = this.attr_definition_bands.newCPRefBand("attr_definition_layout", (byte)1);
        this.ic_bands = this.all_bands.newMultiBand("(ic_bands)", DELTA5);
        this.ic_this_class = this.ic_bands.newCPRefBand("ic_this_class", UDELTA5, (byte)7);
        this.ic_flags = this.ic_bands.newIntBand("ic_flags", UNSIGNED5);
        this.ic_outer_class = this.ic_bands.newCPRefBand("ic_outer_class", DELTA5, (byte)7, true);
        this.ic_name = this.ic_bands.newCPRefBand("ic_name", DELTA5, (byte)1, true);
        this.class_bands = this.all_bands.newMultiBand("(class_bands)", DELTA5);
        this.class_this = this.class_bands.newCPRefBand("class_this", (byte)7);
        this.class_super = this.class_bands.newCPRefBand("class_super", (byte)7);
        this.class_interface_count = this.class_bands.newIntBand("class_interface_count");
        this.class_interface = this.class_bands.newCPRefBand("class_interface", (byte)7);
        this.class_field_count = this.class_bands.newIntBand("class_field_count");
        this.class_method_count = this.class_bands.newIntBand("class_method_count");
        this.field_descr = this.class_bands.newCPRefBand("field_descr", (byte)12);
        this.field_attr_bands = this.class_bands.newMultiBand("(field_attr_bands)", UNSIGNED5);
        this.field_flags_hi = this.field_attr_bands.newIntBand("field_flags_hi");
        this.field_flags_lo = this.field_attr_bands.newIntBand("field_flags_lo");
        this.field_attr_count = this.field_attr_bands.newIntBand("field_attr_count");
        this.field_attr_indexes = this.field_attr_bands.newIntBand("field_attr_indexes");
        this.field_attr_calls = this.field_attr_bands.newIntBand("field_attr_calls");
        this.field_ConstantValue_KQ = this.field_attr_bands.newCPRefBand("field_ConstantValue_KQ", (byte)20);
        this.field_Signature_RS = this.field_attr_bands.newCPRefBand("field_Signature_RS", (byte)13);
        this.field_metadata_bands = this.field_attr_bands.newMultiBand("(field_metadata_bands)", UNSIGNED5);
        this.method_descr = this.class_bands.newCPRefBand("method_descr", MDELTA5, (byte)12);
        this.method_attr_bands = this.class_bands.newMultiBand("(method_attr_bands)", UNSIGNED5);
        this.method_flags_hi = this.method_attr_bands.newIntBand("method_flags_hi");
        this.method_flags_lo = this.method_attr_bands.newIntBand("method_flags_lo");
        this.method_attr_count = this.method_attr_bands.newIntBand("method_attr_count");
        this.method_attr_indexes = this.method_attr_bands.newIntBand("method_attr_indexes");
        this.method_attr_calls = this.method_attr_bands.newIntBand("method_attr_calls");
        this.method_Exceptions_N = this.method_attr_bands.newIntBand("method_Exceptions_N");
        this.method_Exceptions_RC = this.method_attr_bands.newCPRefBand("method_Exceptions_RC", (byte)7);
        this.method_Signature_RS = this.method_attr_bands.newCPRefBand("method_Signature_RS", (byte)13);
        this.method_metadata_bands = this.method_attr_bands.newMultiBand("(method_metadata_bands)", UNSIGNED5);
        this.class_attr_bands = this.class_bands.newMultiBand("(class_attr_bands)", UNSIGNED5);
        this.class_flags_hi = this.class_attr_bands.newIntBand("class_flags_hi");
        this.class_flags_lo = this.class_attr_bands.newIntBand("class_flags_lo");
        this.class_attr_count = this.class_attr_bands.newIntBand("class_attr_count");
        this.class_attr_indexes = this.class_attr_bands.newIntBand("class_attr_indexes");
        this.class_attr_calls = this.class_attr_bands.newIntBand("class_attr_calls");
        this.class_SourceFile_RUN = this.class_attr_bands.newCPRefBand("class_SourceFile_RUN", UNSIGNED5, (byte)1, true);
        this.class_EnclosingMethod_RC = this.class_attr_bands.newCPRefBand("class_EnclosingMethod_RC", (byte)7);
        this.class_EnclosingMethod_RDN = this.class_attr_bands.newCPRefBand("class_EnclosingMethod_RDN", UNSIGNED5, (byte)12, true);
        this.class_Signature_RS = this.class_attr_bands.newCPRefBand("class_Signature_RS", (byte)13);
        this.class_metadata_bands = this.class_attr_bands.newMultiBand("(class_metadata_bands)", UNSIGNED5);
        this.class_InnerClasses_N = this.class_attr_bands.newIntBand("class_InnerClasses_N");
        this.class_InnerClasses_RC = this.class_attr_bands.newCPRefBand("class_InnerClasses_RC", (byte)7);
        this.class_InnerClasses_F = this.class_attr_bands.newIntBand("class_InnerClasses_F");
        this.class_InnerClasses_outer_RCN = this.class_attr_bands.newCPRefBand("class_InnerClasses_outer_RCN", UNSIGNED5, (byte)7, true);
        this.class_InnerClasses_name_RUN = this.class_attr_bands.newCPRefBand("class_InnerClasses_name_RUN", UNSIGNED5, (byte)1, true);
        this.class_ClassFile_version_minor_H = this.class_attr_bands.newIntBand("class_ClassFile_version_minor_H");
        this.class_ClassFile_version_major_H = this.class_attr_bands.newIntBand("class_ClassFile_version_major_H");
        this.code_bands = this.class_bands.newMultiBand("(code_bands)", UNSIGNED5);
        this.code_headers = this.code_bands.newByteBand("code_headers");
        this.code_max_stack = this.code_bands.newIntBand("code_max_stack", UNSIGNED5);
        this.code_max_na_locals = this.code_bands.newIntBand("code_max_na_locals", UNSIGNED5);
        this.code_handler_count = this.code_bands.newIntBand("code_handler_count", UNSIGNED5);
        this.code_handler_start_P = this.code_bands.newIntBand("code_handler_start_P", BCI5);
        this.code_handler_end_PO = this.code_bands.newIntBand("code_handler_end_PO", BRANCH5);
        this.code_handler_catch_PO = this.code_bands.newIntBand("code_handler_catch_PO", BRANCH5);
        this.code_handler_class_RCN = this.code_bands.newCPRefBand("code_handler_class_RCN", UNSIGNED5, (byte)7, true);
        this.code_attr_bands = this.class_bands.newMultiBand("(code_attr_bands)", UNSIGNED5);
        this.code_flags_hi = this.code_attr_bands.newIntBand("code_flags_hi");
        this.code_flags_lo = this.code_attr_bands.newIntBand("code_flags_lo");
        this.code_attr_count = this.code_attr_bands.newIntBand("code_attr_count");
        this.code_attr_indexes = this.code_attr_bands.newIntBand("code_attr_indexes");
        this.code_attr_calls = this.code_attr_bands.newIntBand("code_attr_calls");
        this.stackmap_bands = this.code_attr_bands.newMultiBand("StackMapTable_bands", UNSIGNED5);
        this.code_StackMapTable_N = this.stackmap_bands.newIntBand("code_StackMapTable_N");
        this.code_StackMapTable_frame_T = this.stackmap_bands.newIntBand("code_StackMapTable_frame_T", BYTE1);
        this.code_StackMapTable_local_N = this.stackmap_bands.newIntBand("code_StackMapTable_local_N");
        this.code_StackMapTable_stack_N = this.stackmap_bands.newIntBand("code_StackMapTable_stack_N");
        this.code_StackMapTable_offset = this.stackmap_bands.newIntBand("code_StackMapTable_offset", UNSIGNED5);
        this.code_StackMapTable_T = this.stackmap_bands.newIntBand("code_StackMapTable_T", BYTE1);
        this.code_StackMapTable_RC = this.stackmap_bands.newCPRefBand("code_StackMapTable_RC", (byte)7);
        this.code_StackMapTable_P = this.stackmap_bands.newIntBand("code_StackMapTable_P", BCI5);
        this.code_LineNumberTable_N = this.code_attr_bands.newIntBand("code_LineNumberTable_N");
        this.code_LineNumberTable_bci_P = this.code_attr_bands.newIntBand("code_LineNumberTable_bci_P", BCI5);
        this.code_LineNumberTable_line = this.code_attr_bands.newIntBand("code_LineNumberTable_line");
        this.code_LocalVariableTable_N = this.code_attr_bands.newIntBand("code_LocalVariableTable_N");
        this.code_LocalVariableTable_bci_P = this.code_attr_bands.newIntBand("code_LocalVariableTable_bci_P", BCI5);
        this.code_LocalVariableTable_span_O = this.code_attr_bands.newIntBand("code_LocalVariableTable_span_O", BRANCH5);
        this.code_LocalVariableTable_name_RU = this.code_attr_bands.newCPRefBand("code_LocalVariableTable_name_RU", (byte)1);
        this.code_LocalVariableTable_type_RS = this.code_attr_bands.newCPRefBand("code_LocalVariableTable_type_RS", (byte)13);
        this.code_LocalVariableTable_slot = this.code_attr_bands.newIntBand("code_LocalVariableTable_slot");
        this.code_LocalVariableTypeTable_N = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_N");
        this.code_LocalVariableTypeTable_bci_P = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_bci_P", BCI5);
        this.code_LocalVariableTypeTable_span_O = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_span_O", BRANCH5);
        this.code_LocalVariableTypeTable_name_RU = this.code_attr_bands.newCPRefBand("code_LocalVariableTypeTable_name_RU", (byte)1);
        this.code_LocalVariableTypeTable_type_RS = this.code_attr_bands.newCPRefBand("code_LocalVariableTypeTable_type_RS", (byte)13);
        this.code_LocalVariableTypeTable_slot = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_slot");
        this.bc_bands = this.all_bands.newMultiBand("(byte_codes)", UNSIGNED5);
        this.bc_codes = this.bc_bands.newByteBand("bc_codes");
        this.bc_case_count = this.bc_bands.newIntBand("bc_case_count");
        this.bc_case_value = this.bc_bands.newIntBand("bc_case_value", DELTA5);
        this.bc_byte = this.bc_bands.newByteBand("bc_byte");
        this.bc_short = this.bc_bands.newIntBand("bc_short", DELTA5);
        this.bc_local = this.bc_bands.newIntBand("bc_local");
        this.bc_label = this.bc_bands.newIntBand("bc_label", BRANCH5);
        this.bc_intref = this.bc_bands.newCPRefBand("bc_intref", DELTA5, (byte)3);
        this.bc_floatref = this.bc_bands.newCPRefBand("bc_floatref", DELTA5, (byte)4);
        this.bc_longref = this.bc_bands.newCPRefBand("bc_longref", DELTA5, (byte)5);
        this.bc_doubleref = this.bc_bands.newCPRefBand("bc_doubleref", DELTA5, (byte)6);
        this.bc_stringref = this.bc_bands.newCPRefBand("bc_stringref", DELTA5, (byte)8);
        this.bc_classref = this.bc_bands.newCPRefBand("bc_classref", UNSIGNED5, (byte)7, true);
        this.bc_fieldref = this.bc_bands.newCPRefBand("bc_fieldref", DELTA5, (byte)9);
        this.bc_methodref = this.bc_bands.newCPRefBand("bc_methodref", (byte)10);
        this.bc_imethodref = this.bc_bands.newCPRefBand("bc_imethodref", DELTA5, (byte)11);
        this.bc_thisfield = this.bc_bands.newCPRefBand("bc_thisfield", (byte)0);
        this.bc_superfield = this.bc_bands.newCPRefBand("bc_superfield", (byte)0);
        this.bc_thismethod = this.bc_bands.newCPRefBand("bc_thismethod", (byte)0);
        this.bc_supermethod = this.bc_bands.newCPRefBand("bc_supermethod", (byte)0);
        this.bc_initref = this.bc_bands.newIntBand("bc_initref");
        this.bc_escref = this.bc_bands.newCPRefBand("bc_escref", (byte)19);
        this.bc_escrefsize = this.bc_bands.newIntBand("bc_escrefsize");
        this.bc_escsize = this.bc_bands.newIntBand("bc_escsize");
        this.bc_escbyte = this.bc_bands.newByteBand("bc_escbyte");
        this.file_bands = this.all_bands.newMultiBand("(file_bands)", UNSIGNED5);
        this.file_name = this.file_bands.newCPRefBand("file_name", (byte)1);
        this.file_size_hi = this.file_bands.newIntBand("file_size_hi");
        this.file_size_lo = this.file_bands.newIntBand("file_size_lo");
        this.file_modtime = this.file_bands.newIntBand("file_modtime", DELTA5);
        this.file_options = this.file_bands.newIntBand("file_options");
        this.file_bits = this.file_bands.newByteBand("file_bits");
        this.metadataBands = new MultiBand[4];
        this.metadataBands[0] = this.class_metadata_bands;
        this.metadataBands[1] = this.field_metadata_bands;
        this.metadataBands[2] = this.method_metadata_bands;
        this.attrIndexLimit = new int[4];
        this.attrFlagMask = new long[4];
        this.attrDefSeen = new long[4];
        this.attrOverflowMask = new int[4];
        this.attrBandTable = new HashMap<Attribute.Layout, Band[]>();
        this.attrIndexTable = new HashMap<Attribute.Layout, Integer>();
        this.attrDefs = new FixedList<List<Attribute.Layout>>(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            assert (this.attrIndexLimit[i2] == 0);
            this.attrIndexLimit[i2] = 32;
            this.attrDefs.set(i2, new ArrayList<Attribute.Layout>(Collections.nCopies(this.attrIndexLimit[i2], null)));
        }
        this.attrInnerClassesEmpty = this.predefineAttribute(23, 0, null, "InnerClasses", "");
        assert (this.attrInnerClassesEmpty == Package.attrInnerClassesEmpty);
        this.predefineAttribute(17, 0, new Band[]{this.class_SourceFile_RUN}, "SourceFile", "RUNH");
        this.predefineAttribute(18, 0, new Band[]{this.class_EnclosingMethod_RC, this.class_EnclosingMethod_RDN}, "EnclosingMethod", "RCHRDNH");
        this.attrClassFileVersion = this.predefineAttribute(24, 0, new Band[]{this.class_ClassFile_version_minor_H, this.class_ClassFile_version_major_H}, ".ClassFile.version", "HH");
        this.predefineAttribute(19, 0, new Band[]{this.class_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 0, null, "Deprecated", "");
        this.predefineAttribute(16, 0, null, ".Overflow", "");
        this.attrConstantValue = this.predefineAttribute(17, 1, new Band[]{this.field_ConstantValue_KQ}, "ConstantValue", "KQH");
        this.predefineAttribute(19, 1, new Band[]{this.field_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 1, null, "Deprecated", "");
        this.predefineAttribute(16, 1, null, ".Overflow", "");
        this.attrCodeEmpty = this.predefineAttribute(17, 2, null, "Code", "");
        this.predefineAttribute(18, 2, new Band[]{this.method_Exceptions_N, this.method_Exceptions_RC}, "Exceptions", "NH[RCH]");
        assert (this.attrCodeEmpty == Package.attrCodeEmpty);
        this.predefineAttribute(19, 2, new Band[]{this.method_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 2, null, "Deprecated", "");
        this.predefineAttribute(16, 2, null, ".Overflow", "");
        for (int ctype = 0; ctype < 4; ++ctype) {
            MultiBand xxx_metadata_bands = this.metadataBands[ctype];
            if (xxx_metadata_bands == null) continue;
            this.predefineAttribute(21, Constants.ATTR_CONTEXT_NAME[ctype] + "_RVA_", xxx_metadata_bands, Attribute.lookup(null, ctype, "RuntimeVisibleAnnotations"));
            this.predefineAttribute(22, Constants.ATTR_CONTEXT_NAME[ctype] + "_RIA_", xxx_metadata_bands, Attribute.lookup(null, ctype, "RuntimeInvisibleAnnotations"));
            if (ctype != 2) continue;
            this.predefineAttribute(23, "method_RVPA_", xxx_metadata_bands, Attribute.lookup(null, ctype, "RuntimeVisibleParameterAnnotations"));
            this.predefineAttribute(24, "method_RIPA_", xxx_metadata_bands, Attribute.lookup(null, ctype, "RuntimeInvisibleParameterAnnotations"));
            this.predefineAttribute(25, "method_AD_", xxx_metadata_bands, Attribute.lookup(null, ctype, "AnnotationDefault"));
        }
        Attribute.Layout stackMapDef = Attribute.lookup(null, 3, "StackMapTable").layout();
        this.predefineAttribute(0, 3, this.stackmap_bands.toArray(), stackMapDef.name(), stackMapDef.layout());
        this.predefineAttribute(1, 3, new Band[]{this.code_LineNumberTable_N, this.code_LineNumberTable_bci_P, this.code_LineNumberTable_line}, "LineNumberTable", "NH[PHH]");
        this.predefineAttribute(2, 3, new Band[]{this.code_LocalVariableTable_N, this.code_LocalVariableTable_bci_P, this.code_LocalVariableTable_span_O, this.code_LocalVariableTable_name_RU, this.code_LocalVariableTable_type_RS, this.code_LocalVariableTable_slot}, "LocalVariableTable", "NH[PHOHRUHRSHH]");
        this.predefineAttribute(3, 3, new Band[]{this.code_LocalVariableTypeTable_N, this.code_LocalVariableTypeTable_bci_P, this.code_LocalVariableTypeTable_span_O, this.code_LocalVariableTypeTable_name_RU, this.code_LocalVariableTypeTable_type_RS, this.code_LocalVariableTypeTable_slot}, "LocalVariableTypeTable", "NH[PHOHRUHRSHH]");
        this.predefineAttribute(16, 3, null, ".Overflow", "");
        for (i = 0; i < 4; ++i) {
            this.attrDefSeen[i] = 0L;
        }
        for (i = 0; i < 4; ++i) {
            this.attrOverflowMask[i] = 65536;
            this.attrIndexLimit[i] = 0;
        }
        this.attrClassFileVersionMask = 0x1000000;
        this.attrBands = new MultiBand[4];
        this.attrBands[0] = this.class_attr_bands;
        this.attrBands[1] = this.field_attr_bands;
        this.attrBands[2] = this.method_attr_bands;
        this.attrBands[3] = this.code_attr_bands;
        this.shortCodeHeader_h_limit = shortCodeLimits.length;
    }

    public static Coding codingForIndex(int i) {
        return i < basicCodings.length ? basicCodings[i] : null;
    }

    public static int indexOf(Coding c) {
        Integer i = basicCodingIndexes.get(c);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public static Coding[] getBasicCodings() {
        return (Coding[])basicCodings.clone();
    }

    protected CodingMethod getBandHeader(int XB, Coding regularCoding) {
        CodingMethod[] res = new CodingMethod[]{null};
        this.bandHeaderBytes[--this.bandHeaderBytePos] = (byte)XB;
        this.bandHeaderBytePos0 = this.bandHeaderBytePos;
        this.bandHeaderBytePos = BandStructure.parseMetaCoding(this.bandHeaderBytes, this.bandHeaderBytePos, regularCoding, res);
        return res[0];
    }

    public static int parseMetaCoding(byte[] bytes, int pos, Coding dflt, CodingMethod[] res) {
        if ((bytes[pos] & 0xFF) == 0) {
            res[0] = dflt;
            return pos + 1;
        }
        int pos2 = Coding.parseMetaCoding(bytes, pos, dflt, res);
        if (pos2 > pos) {
            return pos2;
        }
        pos2 = PopulationCoding.parseMetaCoding(bytes, pos, dflt, res);
        if (pos2 > pos) {
            return pos2;
        }
        pos2 = AdaptiveCoding.parseMetaCoding(bytes, pos, dflt, res);
        if (pos2 > pos) {
            return pos2;
        }
        throw new RuntimeException("Bad meta-coding op " + (bytes[pos] & 0xFF));
    }

    static boolean phaseIsRead(int p) {
        return p % 2 == 0;
    }

    static int phaseCmp(int p0, int p1) {
        assert (p0 % 2 == p1 % 2 || p0 % 8 == 0 || p1 % 8 == 0);
        return p0 - p1;
    }

    static int getIntTotal(int[] values) {
        int total = 0;
        for (int i = 0; i < values.length; ++i) {
            total += values[i];
        }
        return total;
    }

    int encodeRef(ConstantPool.Entry e, ConstantPool.Index ix) {
        if (ix == null) {
            throw new RuntimeException("null index for " + e.stringValue());
        }
        int coding = ix.indexOf(e);
        if (this.verbose > 2) {
            Utils.log.fine("putRef " + coding + " => " + e);
        }
        return coding;
    }

    ConstantPool.Entry decodeRef(int n, ConstantPool.Index ix) {
        if (n < 0 || n >= ix.size()) {
            Utils.log.warning("decoding bad ref " + n + " in " + ix);
        }
        ConstantPool.Entry e = ix.getEntry(n);
        if (this.verbose > 2) {
            Utils.log.fine("getRef " + n + " => " + e);
        }
        return e;
    }

    protected CodingChooser getCodingChooser() {
        if (this.codingChooser == null) {
            ArrayList<Package.Class> classes;
            this.codingChooser = new CodingChooser(this.effort, basicCodings);
            if (this.codingChooser.stress != null && this instanceof PackageWriter && !(classes = ((PackageWriter)this).pkg.classes).isEmpty()) {
                Package.Class cls = (Package.Class)classes.get(0);
                this.codingChooser.addStressSeed(cls.getName().hashCode());
            }
        }
        return this.codingChooser;
    }

    public CodingMethod chooseCoding(int[] values, int start, int end, Coding regular, String bandName, int[] sizes) {
        assert (this.optVaryCodings);
        if (this.effort <= 1) {
            return regular;
        }
        CodingChooser cc = this.getCodingChooser();
        if (this.verbose > 1 || cc.verbose > 1) {
            Utils.log.fine("--- chooseCoding " + bandName);
        }
        return cc.choose(values, start, end, regular, sizes);
    }

    protected static int decodeEscapeValue(int X, Coding regularCoding) {
        if (regularCoding.B() == 1 || regularCoding.L() == 0) {
            return -1;
        }
        if (regularCoding.S() != 0) {
            if (-256 <= X && X <= -1 && regularCoding.min() <= -256) {
                int XB = -1 - X;
                assert (XB >= 0 && XB < 256);
                return XB;
            }
        } else {
            int L = regularCoding.L();
            if (L <= X && X <= L + 255 && regularCoding.max() >= L + 255) {
                int XB = X - L;
                assert (XB >= 0 && XB < 256);
                return XB;
            }
        }
        return -1;
    }

    protected static int encodeEscapeValue(int XB, Coding regularCoding) {
        int X;
        assert (XB >= 0 && XB < 256);
        assert (regularCoding.B() > 1 && regularCoding.L() > 0);
        if (regularCoding.S() != 0) {
            assert (regularCoding.min() <= -256);
            X = -1 - XB;
        } else {
            int L = regularCoding.L();
            assert (regularCoding.max() >= L + 255);
            X = XB + L;
        }
        assert (BandStructure.decodeEscapeValue(X, regularCoding) == XB) : regularCoding + " XB=" + XB + " X=" + X;
        return X;
    }

    void writeAllBandsTo(OutputStream out) throws IOException {
        this.outputCounter = new ByteCounter(out);
        out = this.outputCounter;
        this.all_bands.writeTo(out);
        if (this.verbose > 0) {
            long nbytes = this.outputCounter.getCount();
            Utils.log.info("Wrote total of " + nbytes + " bytes.");
            assert (nbytes == this.archiveSize0 + this.archiveSize1);
        }
        this.outputCounter = null;
    }

    static IntBand getAttrBand(MultiBand xxx_attr_bands, int which) {
        IntBand b = (IntBand)xxx_attr_bands.get(which);
        switch (which) {
            case 0: {
                assert (b.name().endsWith("_flags_hi"));
                break;
            }
            case 1: {
                assert (b.name().endsWith("_flags_lo"));
                break;
            }
            case 2: {
                assert (b.name().endsWith("_attr_count"));
                break;
            }
            case 3: {
                assert (b.name().endsWith("_attr_indexes"));
                break;
            }
            case 4: {
                assert (b.name().endsWith("_attr_calls"));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return b;
    }

    protected void setBandIndexes() {
        for (Object[] need : this.needPredefIndex) {
            CPRefBand b = (CPRefBand)need[0];
            Byte which = (Byte)need[1];
            b.setIndex(this.getCPIndex(which));
        }
        this.needPredefIndex = null;
        if (this.verbose > 3) {
            BandStructure.printCDecl(this.all_bands);
        }
    }

    protected void setBandIndex(CPRefBand b, byte which) {
        Object[] need = new Object[]{b, which};
        if (which == 20) {
            this.allKQBands.add(b);
        } else if (this.needPredefIndex != null) {
            this.needPredefIndex.add(need);
        } else {
            b.setIndex(this.getCPIndex(which));
        }
    }

    protected void setConstantValueIndex(Package.Class.Field f) {
        ConstantPool.Index ix = null;
        if (f != null) {
            byte tag = f.getLiteralTag();
            ix = this.getCPIndex(tag);
            if (this.verbose > 2) {
                Utils.log.fine("setConstantValueIndex " + f + " " + ConstantPool.tagName(tag) + " => " + ix);
            }
            assert (ix != null);
        }
        for (CPRefBand xxx_KQ : this.allKQBands) {
            xxx_KQ.setIndex(ix);
        }
    }

    private void adjustToMajver() {
        if (this.getPackageMajver() < 160) {
            if (this.verbose > 0) {
                Utils.log.fine("Legacy package version");
            }
            this.undefineAttribute(0, 3);
        }
    }

    protected void initAttrIndexLimit() {
        for (int i = 0; i < 4; ++i) {
            assert (this.attrIndexLimit[i] == 0);
            this.attrIndexLimit[i] = this.haveFlagsHi(i) ? 63 : 32;
            List<Attribute.Layout> defList = this.attrDefs.get(i);
            assert (defList.size() == 32);
            int addMore = this.attrIndexLimit[i] - defList.size();
            defList.addAll(Collections.nCopies(addMore, null));
        }
    }

    protected boolean haveFlagsHi(int ctype) {
        int mask = 1 << 9 + ctype;
        switch (ctype) {
            case 0: {
                assert (mask == 512);
                break;
            }
            case 1: {
                assert (mask == 1024);
                break;
            }
            case 2: {
                assert (mask == 2048);
                break;
            }
            case 3: {
                assert (mask == 4096);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return BandStructure.testBit(this.archiveOptions, mask);
    }

    protected List<Attribute.Layout> getPredefinedAttrs(int ctype) {
        assert (this.attrIndexLimit[ctype] != 0);
        ArrayList<Attribute.Layout> res = new ArrayList<Attribute.Layout>(this.attrIndexLimit[ctype]);
        for (int ai = 0; ai < this.attrIndexLimit[ctype]; ++ai) {
            Attribute.Layout def;
            if (BandStructure.testBit(this.attrDefSeen[ctype], 1L << ai) || (def = this.attrDefs.get(ctype).get(ai)) == null) continue;
            assert (this.isPredefinedAttr(ctype, ai));
            res.add(def);
        }
        return res;
    }

    protected boolean isPredefinedAttr(int ctype, int ai) {
        assert (this.attrIndexLimit[ctype] != 0);
        if (ai >= this.attrIndexLimit[ctype]) {
            return false;
        }
        if (BandStructure.testBit(this.attrDefSeen[ctype], 1L << ai)) {
            return false;
        }
        return this.attrDefs.get(ctype).get(ai) != null;
    }

    protected void adjustSpecialAttrMasks() {
        this.attrClassFileVersionMask = (int)((long)this.attrClassFileVersionMask & (this.attrDefSeen[0] ^ 0xFFFFFFFFFFFFFFFFL));
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.attrOverflowMask[n] = (int)((long)this.attrOverflowMask[n] & (this.attrDefSeen[i] ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    protected Attribute makeClassFileVersionAttr(int minver, int majver) {
        byte[] bytes = new byte[]{(byte)(minver >> 8), (byte)minver, (byte)(majver >> 8), (byte)majver};
        return this.attrClassFileVersion.addContent(bytes);
    }

    protected short[] parseClassFileVersionAttr(Attribute attr) {
        assert (attr.layout() == this.attrClassFileVersion);
        assert (attr.size() == 4);
        byte[] bytes = attr.bytes();
        int minver = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
        int majver = (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        return new short[]{(short)minver, (short)majver};
    }

    private boolean assertBandOKForElems(Band[] ab, Attribute.Layout.Element[] elems) {
        for (int i = 0; i < elems.length; ++i) {
            assert (this.assertBandOKForElem(ab, elems[i]));
        }
        return true;
    }

    private boolean assertBandOKForElem(Band[] ab, Attribute.Layout.Element e) {
        Band b = null;
        if (e.bandIndex != -1) {
            b = ab[e.bandIndex];
        }
        Coding rc = UNSIGNED5;
        boolean wantIntBand = true;
        switch (e.kind) {
            case 1: {
                if (e.flagTest((byte)1)) {
                    rc = SIGNED5;
                    break;
                }
                if (e.len != 1) break;
                rc = BYTE1;
                break;
            }
            case 2: {
                if (!e.flagTest((byte)2)) {
                    rc = BCI5;
                    break;
                }
                rc = BRANCH5;
                break;
            }
            case 3: {
                rc = BRANCH5;
                break;
            }
            case 4: {
                if (e.len != 1) break;
                rc = BYTE1;
                break;
            }
            case 5: {
                if (e.len == 1) {
                    rc = BYTE1;
                }
                this.assertBandOKForElems(ab, e.body);
                break;
            }
            case 7: {
                if (e.flagTest((byte)1)) {
                    rc = SIGNED5;
                } else if (e.len == 1) {
                    rc = BYTE1;
                }
                this.assertBandOKForElems(ab, e.body);
                break;
            }
            case 8: {
                assert (b == null);
                this.assertBandOKForElems(ab, e.body);
                return true;
            }
            case 9: {
                assert (b == null);
                return true;
            }
            case 10: {
                assert (b == null);
                this.assertBandOKForElems(ab, e.body);
                return true;
            }
            case 6: {
                wantIntBand = false;
                assert (b instanceof CPRefBand);
                assert (((CPRefBand)b).nullOK == e.flagTest((byte)4));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (b.regularCoding == rc) : e + " // " + b;
        if (wantIntBand) assert (b instanceof IntBand);
        return true;
    }

    private Attribute.Layout predefineAttribute(int index, int ctype, Band[] ab, String name, String layout) {
        Attribute.Layout def = Attribute.find(ctype, name, layout).layout();
        if (index >= 0) {
            this.setAttributeLayoutIndex(def, index);
        }
        if (ab == null) {
            ab = new Band[]{};
        }
        assert (this.attrBandTable.get(def) == null);
        this.attrBandTable.put(def, ab);
        assert (def.bandCount == ab.length) : def + " // " + Arrays.asList(ab);
        assert (this.assertBandOKForElems(ab, def.elems));
        return def;
    }

    private Attribute.Layout predefineAttribute(int index, String bandPrefix, MultiBand addHere, Attribute attr) {
        Attribute.Layout def = attr.layout();
        int ctype = def.ctype();
        return this.predefineAttribute(index, ctype, this.makeNewAttributeBands(bandPrefix, def, addHere), def.name(), def.layout());
    }

    private void undefineAttribute(int index, int ctype) {
        if (this.verbose > 1) {
            System.out.println("Removing predefined " + Constants.ATTR_CONTEXT_NAME[ctype] + " attribute on bit " + index);
        }
        List<Attribute.Layout> defList = this.attrDefs.get(ctype);
        Attribute.Layout def = defList.get(index);
        assert (def != null);
        defList.set(index, null);
        this.attrIndexTable.put(def, null);
        assert (index < 64);
        int n = ctype;
        this.attrDefSeen[n] = this.attrDefSeen[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = ctype;
        this.attrFlagMask[n2] = this.attrFlagMask[n2] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        Band[] ab = this.attrBandTable.get(def);
        for (int j = 0; j < ab.length; ++j) {
            ab[j].doneWithUnusedBand();
        }
    }

    void makeNewAttributeBands() {
        this.adjustSpecialAttrMasks();
        for (int ctype = 0; ctype < 4; ++ctype) {
            String cname = Constants.ATTR_CONTEXT_NAME[ctype];
            MultiBand xxx_attr_bands = this.attrBands[ctype];
            long defSeen = this.attrDefSeen[ctype];
            assert ((defSeen & (this.attrFlagMask[ctype] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L);
            for (int i = 0; i < this.attrDefs.get(ctype).size(); ++i) {
                Attribute.Layout def = this.attrDefs.get(ctype).get(i);
                if (def == null || def.bandCount == 0) continue;
                if (i < this.attrIndexLimit[ctype] && !BandStructure.testBit(defSeen, 1L << i)) {
                    assert (this.attrBandTable.get(def) != null);
                    continue;
                }
                int base = xxx_attr_bands.size();
                String pfx = cname + "_" + def.name() + "_";
                if (this.verbose > 1) {
                    Utils.log.fine("Making new bands for " + def);
                }
                Band[] newAB = this.makeNewAttributeBands(pfx, def, xxx_attr_bands);
                assert (newAB.length == def.bandCount);
                Band[] prevAB = this.attrBandTable.put(def, newAB);
                if (prevAB == null) continue;
                for (int j = 0; j < prevAB.length; ++j) {
                    prevAB[j].doneWithUnusedBand();
                }
            }
        }
    }

    private Band[] makeNewAttributeBands(String pfx, Attribute.Layout def, MultiBand addHere) {
        int base = addHere.size();
        this.makeNewAttributeBands(pfx, def.elems, addHere);
        int nb = addHere.size() - base;
        Band[] newAB = new Band[nb];
        for (int i = 0; i < nb; ++i) {
            newAB[i] = addHere.get(base + i);
        }
        return newAB;
    }

    private void makeNewAttributeBands(String pfx, Attribute.Layout.Element[] elems, MultiBand ab) {
        block12: for (int i = 0; i < elems.length; ++i) {
            Band nb;
            Attribute.Layout.Element e = elems[i];
            String name = pfx + ab.size() + "_" + e.layout;
            int tem = name.indexOf(91);
            if (tem > 0) {
                name = name.substring(0, tem);
            }
            if ((tem = name.indexOf(40)) > 0) {
                name = name.substring(0, tem);
            }
            if (name.endsWith("H")) {
                name = name.substring(0, name.length() - 1);
            }
            switch (e.kind) {
                case 1: {
                    nb = this.newElemBand(e, name, ab);
                    break;
                }
                case 2: {
                    if (!e.flagTest((byte)2)) {
                        nb = ab.newIntBand(name, BCI5);
                        break;
                    }
                    nb = ab.newIntBand(name, BRANCH5);
                    break;
                }
                case 3: {
                    nb = ab.newIntBand(name, BRANCH5);
                    break;
                }
                case 4: {
                    assert (!e.flagTest((byte)1));
                    nb = this.newElemBand(e, name, ab);
                    break;
                }
                case 5: {
                    assert (!e.flagTest((byte)1));
                    nb = this.newElemBand(e, name, ab);
                    this.makeNewAttributeBands(pfx, e.body, ab);
                    break;
                }
                case 7: {
                    nb = this.newElemBand(e, name, ab);
                    this.makeNewAttributeBands(pfx, e.body, ab);
                    break;
                }
                case 8: {
                    if (e.flagTest((byte)8)) continue block12;
                    this.makeNewAttributeBands(pfx, e.body, ab);
                    continue block12;
                }
                case 6: {
                    byte refKind = e.refKind;
                    boolean nullOK = e.flagTest((byte)4);
                    nb = ab.newCPRefBand(name, UNSIGNED5, refKind, nullOK);
                    break;
                }
                case 9: {
                    continue block12;
                }
                case 10: {
                    this.makeNewAttributeBands(pfx, e.body, ab);
                    continue block12;
                }
                default: {
                    assert (false);
                    continue block12;
                }
            }
            if (this.verbose <= 1) continue;
            Utils.log.fine("New attribute band " + nb);
        }
    }

    private Band newElemBand(Attribute.Layout.Element e, String name, MultiBand ab) {
        if (e.flagTest((byte)1)) {
            return ab.newIntBand(name, SIGNED5);
        }
        if (e.len == 1) {
            return ab.newIntBand(name, BYTE1);
        }
        return ab.newIntBand(name, UNSIGNED5);
    }

    protected int setAttributeLayoutIndex(Attribute.Layout def, int index) {
        int ctype = def.ctype;
        assert (-1 <= index && index < this.attrIndexLimit[ctype]);
        List<Attribute.Layout> defList = this.attrDefs.get(ctype);
        if (index == -1) {
            index = defList.size();
            defList.add(def);
            if (this.verbose > 0) {
                Utils.log.info("Adding new attribute at " + def + ": " + index);
            }
            this.attrIndexTable.put(def, index);
            return index;
        }
        if (BandStructure.testBit(this.attrDefSeen[ctype], 1L << index)) {
            throw new RuntimeException("Multiple explicit definition at " + index + ": " + def);
        }
        int n = ctype;
        this.attrDefSeen[n] = this.attrDefSeen[n] | 1L << index;
        assert (0 <= index && index < this.attrIndexLimit[ctype]);
        if (this.verbose > (this.attrClassFileVersionMask == 0 ? 2 : 0)) {
            Utils.log.fine("Fixing new attribute at " + index + ": " + def + (defList.get(index) == null ? "" : "; replacing " + defList.get(index)));
        }
        int n2 = ctype;
        this.attrFlagMask[n2] = this.attrFlagMask[n2] | 1L << index;
        this.attrIndexTable.put(defList.get(index), null);
        defList.set(index, def);
        this.attrIndexTable.put(def, index);
        return index;
    }

    static int shortCodeHeader(Code code) {
        int s = code.max_stack;
        int l0 = code.max_locals;
        int h = code.handler_class.length;
        if (h >= shortCodeLimits.length) {
            return 0;
        }
        int siglen = code.getMethod().getArgumentSize();
        assert (l0 >= siglen);
        if (l0 < siglen) {
            return 0;
        }
        int l1 = l0 - siglen;
        int lims = shortCodeLimits[h][0];
        int liml = shortCodeLimits[h][1];
        if (s >= lims || l1 >= liml) {
            return 0;
        }
        int sc = BandStructure.shortCodeHeader_h_base(h);
        if ((sc += s + lims * l1) > 255) {
            return 0;
        }
        assert (BandStructure.shortCodeHeader_max_stack(sc) == s);
        assert (BandStructure.shortCodeHeader_max_na_locals(sc) == l1);
        assert (BandStructure.shortCodeHeader_handler_count(sc) == h);
        return sc;
    }

    static int shortCodeHeader_handler_count(int sc) {
        assert (sc > 0 && sc <= 255);
        int h = 0;
        while (sc >= BandStructure.shortCodeHeader_h_base(h + 1)) {
            ++h;
        }
        return h;
    }

    static int shortCodeHeader_max_stack(int sc) {
        int h = BandStructure.shortCodeHeader_handler_count(sc);
        int lims = shortCodeLimits[h][0];
        return (sc - BandStructure.shortCodeHeader_h_base(h)) % lims;
    }

    static int shortCodeHeader_max_na_locals(int sc) {
        int h = BandStructure.shortCodeHeader_handler_count(sc);
        int lims = shortCodeLimits[h][0];
        return (sc - BandStructure.shortCodeHeader_h_base(h)) / lims;
    }

    private static int shortCodeHeader_h_base(int h) {
        assert (h <= shortCodeLimits.length);
        int sc = 1;
        for (int h0 = 0; h0 < h; ++h0) {
            int lims = shortCodeLimits[h0][0];
            int liml = shortCodeLimits[h0][1];
            sc += lims * liml;
        }
        return sc;
    }

    protected void putLabel(IntBand bc_label, Code c, int pc, int targetPC) {
        bc_label.putInt(c.encodeBCI(targetPC) - c.encodeBCI(pc));
    }

    protected int getLabel(IntBand bc_label, Code c, int pc) {
        return c.decodeBCI(bc_label.getInt() + c.encodeBCI(pc));
    }

    protected CPRefBand getCPRefOpBand(int bc) {
        switch (Instruction.getCPRefOpTag(bc)) {
            case 7: {
                return this.bc_classref;
            }
            case 9: {
                return this.bc_fieldref;
            }
            case 10: {
                return this.bc_methodref;
            }
            case 11: {
                return this.bc_imethodref;
            }
            case 20: {
                switch (bc) {
                    case 234: 
                    case 237: {
                        return this.bc_intref;
                    }
                    case 235: 
                    case 238: {
                        return this.bc_floatref;
                    }
                    case 20: {
                        return this.bc_longref;
                    }
                    case 239: {
                        return this.bc_doubleref;
                    }
                    case 18: 
                    case 19: {
                        return this.bc_stringref;
                    }
                    case 233: 
                    case 236: {
                        return this.bc_classref;
                    }
                }
            }
        }
        assert (false);
        return null;
    }

    protected CPRefBand selfOpRefBand(int self_bc) {
        boolean isAload;
        boolean isSuper;
        assert (Instruction.isSelfLinkerOp(self_bc));
        int idx = self_bc - 202;
        boolean bl = isSuper = idx >= 14;
        if (isSuper) {
            idx -= 14;
        }
        boolean bl2 = isAload = idx >= 7;
        if (isAload) {
            idx -= 7;
        }
        int origBC = 178 + idx;
        boolean isField = Instruction.isFieldOp(origBC);
        if (!isSuper) {
            return isField ? this.bc_thisfield : this.bc_thismethod;
        }
        return isField ? this.bc_superfield : this.bc_supermethod;
    }

    static OutputStream getDumpStream(Band b, String ext) throws IOException {
        return BandStructure.getDumpStream(b.name, b.seqForDebug, ext, b);
    }

    static OutputStream getDumpStream(ConstantPool.Index ix, String ext) throws IOException {
        if (ix.size() == 0) {
            return new ByteArrayOutputStream();
        }
        byte seq = ConstantPool.TAG_ORDER[ix.cpMap[0].tag];
        return BandStructure.getDumpStream(ix.debugName, seq, ext, ix);
    }

    static OutputStream getDumpStream(String name, int seq, String ext, Object b) throws IOException {
        if (dumpDir == null) {
            dumpDir = File.createTempFile("BD_", "", new File("."));
            dumpDir.delete();
            if (dumpDir.mkdir()) {
                Utils.log.info("Dumping bands to " + dumpDir);
            }
        }
        name = name.replace('(', ' ').replace(')', ' ');
        name = name.replace('/', ' ');
        name = name.replace('*', ' ');
        name = name.trim().replace(' ', '_');
        name = (10000 + seq + "_" + name).substring(1);
        File dumpFile = new File(dumpDir, name + ext);
        Utils.log.info("Dumping " + b + " to " + dumpFile);
        return new BufferedOutputStream(new FileOutputStream(dumpFile));
    }

    static boolean assertCanChangeLength(Band b) {
        switch (b.phase) {
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    static boolean assertPhase(Band b, int phaseExpected) {
        if (b.phase() != phaseExpected) {
            Utils.log.warning("phase expected " + phaseExpected + " was " + b.phase() + " in " + b);
            return false;
        }
        return true;
    }

    static int verbose() {
        return Utils.currentPropMap().getInteger("com.sun.java.util.jar.pack.verbose");
    }

    static boolean assertPhaseChangeOK(Band b, int p0, int p1) {
        switch (p0 * 10 + p1) {
            case 1: {
                assert (!b.isReader());
                assert (b.capacity() >= 0);
                assert (b.length() == 0);
                return true;
            }
            case 13: 
            case 33: {
                assert (b.length() == 0);
                return true;
            }
            case 15: 
            case 35: {
                return true;
            }
            case 58: {
                return true;
            }
            case 2: {
                assert (b.isReader());
                assert (b.capacity() < 0);
                return true;
            }
            case 24: {
                assert (Math.max(0, b.capacity()) >= b.valuesExpected());
                assert (b.length() <= 0);
                return true;
            }
            case 46: {
                assert (b.valuesRemainingForDebug() == b.length());
                return true;
            }
            case 68: {
                assert (BandStructure.assertDoneDisbursing(b));
                return true;
            }
        }
        if (p0 == p1) {
            Utils.log.warning("Already in phase " + p0);
        } else {
            Utils.log.warning("Unexpected phase " + p0 + " -> " + p1);
        }
        return false;
    }

    private static boolean assertDoneDisbursing(Band b) {
        int left;
        if (b.phase != 6) {
            Utils.log.warning("assertDoneDisbursing: still in phase " + b.phase + ": " + b);
            if (BandStructure.verbose() <= 1) {
                return false;
            }
        }
        if ((left = b.valuesRemainingForDebug()) > 0) {
            Utils.log.warning("assertDoneDisbursing: " + left + " values left in " + b);
            if (BandStructure.verbose() <= 1) {
                return false;
            }
        }
        if (b instanceof MultiBand) {
            MultiBand mb = (MultiBand)b;
            for (int i = 0; i < mb.bandCount; ++i) {
                Band sub = mb.bands[i];
                if (sub.phase == 8) continue;
                Utils.log.warning("assertDoneDisbursing: sub-band still in phase " + sub.phase + ": " + sub);
                if (BandStructure.verbose() > 1) continue;
                return false;
            }
        }
        return true;
    }

    private static void printCDecl(Band b) {
        ConstantPool.Index ix;
        if (b instanceof MultiBand) {
            MultiBand mb = (MultiBand)b;
            for (int i = 0; i < mb.bandCount; ++i) {
                BandStructure.printCDecl(mb.bands[i]);
            }
            return;
        }
        String ixS = "NULL";
        if (b instanceof CPRefBand && (ix = ((CPRefBand)b).index) != null) {
            ixS = "INDEX(" + ix.debugName + ")";
        }
        Coding[] knownc = new Coding[]{BYTE1, CHAR3, BCI5, BRANCH5, UNSIGNED5, UDELTA5, SIGNED5, DELTA5, MDELTA5};
        String[] knowns = new String[]{"BYTE1", "CHAR3", "BCI5", "BRANCH5", "UNSIGNED5", "UDELTA5", "SIGNED5", "DELTA5", "MDELTA5"};
        Coding rc = b.regularCoding;
        int rci = Arrays.asList(knownc).indexOf(rc);
        String cstr = rci >= 0 ? knowns[rci] : "CODING" + rc.keyString();
        System.out.println("  BAND_INIT(\"" + b.name() + "\"" + ", " + cstr + ", " + ixS + "),");
    }

    boolean notePrevForAssert(Band b, Band p) {
        if (this.prevForAssertMap == null) {
            this.prevForAssertMap = new HashMap<Band, Band>();
        }
        this.prevForAssertMap.put(b, p);
        return true;
    }

    private boolean assertReadyToReadFrom(Band b, InputStream in) throws IOException {
        Band p = this.prevForAssertMap.get(b);
        if (p != null && BandStructure.phaseCmp(p.phase(), 6) < 0) {
            Utils.log.warning("Previous band not done reading.");
            Utils.log.info("    Previous band: " + p);
            Utils.log.info("        Next band: " + b);
            Thread.dumpStack();
            assert (this.verbose > 0);
        }
        String name = b.name;
        if (this.optDebugBands && !name.startsWith("(")) {
            int ch;
            StringBuilder buf = new StringBuilder();
            while ((ch = in.read()) > 0) {
                buf.append((char)ch);
            }
            String inName = buf.toString();
            if (!inName.equals(name)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Expected " + name + " but read: ");
                inName = inName + (char)ch;
                while (inName.length() < 10) {
                    inName = inName + (char)in.read();
                }
                for (int i = 0; i < inName.length(); ++i) {
                    sb.append(inName.charAt(i));
                }
                Utils.log.warning(sb.toString());
                return false;
            }
        }
        return true;
    }

    private boolean assertValidCPRefs(CPRefBand b) {
        if (b.index == null) {
            return true;
        }
        int limit = b.index.size() + 1;
        for (int i = 0; i < b.length(); ++i) {
            int v = b.valueAtForDebug(i);
            if (v >= 0 && v < limit) continue;
            Utils.log.warning("CP ref out of range [" + i + "] = " + v + " in " + b);
            return false;
        }
        return true;
    }

    private boolean assertReadyToWriteTo(Band b, OutputStream out) throws IOException {
        Band p = this.prevForAssertMap.get(b);
        if (p != null && BandStructure.phaseCmp(p.phase(), 8) < 0) {
            Utils.log.warning("Previous band not done writing.");
            Utils.log.info("    Previous band: " + p);
            Utils.log.info("        Next band: " + b);
            Thread.dumpStack();
            assert (this.verbose > 0);
        }
        String name = b.name;
        if (this.optDebugBands && !name.startsWith("(")) {
            for (int j = 0; j < name.length(); ++j) {
                out.write((byte)name.charAt(j));
            }
            out.write(0);
        }
        return true;
    }

    protected static boolean testBit(int flags, int bitMask) {
        return (flags & bitMask) != 0;
    }

    protected static int setBit(int flags, int bitMask, boolean z) {
        return z ? flags | bitMask : flags & ~bitMask;
    }

    protected static boolean testBit(long flags, long bitMask) {
        return (flags & bitMask) != 0L;
    }

    protected static long setBit(long flags, long bitMask, boolean z) {
        return z ? flags | bitMask : flags & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static void printArrayTo(PrintStream ps, int[] values, int start, int end) {
        int len = end - start;
        for (int i = 0; i < len; ++i) {
            if (i % 10 == 0) {
                ps.println();
            } else {
                ps.print(" ");
            }
            ps.print(values[start + i]);
        }
        ps.println();
    }

    static void printArrayTo(PrintStream ps, ConstantPool.Entry[] cpMap, int start, int end) {
        StringBuffer buf = new StringBuffer();
        int len = end - start;
        for (int i = 0; i < len; ++i) {
            String s = cpMap[start + i].stringValue();
            buf.setLength(0);
            for (int j = 0; j < s.length(); ++j) {
                char ch = s.charAt(j);
                if (ch >= ' ' && ch <= '~' && ch != '\\') {
                    buf.append(ch);
                    continue;
                }
                if (ch == '\n') {
                    buf.append("\\n");
                    continue;
                }
                if (ch == '\t') {
                    buf.append("\\t");
                    continue;
                }
                if (ch == '\r') {
                    buf.append("\\r");
                    continue;
                }
                buf.append("\\x" + Integer.toHexString(ch));
            }
            ps.println(buf);
        }
    }

    protected static Object[] realloc(Object[] a, int len) {
        Class<?> elt = a.getClass().getComponentType();
        Object[] na = (Object[])Array.newInstance(elt, len);
        System.arraycopy(a, 0, na, 0, Math.min(a.length, len));
        return na;
    }

    protected static Object[] realloc(Object[] a) {
        return BandStructure.realloc(a, Math.max(10, a.length * 2));
    }

    protected static int[] realloc(int[] a, int len) {
        if (len == 0) {
            return Constants.noInts;
        }
        if (a == null) {
            return new int[len];
        }
        int[] na = new int[len];
        System.arraycopy(a, 0, na, 0, Math.min(a.length, len));
        return na;
    }

    protected static int[] realloc(int[] a) {
        return BandStructure.realloc(a, Math.max(10, a.length * 2));
    }

    protected static byte[] realloc(byte[] a, int len) {
        if (len == 0) {
            return Constants.noBytes;
        }
        if (a == null) {
            return new byte[len];
        }
        byte[] na = new byte[len];
        System.arraycopy(a, 0, na, 0, Math.min(a.length, len));
        return na;
    }

    protected static byte[] realloc(byte[] a) {
        return BandStructure.realloc(a, Math.max(10, a.length * 2));
    }

    static {
        int i;
        BYTE1 = Coding.of(1, 256);
        CHAR3 = Coding.of(3, 128);
        BCI5 = Coding.of(5, 4);
        BRANCH5 = Coding.of(5, 4, 2);
        UNSIGNED5 = Coding.of(5, 64);
        UDELTA5 = UNSIGNED5.getDeltaCoding();
        SIGNED5 = Coding.of(5, 64, 1);
        DELTA5 = SIGNED5.getDeltaCoding();
        MDELTA5 = Coding.of(5, 64, 2).getDeltaCoding();
        basicCodings = new Coding[]{null, Coding.of(1, 256, 0), Coding.of(1, 256, 1), Coding.of(1, 256, 0).getDeltaCoding(), Coding.of(1, 256, 1).getDeltaCoding(), Coding.of(2, 256, 0), Coding.of(2, 256, 1), Coding.of(2, 256, 0).getDeltaCoding(), Coding.of(2, 256, 1).getDeltaCoding(), Coding.of(3, 256, 0), Coding.of(3, 256, 1), Coding.of(3, 256, 0).getDeltaCoding(), Coding.of(3, 256, 1).getDeltaCoding(), Coding.of(4, 256, 0), Coding.of(4, 256, 1), Coding.of(4, 256, 0).getDeltaCoding(), Coding.of(4, 256, 1).getDeltaCoding(), Coding.of(5, 4, 0), Coding.of(5, 4, 1), Coding.of(5, 4, 2), Coding.of(5, 16, 0), Coding.of(5, 16, 1), Coding.of(5, 16, 2), Coding.of(5, 32, 0), Coding.of(5, 32, 1), Coding.of(5, 32, 2), Coding.of(5, 64, 0), Coding.of(5, 64, 1), Coding.of(5, 64, 2), Coding.of(5, 128, 0), Coding.of(5, 128, 1), Coding.of(5, 128, 2), Coding.of(5, 4, 0).getDeltaCoding(), Coding.of(5, 4, 1).getDeltaCoding(), Coding.of(5, 4, 2).getDeltaCoding(), Coding.of(5, 16, 0).getDeltaCoding(), Coding.of(5, 16, 1).getDeltaCoding(), Coding.of(5, 16, 2).getDeltaCoding(), Coding.of(5, 32, 0).getDeltaCoding(), Coding.of(5, 32, 1).getDeltaCoding(), Coding.of(5, 32, 2).getDeltaCoding(), Coding.of(5, 64, 0).getDeltaCoding(), Coding.of(5, 64, 1).getDeltaCoding(), Coding.of(5, 64, 2).getDeltaCoding(), Coding.of(5, 128, 0).getDeltaCoding(), Coding.of(5, 128, 1).getDeltaCoding(), Coding.of(5, 128, 2).getDeltaCoding(), Coding.of(2, 192, 0), Coding.of(2, 224, 0), Coding.of(2, 240, 0), Coding.of(2, 248, 0), Coding.of(2, 252, 0), Coding.of(2, 8, 0).getDeltaCoding(), Coding.of(2, 8, 1).getDeltaCoding(), Coding.of(2, 16, 0).getDeltaCoding(), Coding.of(2, 16, 1).getDeltaCoding(), Coding.of(2, 32, 0).getDeltaCoding(), Coding.of(2, 32, 1).getDeltaCoding(), Coding.of(2, 64, 0).getDeltaCoding(), Coding.of(2, 64, 1).getDeltaCoding(), Coding.of(2, 128, 0).getDeltaCoding(), Coding.of(2, 128, 1).getDeltaCoding(), Coding.of(2, 192, 0).getDeltaCoding(), Coding.of(2, 192, 1).getDeltaCoding(), Coding.of(2, 224, 0).getDeltaCoding(), Coding.of(2, 224, 1).getDeltaCoding(), Coding.of(2, 240, 0).getDeltaCoding(), Coding.of(2, 240, 1).getDeltaCoding(), Coding.of(2, 248, 0).getDeltaCoding(), Coding.of(2, 248, 1).getDeltaCoding(), Coding.of(3, 192, 0), Coding.of(3, 224, 0), Coding.of(3, 240, 0), Coding.of(3, 248, 0), Coding.of(3, 252, 0), Coding.of(3, 8, 0).getDeltaCoding(), Coding.of(3, 8, 1).getDeltaCoding(), Coding.of(3, 16, 0).getDeltaCoding(), Coding.of(3, 16, 1).getDeltaCoding(), Coding.of(3, 32, 0).getDeltaCoding(), Coding.of(3, 32, 1).getDeltaCoding(), Coding.of(3, 64, 0).getDeltaCoding(), Coding.of(3, 64, 1).getDeltaCoding(), Coding.of(3, 128, 0).getDeltaCoding(), Coding.of(3, 128, 1).getDeltaCoding(), Coding.of(3, 192, 0).getDeltaCoding(), Coding.of(3, 192, 1).getDeltaCoding(), Coding.of(3, 224, 0).getDeltaCoding(), Coding.of(3, 224, 1).getDeltaCoding(), Coding.of(3, 240, 0).getDeltaCoding(), Coding.of(3, 240, 1).getDeltaCoding(), Coding.of(3, 248, 0).getDeltaCoding(), Coding.of(3, 248, 1).getDeltaCoding(), Coding.of(4, 192, 0), Coding.of(4, 224, 0), Coding.of(4, 240, 0), Coding.of(4, 248, 0), Coding.of(4, 252, 0), Coding.of(4, 8, 0).getDeltaCoding(), Coding.of(4, 8, 1).getDeltaCoding(), Coding.of(4, 16, 0).getDeltaCoding(), Coding.of(4, 16, 1).getDeltaCoding(), Coding.of(4, 32, 0).getDeltaCoding(), Coding.of(4, 32, 1).getDeltaCoding(), Coding.of(4, 64, 0).getDeltaCoding(), Coding.of(4, 64, 1).getDeltaCoding(), Coding.of(4, 128, 0).getDeltaCoding(), Coding.of(4, 128, 1).getDeltaCoding(), Coding.of(4, 192, 0).getDeltaCoding(), Coding.of(4, 192, 1).getDeltaCoding(), Coding.of(4, 224, 0).getDeltaCoding(), Coding.of(4, 224, 1).getDeltaCoding(), Coding.of(4, 240, 0).getDeltaCoding(), Coding.of(4, 240, 1).getDeltaCoding(), Coding.of(4, 248, 0).getDeltaCoding(), Coding.of(4, 248, 1).getDeltaCoding(), null};
        assert (basicCodings[0] == null);
        assert (basicCodings[1] != null);
        assert (basicCodings[115] != null);
        HashMap<Coding, Integer> map = new HashMap<Coding, Integer>();
        for (i = 0; i < basicCodings.length; ++i) {
            Coding c = basicCodings[i];
            if (c == null) continue;
            assert (i >= 1);
            assert (i <= 115);
            map.put(c, i);
        }
        basicCodingIndexes = map;
        defaultMetaCoding = new byte[]{0};
        noMetaCoding = new byte[0];
        boolean checkXB = false;
        if (!$assertionsDisabled) {
            checkXB = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkXB) {
            for (i = 0; i < basicCodings.length; ++i) {
                Coding D = basicCodings[i];
                if (D == null || D.B() == 1 || D.L() == 0) continue;
                for (int XB = 0; XB <= 255; ++XB) {
                    BandStructure.encodeEscapeValue(XB, D);
                }
            }
        }
        shortCodeLimits = new int[][]{{12, 12}, {8, 8}, {7, 7}};
        dumpDir = null;
    }

    private static class ByteCounter
    extends FilterOutputStream {
        private long count;

        public ByteCounter(OutputStream out) {
            super(out);
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long c) {
            this.count = c;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.count += (long)len;
            if (this.out != null) {
                this.out.write(b, off, len);
            }
        }

        public String toString() {
            return String.valueOf(this.getCount());
        }
    }

    class MultiBand
    extends Band {
        Band[] bands;
        int bandCount;
        private int cap;

        MultiBand(String name, Coding regularCoding) {
            super(name, regularCoding);
            this.bands = new Band[10];
            this.bandCount = 0;
            this.cap = -1;
        }

        @Override
        public Band init() {
            super.init();
            this.setCapacity(0);
            if (this.phase() == 2) {
                this.setPhase(4);
                this.setPhase(6);
            }
            return this;
        }

        int size() {
            return this.bandCount;
        }

        Band get(int i) {
            assert (i < this.bandCount);
            return this.bands[i];
        }

        Band[] toArray() {
            return (Band[])BandStructure.realloc(this.bands, this.bandCount);
        }

        void add(Band b) {
            assert (this.bandCount == 0 || BandStructure.this.notePrevForAssert(b, this.bands[this.bandCount - 1]));
            if (this.bandCount == this.bands.length) {
                this.bands = (Band[])BandStructure.realloc(this.bands);
            }
            this.bands[this.bandCount++] = b;
        }

        ByteBand newByteBand(String name) {
            ByteBand b = new ByteBand(name);
            b.init();
            this.add(b);
            return b;
        }

        IntBand newIntBand(String name) {
            IntBand b = new IntBand(name, this.regularCoding);
            b.init();
            this.add(b);
            return b;
        }

        IntBand newIntBand(String name, Coding regularCoding) {
            IntBand b = new IntBand(name, regularCoding);
            b.init();
            this.add(b);
            return b;
        }

        MultiBand newMultiBand(String name, Coding regularCoding) {
            MultiBand b = new MultiBand(name, regularCoding);
            b.init();
            this.add(b);
            return b;
        }

        CPRefBand newCPRefBand(String name, byte cpTag) {
            CPRefBand b = new CPRefBand(name, this.regularCoding, cpTag);
            b.init();
            this.add(b);
            return b;
        }

        CPRefBand newCPRefBand(String name, Coding regularCoding, byte cpTag) {
            CPRefBand b = new CPRefBand(name, regularCoding, cpTag);
            b.init();
            this.add(b);
            return b;
        }

        CPRefBand newCPRefBand(String name, Coding regularCoding, byte cpTag, boolean nullOK) {
            CPRefBand b = new CPRefBand(name, regularCoding, cpTag, nullOK);
            b.init();
            this.add(b);
            return b;
        }

        int bandCount() {
            return this.bandCount;
        }

        @Override
        public int capacity() {
            return this.cap;
        }

        @Override
        public void setCapacity(int cap) {
            this.cap = cap;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public int valuesRemainingForDebug() {
            return 0;
        }

        @Override
        protected void chooseBandCodings() throws IOException {
            for (int i = 0; i < this.bandCount; ++i) {
                Band b = this.bands[i];
                b.chooseBandCodings();
            }
        }

        @Override
        protected long computeOutputSize() {
            long sum = 0L;
            for (int i = 0; i < this.bandCount; ++i) {
                Band b = this.bands[i];
                long bsize = b.outputSize();
                assert (bsize >= 0L) : b;
                sum += bsize;
            }
            return sum;
        }

        @Override
        protected void writeDataTo(OutputStream out) throws IOException {
            long preCount = 0L;
            if (BandStructure.this.outputCounter != null) {
                preCount = BandStructure.this.outputCounter.getCount();
            }
            for (int i = 0; i < this.bandCount; ++i) {
                Band b = this.bands[i];
                b.writeTo(out);
                if (BandStructure.this.outputCounter == null) continue;
                long postCount = BandStructure.this.outputCounter.getCount();
                long len = postCount - preCount;
                preCount = postCount;
                if ((BandStructure.this.verbose <= 0 || len <= 0L) && BandStructure.this.verbose <= 1) continue;
                Utils.log.info("  ...wrote " + len + " bytes from " + b);
            }
        }

        @Override
        protected void readDataFrom(InputStream in) throws IOException {
            assert (false);
            for (int i = 0; i < this.bandCount; ++i) {
                Band b = this.bands[i];
                b.readFrom(in);
                if ((BandStructure.this.verbose <= 0 || b.length() <= 0) && BandStructure.this.verbose <= 1) continue;
                Utils.log.info("  ...read " + b);
            }
        }

        @Override
        public String toString() {
            return "{" + this.bandCount() + " bands: " + super.toString() + "}";
        }
    }

    class CPRefBand
    extends ValueBand {
        ConstantPool.Index index;
        boolean nullOK;

        public CPRefBand(String name, Coding regularCoding, byte cpTag, boolean nullOK) {
            super(name, regularCoding);
            this.nullOK = nullOK;
            if (cpTag != 0) {
                BandStructure.this.setBandIndex(this, cpTag);
            }
        }

        public CPRefBand(String name, Coding regularCoding, byte cpTag) {
            this(name, regularCoding, cpTag, false);
        }

        public CPRefBand(String name, Coding regularCoding, Object undef) {
            this(name, regularCoding, 0, false);
        }

        public void setIndex(ConstantPool.Index index) {
            this.index = index;
        }

        @Override
        protected void readDataFrom(InputStream in) throws IOException {
            super.readDataFrom(in);
            assert (BandStructure.this.assertValidCPRefs(this));
        }

        public void putRef(ConstantPool.Entry e) {
            this.addValue(this.encodeRefOrNull(e, this.index));
        }

        public void putRef(ConstantPool.Entry e, ConstantPool.Index index) {
            assert (this.index == null);
            this.addValue(this.encodeRefOrNull(e, index));
        }

        public void putRef(ConstantPool.Entry e, byte cptag) {
            this.putRef(e, BandStructure.this.getCPIndex(cptag));
        }

        public ConstantPool.Entry getRef() {
            if (this.index == null) {
                Utils.log.warning("No index for " + this);
            }
            assert (this.index != null);
            return this.decodeRefOrNull(this.getValue(), this.index);
        }

        public ConstantPool.Entry getRef(ConstantPool.Index index) {
            assert (this.index == null);
            return this.decodeRefOrNull(this.getValue(), index);
        }

        public ConstantPool.Entry getRef(byte cptag) {
            return this.getRef(BandStructure.this.getCPIndex(cptag));
        }

        private int encodeRefOrNull(ConstantPool.Entry e, ConstantPool.Index index) {
            int nonNullCode = e == null ? -1 : BandStructure.this.encodeRef(e, index);
            return (this.nullOK ? 1 : 0) + nonNullCode;
        }

        private ConstantPool.Entry decodeRefOrNull(int code, ConstantPool.Index index) {
            int nonNullCode = code - (this.nullOK ? 1 : 0);
            if (nonNullCode == -1) {
                return null;
            }
            return BandStructure.this.decodeRef(nonNullCode, index);
        }
    }

    class IntBand
    extends ValueBand {
        public IntBand(String name, Coding regularCoding) {
            super(name, regularCoding);
        }

        public void putInt(int x) {
            assert (this.phase() == 1);
            this.addValue(x);
        }

        public int getInt() {
            return this.getValue();
        }

        public int getIntTotal() {
            assert (this.phase() == 6);
            assert (this.valuesRemainingForDebug() == this.length());
            int total = 0;
            for (int k = this.length(); k > 0; --k) {
                total += this.getInt();
            }
            this.resetForSecondPass();
            return total;
        }

        public int getIntCount(int value) {
            assert (this.phase() == 6);
            assert (this.valuesRemainingForDebug() == this.length());
            int total = 0;
            for (int k = this.length(); k > 0; --k) {
                if (this.getInt() != value) continue;
                ++total;
            }
            this.resetForSecondPass();
            return total;
        }
    }

    class ByteBand
    extends Band {
        private ByteArrayOutputStream bytes;
        private ByteArrayOutputStream bytesForDump;
        private InputStream in;

        public ByteBand(String name) {
            super(name, BYTE1);
        }

        @Override
        public int capacity() {
            return this.bytes == null ? -1 : Integer.MAX_VALUE;
        }

        @Override
        protected void setCapacity(int cap) {
            assert (this.bytes == null);
            this.bytes = new ByteArrayOutputStream(cap);
        }

        public void destroy() {
            this.lengthForDebug = this.length();
            this.bytes = null;
        }

        @Override
        public int length() {
            return this.bytes == null ? -1 : this.bytes.size();
        }

        public void reset() {
            this.bytes.reset();
        }

        @Override
        protected int valuesRemainingForDebug() {
            return this.bytes == null ? -1 : ((ByteArrayInputStream)this.in).available();
        }

        @Override
        protected void chooseBandCodings() throws IOException {
            assert (BandStructure.decodeEscapeValue(this.regularCoding.min(), this.regularCoding) < 0);
            assert (BandStructure.decodeEscapeValue(this.regularCoding.max(), this.regularCoding) < 0);
        }

        @Override
        protected long computeOutputSize() {
            return this.bytes.size();
        }

        @Override
        public void writeDataTo(OutputStream out) throws IOException {
            if (this.length() == 0) {
                return;
            }
            this.bytes.writeTo(out);
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
            this.destroy();
        }

        private void dumpBand() throws IOException {
            assert (BandStructure.this.optDumpBands);
            try (OutputStream ds = BandStructure.getDumpStream(this, ".bnd");){
                if (this.bytesForDump != null) {
                    this.bytesForDump.writeTo(ds);
                } else {
                    this.bytes.writeTo(ds);
                }
            }
        }

        @Override
        public void readDataFrom(InputStream in) throws IOException {
            int vex = this.valuesExpected();
            if (vex == 0) {
                return;
            }
            if (BandStructure.this.verbose > 1) {
                this.lengthForDebug = vex;
                Utils.log.fine("Reading band " + this);
                this.lengthForDebug = -1;
            }
            byte[] buf = new byte[Math.min(vex, 16384)];
            while (vex > 0) {
                int nr = in.read(buf, 0, Math.min(vex, buf.length));
                if (nr < 0) {
                    throw new EOFException();
                }
                this.bytes.write(buf, 0, nr);
                vex -= nr;
            }
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        @Override
        public void readyToDisburse() {
            this.in = new ByteArrayInputStream(this.bytes.toByteArray());
            super.readyToDisburse();
        }

        @Override
        public void doneDisbursing() {
            super.doneDisbursing();
            if (BandStructure.this.optDumpBands && this.bytesForDump != null && this.bytesForDump.size() > 0) {
                try {
                    this.dumpBand();
                }
                catch (IOException ee) {
                    throw new RuntimeException(ee);
                }
            }
            this.in = null;
            this.bytes = null;
            this.bytesForDump = null;
        }

        public void setInputStreamFrom(InputStream in) throws IOException {
            assert (this.bytes == null);
            assert (BandStructure.this.assertReadyToReadFrom(this, in));
            this.setPhase(4);
            this.in = in;
            if (BandStructure.this.optDumpBands) {
                this.bytesForDump = new ByteArrayOutputStream();
                this.in = new FilterInputStream(in){

                    @Override
                    public int read() throws IOException {
                        int ch = this.in.read();
                        if (ch >= 0) {
                            ByteBand.this.bytesForDump.write(ch);
                        }
                        return ch;
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        int nr = this.in.read(b, off, len);
                        if (nr >= 0) {
                            ByteBand.this.bytesForDump.write(b, off, nr);
                        }
                        return nr;
                    }
                };
            }
            super.readyToDisburse();
        }

        public OutputStream collectorStream() {
            assert (this.phase() == 1);
            assert (this.bytes != null);
            return this.bytes;
        }

        public InputStream getInputStream() {
            assert (this.phase() == 6);
            assert (this.in != null);
            return this.in;
        }

        public int getByte() throws IOException {
            int b = this.getInputStream().read();
            if (b < 0) {
                throw new EOFException();
            }
            return b;
        }

        public void putByte(int b) throws IOException {
            assert (b == (b & 0xFF));
            this.collectorStream().write(b);
        }

        @Override
        public String toString() {
            return "byte " + super.toString();
        }
    }

    class ValueBand
    extends Band {
        private int[] values;
        private int length;
        private int valuesDisbursed;
        private CodingMethod bandCoding;
        private byte[] metaCoding;

        protected ValueBand(String name, Coding regularCoding) {
            super(name, regularCoding);
        }

        @Override
        public int capacity() {
            return this.values == null ? -1 : this.values.length;
        }

        @Override
        protected void setCapacity(int cap) {
            assert (this.length <= cap);
            if (cap == -1) {
                this.values = null;
                return;
            }
            this.values = BandStructure.realloc(this.values, cap);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        protected int valuesRemainingForDebug() {
            return this.length - this.valuesDisbursed;
        }

        protected int valueAtForDebug(int i) {
            return this.values[i];
        }

        void patchValue(int i, int value) {
            assert (this == BandStructure.this.archive_header_S);
            assert (i == 0 || i == 1);
            assert (i < this.length);
            this.values[i] = value;
            this.outputSize = -1L;
        }

        protected void initializeValues(int[] values) {
            assert (BandStructure.assertCanChangeLength(this));
            assert (this.length == 0);
            this.values = values;
            this.length = values.length;
        }

        protected void addValue(int x) {
            assert (BandStructure.assertCanChangeLength(this));
            if (this.length == this.values.length) {
                this.setCapacity(this.length < 1000 ? this.length * 10 : this.length * 2);
            }
            this.values[this.length++] = x;
        }

        private boolean canVaryCoding() {
            if (!BandStructure.this.optVaryCodings) {
                return false;
            }
            if (this.length == 0) {
                return false;
            }
            if (this == BandStructure.this.archive_header_0) {
                return false;
            }
            if (this == BandStructure.this.archive_header_S) {
                return false;
            }
            if (this == BandStructure.this.archive_header_1) {
                return false;
            }
            return this.regularCoding.min() <= -256 || this.regularCoding.max() >= 256;
        }

        private boolean shouldVaryCoding() {
            assert (this.canVaryCoding());
            return BandStructure.this.effort >= 9 || this.length >= 100;
        }

        @Override
        protected void chooseBandCodings() throws IOException {
            boolean canVary = this.canVaryCoding();
            if (!canVary || !this.shouldVaryCoding()) {
                if (this.regularCoding.canRepresent(this.values, 0, this.length)) {
                    this.bandCoding = this.regularCoding;
                } else {
                    assert (canVary);
                    if (BandStructure.this.verbose > 1) {
                        Utils.log.fine("regular coding fails in band " + this.name());
                    }
                    this.bandCoding = UNSIGNED5;
                }
                this.outputSize = -1L;
            } else {
                int[] sizes = new int[]{0, 0};
                this.bandCoding = BandStructure.this.chooseCoding(this.values, 0, this.length, this.regularCoding, this.name(), sizes);
                this.outputSize = sizes[0];
                if (this.outputSize == 0L) {
                    this.outputSize = -1L;
                }
            }
            if (this.bandCoding != this.regularCoding) {
                this.metaCoding = this.bandCoding.getMetaCoding(this.regularCoding);
                if (BandStructure.this.verbose > 1) {
                    Utils.log.fine("alternate coding " + this + " " + this.bandCoding);
                }
            } else {
                this.metaCoding = canVary && BandStructure.decodeEscapeValue(this.values[0], this.regularCoding) >= 0 ? defaultMetaCoding : noMetaCoding;
            }
            if (this.metaCoding.length > 0 && (BandStructure.this.verbose > 2 || BandStructure.this.verbose > 1 && this.metaCoding.length > 1)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.metaCoding.length; ++i) {
                    if (i == 1) {
                        sb.append(" /");
                    }
                    sb.append(" ").append(this.metaCoding[i] & 0xFF);
                }
                Utils.log.fine("   meta-coding " + sb);
            }
            assert (this.outputSize < 0L || !(this.bandCoding instanceof Coding) || this.outputSize == (long)((Coding)this.bandCoding).getLength(this.values, 0, this.length)) : this.bandCoding + " : " + this.outputSize + " != " + ((Coding)this.bandCoding).getLength(this.values, 0, this.length) + " ?= " + BandStructure.this.getCodingChooser().computeByteSize(this.bandCoding, this.values, 0, this.length);
            if (this.metaCoding.length > 0) {
                if (this.outputSize >= 0L) {
                    this.outputSize += (long)this.computeEscapeSize();
                }
                for (int i = 1; i < this.metaCoding.length; ++i) {
                    BandStructure.this.band_headers.putByte(this.metaCoding[i] & 0xFF);
                }
            }
        }

        @Override
        protected long computeOutputSize() {
            this.outputSize = BandStructure.this.getCodingChooser().computeByteSize(this.bandCoding, this.values, 0, this.length);
            assert (this.outputSize < Integer.MAX_VALUE);
            this.outputSize += (long)this.computeEscapeSize();
            return this.outputSize;
        }

        protected int computeEscapeSize() {
            if (this.metaCoding.length == 0) {
                return 0;
            }
            int XB = this.metaCoding[0] & 0xFF;
            int X = BandStructure.encodeEscapeValue(XB, this.regularCoding);
            return this.regularCoding.setD(0).getLength(X);
        }

        @Override
        protected void writeDataTo(OutputStream out) throws IOException {
            if (this.length == 0) {
                return;
            }
            long len0 = 0L;
            if (out == BandStructure.this.outputCounter) {
                len0 = BandStructure.this.outputCounter.getCount();
            }
            if (this.metaCoding.length > 0) {
                int XB = this.metaCoding[0] & 0xFF;
                int X = BandStructure.encodeEscapeValue(XB, this.regularCoding);
                this.regularCoding.setD(0).writeTo(out, X);
            }
            this.bandCoding.writeArrayTo(out, this.values, 0, this.length);
            if (out == BandStructure.this.outputCounter) assert (this.outputSize == BandStructure.this.outputCounter.getCount() - len0) : this.outputSize + " != " + BandStructure.this.outputCounter.getCount() + "-" + len0;
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        @Override
        protected void readDataFrom(InputStream in) throws IOException {
            this.length = this.valuesExpected();
            if (this.length == 0) {
                return;
            }
            if (BandStructure.this.verbose > 1) {
                Utils.log.fine("Reading band " + this);
            }
            if (!this.canVaryCoding()) {
                this.bandCoding = this.regularCoding;
                this.metaCoding = noMetaCoding;
            } else {
                assert (in.markSupported());
                in.mark(5);
                int X = this.regularCoding.setD(0).readFrom(in);
                int XB = BandStructure.decodeEscapeValue(X, this.regularCoding);
                if (XB < 0) {
                    in.reset();
                    XB = 0;
                    this.bandCoding = this.regularCoding;
                    this.metaCoding = noMetaCoding;
                } else if (XB == 0) {
                    this.bandCoding = this.regularCoding;
                    this.metaCoding = defaultMetaCoding;
                } else {
                    if (BandStructure.this.verbose > 2) {
                        Utils.log.fine("found X=" + X + " => XB=" + XB);
                    }
                    this.bandCoding = BandStructure.this.getBandHeader(XB, this.regularCoding);
                    int p0 = BandStructure.this.bandHeaderBytePos0;
                    int p1 = BandStructure.this.bandHeaderBytePos;
                    this.metaCoding = new byte[p1 - p0];
                    System.arraycopy(BandStructure.this.bandHeaderBytes, p0, this.metaCoding, 0, this.metaCoding.length);
                }
            }
            if (this.bandCoding != this.regularCoding && BandStructure.this.verbose > 1) {
                Utils.log.fine(this.name() + ": irregular coding " + this.bandCoding);
            }
            this.bandCoding.readArrayFrom(in, this.values, 0, this.length);
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        @Override
        public void doneDisbursing() {
            super.doneDisbursing();
            this.values = null;
        }

        private void dumpBand() throws IOException {
            assert (BandStructure.this.optDumpBands);
            try (PrintStream ps = new PrintStream(BandStructure.getDumpStream(this, ".txt"));){
                String irr = this.bandCoding == this.regularCoding ? "" : " irregular";
                ps.print("# length=" + this.length + " size=" + this.outputSize() + irr + " coding=" + this.bandCoding);
                if (this.metaCoding != noMetaCoding) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < this.metaCoding.length; ++i) {
                        if (i == 1) {
                            sb.append(" /");
                        }
                        sb.append(" ").append(this.metaCoding[i] & 0xFF);
                    }
                    ps.print(" //header: " + sb);
                }
                BandStructure.printArrayTo(ps, this.values, 0, this.length);
            }
            var2_2 = null;
            try (OutputStream ds = BandStructure.getDumpStream(this, ".bnd");){
                this.bandCoding.writeArrayTo(ds, this.values, 0, this.length);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        }

        protected int getValue() {
            assert (this.phase() == 6);
            assert (this.valuesDisbursed < this.length);
            return this.values[this.valuesDisbursed++];
        }

        public void resetForSecondPass() {
            assert (this.phase() == 6);
            assert (this.valuesDisbursed == this.length());
            this.valuesDisbursed = 0;
        }
    }

    abstract class Band {
        private int phase = 0;
        private final String name;
        private int valuesExpected;
        protected long outputSize = -1L;
        public final Coding regularCoding;
        public final int seqForDebug;
        public int elementCountForDebug;
        protected int lengthForDebug = -1;

        protected Band(String name, Coding regularCoding) {
            this.name = name;
            this.regularCoding = regularCoding;
            this.seqForDebug = ++nextSeqForDebug;
            if (BandStructure.this.verbose > 2) {
                Utils.log.fine("Band " + this.seqForDebug + " is " + name);
            }
        }

        public Band init() {
            if (BandStructure.this.isReader) {
                this.readyToExpect();
            } else {
                this.readyToCollect();
            }
            return this;
        }

        boolean isReader() {
            return BandStructure.this.isReader;
        }

        int phase() {
            return this.phase;
        }

        String name() {
            return this.name;
        }

        public abstract int capacity();

        protected abstract void setCapacity(int var1);

        public abstract int length();

        protected abstract int valuesRemainingForDebug();

        public final int valuesExpected() {
            return this.valuesExpected;
        }

        public final void writeTo(OutputStream out) throws IOException {
            assert (BandStructure.this.assertReadyToWriteTo(this, out));
            this.setPhase(5);
            this.writeDataTo(out);
            this.doneWriting();
        }

        abstract void chooseBandCodings() throws IOException;

        public final long outputSize() {
            if (this.outputSize >= 0L) {
                long size = this.outputSize;
                assert (size == this.computeOutputSize());
                return size;
            }
            return this.computeOutputSize();
        }

        protected abstract long computeOutputSize();

        protected abstract void writeDataTo(OutputStream var1) throws IOException;

        void expectLength(int l) {
            assert (BandStructure.assertPhase(this, 2));
            assert (this.valuesExpected == 0);
            assert (l >= 0);
            this.valuesExpected = l;
        }

        void expectMoreLength(int l) {
            assert (BandStructure.assertPhase(this, 2));
            this.valuesExpected += l;
        }

        private void readyToCollect() {
            this.setCapacity(1);
            this.setPhase(1);
        }

        protected void doneWriting() {
            assert (BandStructure.assertPhase(this, 5));
            this.setPhase(8);
        }

        private void readyToExpect() {
            this.setPhase(2);
        }

        public final void readFrom(InputStream in) throws IOException {
            assert (BandStructure.this.assertReadyToReadFrom(this, in));
            this.setCapacity(this.valuesExpected());
            this.setPhase(4);
            this.readDataFrom(in);
            this.readyToDisburse();
        }

        protected abstract void readDataFrom(InputStream var1) throws IOException;

        protected void readyToDisburse() {
            if (BandStructure.this.verbose > 1) {
                Utils.log.fine("readyToDisburse " + this);
            }
            this.setPhase(6);
        }

        public void doneDisbursing() {
            assert (BandStructure.assertPhase(this, 6));
            this.setPhase(8);
        }

        public final void doneWithUnusedBand() {
            if (BandStructure.this.isReader) {
                assert (BandStructure.assertPhase(this, 2));
                assert (this.valuesExpected() == 0);
                this.setPhase(4);
                this.setPhase(6);
                this.setPhase(8);
            } else {
                this.setPhase(3);
            }
        }

        protected void setPhase(int newPhase) {
            assert (BandStructure.assertPhaseChangeOK(this, this.phase, newPhase));
            this.phase = newPhase;
        }

        public String toString() {
            int length = this.lengthForDebug != -1 ? this.lengthForDebug : this.length();
            String str = this.name;
            if (length != 0) {
                str = str + "[" + length + "]";
            }
            if (this.elementCountForDebug != 0) {
                str = str + "(" + this.elementCountForDebug + ")";
            }
            return str;
        }
    }
}

