/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.MutableBigInteger;
import java.util.Random;

class BitSieve {
    private long[] bits;
    private int length;
    private static BitSieve smallSieve = new BitSieve();

    private BitSieve() {
        this.length = 9600;
        this.bits = new long[BitSieve.unitIndex(this.length - 1) + 1];
        this.set(0);
        int nextIndex = 1;
        int nextPrime = 3;
        do {
            this.sieveSingle(this.length, nextIndex + nextPrime, nextPrime);
            nextIndex = this.sieveSearch(this.length, nextIndex + 1);
            nextPrime = 2 * nextIndex + 1;
        } while (nextIndex > 0 && nextPrime < this.length);
    }

    BitSieve(BigInteger base, int searchLen) {
        this.bits = new long[BitSieve.unitIndex(searchLen - 1) + 1];
        this.length = searchLen;
        int start = 0;
        int step = smallSieve.sieveSearch(BitSieve.smallSieve.length, start);
        int convertedStep = step * 2 + 1;
        MutableBigInteger b = new MutableBigInteger(base);
        MutableBigInteger q = new MutableBigInteger();
        do {
            start = b.divideOneWord(convertedStep, q);
            if ((start = convertedStep - start) % 2 == 0) {
                start += convertedStep;
            }
            this.sieveSingle(searchLen, (start - 1) / 2, convertedStep);
            step = smallSieve.sieveSearch(BitSieve.smallSieve.length, step + 1);
            convertedStep = step * 2 + 1;
        } while (step > 0);
    }

    private static int unitIndex(int bitIndex) {
        return bitIndex >>> 6;
    }

    private static long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private boolean get(int bitIndex) {
        int unitIndex = BitSieve.unitIndex(bitIndex);
        return (this.bits[unitIndex] & BitSieve.bit(bitIndex)) != 0L;
    }

    private void set(int bitIndex) {
        int unitIndex;
        int n = unitIndex = BitSieve.unitIndex(bitIndex);
        this.bits[n] = this.bits[n] | BitSieve.bit(bitIndex);
    }

    private int sieveSearch(int limit, int start) {
        if (start >= limit) {
            return -1;
        }
        int index = start;
        do {
            if (this.get(index)) continue;
            return index;
        } while (++index < limit - 1);
        return -1;
    }

    private void sieveSingle(int limit, int start, int step) {
        while (start < limit) {
            this.set(start);
            start += step;
        }
    }

    BigInteger retrieve(BigInteger initValue, int certainty, Random random) {
        int offset = 1;
        for (int i = 0; i < this.bits.length; ++i) {
            long nextLong = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            for (int j = 0; j < 64; ++j) {
                BigInteger candidate;
                if ((nextLong & 1L) == 1L && (candidate = initValue.add(BigInteger.valueOf(offset))).primeToCertainty(certainty, random)) {
                    return candidate;
                }
                nextLong >>>= 1;
                offset += 2;
            }
        }
        return null;
    }
}

