/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import sun.java2d.StateTrackable;

public final class DataBufferFloat
extends DataBuffer {
    float[][] bankdata;
    float[] data;

    public DataBufferFloat(int size) {
        super(StateTrackable.State.STABLE, 4, size);
        this.data = new float[size];
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(int size, int numBanks) {
        super(StateTrackable.State.STABLE, 4, size, numBanks);
        this.bankdata = new float[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            this.bankdata[i] = new float[size];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[] dataArray, int size) {
        super(StateTrackable.State.UNTRACKABLE, 4, size);
        this.data = dataArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[] dataArray, int size, int offset) {
        super(StateTrackable.State.UNTRACKABLE, 4, size, 1, offset);
        this.data = dataArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[][] dataArray, int size) {
        super(StateTrackable.State.UNTRACKABLE, 4, size, dataArray.length);
        this.bankdata = (float[][])dataArray.clone();
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[][] dataArray, int size, int[] offsets) {
        super(StateTrackable.State.UNTRACKABLE, 4, size, dataArray.length, offsets);
        this.bankdata = (float[][])dataArray.clone();
        this.data = this.bankdata[0];
    }

    public float[] getData() {
        this.theTrackable.setUntrackable();
        return this.data;
    }

    public float[] getData(int bank) {
        this.theTrackable.setUntrackable();
        return this.bankdata[bank];
    }

    public float[][] getBankData() {
        this.theTrackable.setUntrackable();
        return (float[][])this.bankdata.clone();
    }

    @Override
    public int getElem(int i) {
        return (int)this.data[i + this.offset];
    }

    @Override
    public int getElem(int bank, int i) {
        return (int)this.bankdata[bank][i + this.offsets[bank]];
    }

    @Override
    public void setElem(int i, int val) {
        this.data[i + this.offset] = val;
        this.theTrackable.markDirty();
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.bankdata[bank][i + this.offsets[bank]] = val;
        this.theTrackable.markDirty();
    }

    @Override
    public float getElemFloat(int i) {
        return this.data[i + this.offset];
    }

    @Override
    public float getElemFloat(int bank, int i) {
        return this.bankdata[bank][i + this.offsets[bank]];
    }

    @Override
    public void setElemFloat(int i, float val) {
        this.data[i + this.offset] = val;
        this.theTrackable.markDirty();
    }

    @Override
    public void setElemFloat(int bank, int i, float val) {
        this.bankdata[bank][i + this.offsets[bank]] = val;
        this.theTrackable.markDirty();
    }

    @Override
    public double getElemDouble(int i) {
        return this.data[i + this.offset];
    }

    @Override
    public double getElemDouble(int bank, int i) {
        return this.bankdata[bank][i + this.offsets[bank]];
    }

    @Override
    public void setElemDouble(int i, double val) {
        this.data[i + this.offset] = (float)val;
        this.theTrackable.markDirty();
    }

    @Override
    public void setElemDouble(int bank, int i, double val) {
        this.bankdata[bank][i + this.offsets[bank]] = (float)val;
        this.theTrackable.markDirty();
    }
}

