/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

public class DropTargetDropEvent
extends DropTargetEvent {
    private static final long serialVersionUID = -1721911170440459322L;
    private static final Point zero = new Point(0, 0);
    private Point location = zero;
    private int actions = 0;
    private int dropAction = 0;
    private boolean isLocalTx = false;

    public DropTargetDropEvent(DropTargetContext dtc, Point cursorLocn, int dropAction, int srcActions) {
        super(dtc);
        if (cursorLocn == null) {
            throw new NullPointerException("cursorLocn");
        }
        if (dropAction != 0 && dropAction != 1 && dropAction != 2 && dropAction != 0x40000000) {
            throw new IllegalArgumentException("dropAction = " + dropAction);
        }
        if ((srcActions & 0xBFFFFFFC) != 0) {
            throw new IllegalArgumentException("srcActions");
        }
        this.location = cursorLocn;
        this.actions = srcActions;
        this.dropAction = dropAction;
    }

    public DropTargetDropEvent(DropTargetContext dtc, Point cursorLocn, int dropAction, int srcActions, boolean isLocal) {
        this(dtc, cursorLocn, dropAction, srcActions);
        this.isLocalTx = isLocal;
    }

    public Point getLocation() {
        return this.location;
    }

    public DataFlavor[] getCurrentDataFlavors() {
        return this.getDropTargetContext().getCurrentDataFlavors();
    }

    public List<DataFlavor> getCurrentDataFlavorsAsList() {
        return this.getDropTargetContext().getCurrentDataFlavorsAsList();
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        return this.getDropTargetContext().isDataFlavorSupported(df);
    }

    public int getSourceActions() {
        return this.actions;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public Transferable getTransferable() {
        return this.getDropTargetContext().getTransferable();
    }

    public void acceptDrop(int dropAction) {
        this.getDropTargetContext().acceptDrop(dropAction);
    }

    public void rejectDrop() {
        this.getDropTargetContext().rejectDrop();
    }

    public void dropComplete(boolean success) {
        this.getDropTargetContext().dropComplete(success);
    }

    public boolean isLocalTransfer() {
        return this.isLocalTx;
    }
}

