/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import com.sun.tracing.ProbeName;
import com.sun.tracing.Provider;
import com.sun.tracing.dtrace.Attributes;
import com.sun.tracing.dtrace.DependencyClass;
import com.sun.tracing.dtrace.FunctionName;
import com.sun.tracing.dtrace.ModuleName;
import com.sun.tracing.dtrace.StabilityLevel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.misc.ProxyGenerator;
import sun.tracing.ProbeSkeleton;
import sun.tracing.ProviderSkeleton;
import sun.tracing.dtrace.Activation;
import sun.tracing.dtrace.DTraceProbe;
import sun.tracing.dtrace.JVM;

class DTraceProvider
extends ProviderSkeleton {
    private Activation activation;
    private Object proxy;
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private final String proxyClassNamePrefix = "$DTraceTracingProxy";
    static final String DEFAULT_MODULE = "java_tracing";
    static final String DEFAULT_FUNCTION = "unspecified";
    private static long nextUniqueNumber = 0L;

    private static synchronized long getUniqueNumber() {
        return nextUniqueNumber++;
    }

    @Override
    protected ProbeSkeleton createProbe(Method m) {
        return new DTraceProbe(this.proxy, m);
    }

    DTraceProvider(Class<? extends Provider> type) {
        super(type);
    }

    void setProxy(Object p) {
        this.proxy = p;
    }

    void setActivation(Activation a) {
        this.activation = a;
    }

    @Override
    public void dispose() {
        if (this.activation != null) {
            this.activation.disposeProvider(this);
            this.activation = null;
        }
        super.dispose();
    }

    @Override
    public <T extends Provider> T newProxyInstance() {
        long num = DTraceProvider.getUniqueNumber();
        String proxyPkg = "";
        if (!Modifier.isPublic(this.providerType.getModifiers())) {
            String name = this.providerType.getName();
            int n = name.lastIndexOf(46);
            proxyPkg = n == -1 ? "" : name.substring(0, n + 1);
        }
        String proxyName = proxyPkg + "$DTraceTracingProxy" + num;
        Class<?> proxyClass = null;
        byte[] proxyClassFile = ProxyGenerator.generateProxyClass(proxyName, new Class[]{this.providerType});
        try {
            proxyClass = JVM.defineClass(this.providerType.getClassLoader(), proxyName, proxyClassFile, 0, proxyClassFile.length);
        }
        catch (ClassFormatError e) {
            throw new IllegalArgumentException(e.toString());
        }
        try {
            Constructor<?> cons = proxyClass.getConstructor(constructorParams);
            return (T)((Provider)cons.newInstance(this));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    protected void triggerProbe(Method method, Object[] args) {
        assert (false) : "This method should have been overridden by the JVM";
    }

    @Override
    public String getProviderName() {
        return super.getProviderName();
    }

    String getModuleName() {
        return DTraceProvider.getAnnotationString(this.providerType, ModuleName.class, DEFAULT_MODULE);
    }

    static String getProbeName(Method method) {
        return DTraceProvider.getAnnotationString(method, ProbeName.class, method.getName());
    }

    static String getFunctionName(Method method) {
        return DTraceProvider.getAnnotationString(method, FunctionName.class, DEFAULT_FUNCTION);
    }

    DTraceProbe[] getProbes() {
        return this.probes.values().toArray(new DTraceProbe[0]);
    }

    StabilityLevel getNameStabilityFor(Class<? extends Annotation> type) {
        Attributes attrs = (Attributes)DTraceProvider.getAnnotationValue(this.providerType, type, "value", null);
        if (attrs == null) {
            return StabilityLevel.PRIVATE;
        }
        return attrs.name();
    }

    StabilityLevel getDataStabilityFor(Class<? extends Annotation> type) {
        Attributes attrs = (Attributes)DTraceProvider.getAnnotationValue(this.providerType, type, "value", null);
        if (attrs == null) {
            return StabilityLevel.PRIVATE;
        }
        return attrs.data();
    }

    DependencyClass getDependencyClassFor(Class<? extends Annotation> type) {
        Attributes attrs = (Attributes)DTraceProvider.getAnnotationValue(this.providerType, type, "value", null);
        if (attrs == null) {
            return DependencyClass.UNKNOWN;
        }
        return attrs.dependency();
    }
}

