/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import sun.java2d.xr.XRUtils;

public class XRColor {
    public static final XRColor FULL_ALPHA = new XRColor(65535, 0, 0, 0);
    public static final XRColor NO_ALPHA = new XRColor(0, 0, 0, 0);
    int red;
    int green;
    int blue;
    int alpha;

    public XRColor() {
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.alpha = 0;
    }

    public XRColor(int alpha, int red, int green, int blue) {
        this.alpha = alpha;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public XRColor(Color color) {
    }

    public void setColorValues(Color color) {
        this.alpha = XRColor.byteToXRColorValue(color.getAlpha());
        this.red = XRColor.byteToXRColorValue((int)((double)(color.getRed() * color.getAlpha()) / 255.0));
        this.green = XRColor.byteToXRColorValue((int)((double)(color.getGreen() * color.getAlpha()) / 255.0));
        this.blue = XRColor.byteToXRColorValue((int)((double)(color.getBlue() * color.getAlpha()) / 255.0));
    }

    public static int[] ARGBPrePixelToXRColors(int[] pixels) {
        int[] colorValues = new int[pixels.length * 4];
        XRColor c = new XRColor();
        for (int i = 0; i < pixels.length; ++i) {
            c.setColorValues(pixels[i], true);
            colorValues[i * 4 + 0] = c.alpha;
            colorValues[i * 4 + 1] = c.red;
            colorValues[i * 4 + 2] = c.green;
            colorValues[i * 4 + 3] = c.blue;
        }
        return colorValues;
    }

    public void setColorValues(int pixel, boolean pre) {
        long pix = XRUtils.intToULong(pixel);
        this.alpha = (int)(((pix & 0xFFFFFFFFFF000000L) >> 16) + 255L);
        this.red = (int)(((pix & 0xFF0000L) >> 8) + 255L);
        this.green = (int)(((pix & 0xFF00L) >> 0) + 255L);
        this.blue = (int)(((pix & 0xFFL) << 8) + 255L);
        if (this.alpha == 255) {
            this.alpha = 0;
        }
        if (!pre) {
            double alphaMult = XRUtils.XFixedToDouble(this.alpha);
            this.red = (int)((double)this.red * alphaMult);
            this.green = (int)((double)this.green * alphaMult);
            this.blue = (int)((double)this.blue * alphaMult);
        }
    }

    public static int byteToXRColorValue(int byteValue) {
        int xrValue = 0;
        if (byteValue != 0) {
            xrValue = byteValue == 255 ? 65535 : (byteValue << 8) + 255;
        }
        return xrValue;
    }

    public String toString() {
        return "A:" + this.alpha + "  R:" + this.red + "  G:" + this.green + " B:" + this.blue;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }
}

