/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import sun.awt.AWTAccessor;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.util.logging.PlatformLogger;

public final class XContentWindow
extends XWindow {
    private static PlatformLogger insLog = PlatformLogger.getLogger("sun.awt.X11.insets.XContentWindow");
    private final XDecoratedPeer parentFrame;
    private final List<SavedExposeEvent> iconifiedExposeEvents = new ArrayList<SavedExposeEvent>();

    static XContentWindow createContent(XDecoratedPeer parentFrame) {
        WindowDimensions dims = parentFrame.getDimensions();
        Rectangle rec = dims.getBounds();
        Insets ins = dims.getInsets();
        if (ins != null) {
            rec.x = -ins.left;
            rec.y = -ins.top;
        } else {
            rec.x = 0;
            rec.y = 0;
        }
        XContentWindow cw = new XContentWindow(parentFrame, rec);
        cw.xSetVisible(true);
        return cw;
    }

    private XContentWindow(XDecoratedPeer parentFrame, Rectangle bounds) {
        super((Component)parentFrame.getTarget(), parentFrame.getShell(), bounds);
        this.parentFrame = parentFrame;
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        params.putIfNull((Object)"bit gravity", (Object)1);
        Long eventMask = (Long)params.get("event mask");
        if (eventMask != null) {
            eventMask = eventMask & 0xFFFFFFFFFFFDFFFFL;
            params.put("event mask", eventMask);
        }
    }

    @Override
    protected String getWMName() {
        return "Content window";
    }

    @Override
    protected boolean isEventDisabled(XEvent e) {
        switch (e.get_type()) {
            case 7: 
            case 8: {
                return false;
            }
            case 22: {
                return true;
            }
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(e) || this.parentFrame.isEventDisabled(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContentBounds(WindowDimensions dims) {
        XToolkit.awtLock();
        try {
            Rectangle newBounds = dims.getBounds();
            Insets in = dims.getInsets();
            if (in != null) {
                newBounds.setLocation(-in.left, -in.top);
            }
            if (insLog.isLoggable(PlatformLogger.Level.FINE)) {
                insLog.fine("Setting content bounds {0}, old bounds {1}", newBounds, this.getBounds());
            }
            boolean needHandleResize = !newBounds.equals(this.getBounds());
            this.reshape(newBounds);
            if (needHandleResize) {
                insLog.fine("Sending RESIZED");
                this.handleResize(newBounds);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.validateSurface();
    }

    public void handleResize(Rectangle bounds) {
        AWTAccessor.getComponentAccessor().setSize(this.target, bounds.width, bounds.height);
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    @Override
    public void postPaintEvent(Component target, int x, int y, int w, int h) {
        if (this.parentFrame instanceof XFramePeer && (((XFramePeer)this.parentFrame).getState() & 1) != 0) {
            this.iconifiedExposeEvents.add(new SavedExposeEvent(target, x, y, w, h));
        } else {
            super.postPaintEvent(target, x, y, w, h);
        }
    }

    void purgeIconifiedExposeEvents() {
        for (SavedExposeEvent evt : this.iconifiedExposeEvents) {
            super.postPaintEvent(evt.target, evt.x, evt.y, evt.w, evt.h);
        }
        this.iconifiedExposeEvents.clear();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getBounds() + "]";
    }

    private static class SavedExposeEvent {
        Component target;
        int x;
        int y;
        int w;
        int h;

        SavedExposeEvent(Component target, int x, int y, int w, int h) {
            this.target = target;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

