/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.TreeMap;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontManagerForSGE;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment
implements DisplayChangedListener {
    public static boolean isOpenSolaris;
    private static Font defaultFont;
    protected GraphicsDevice[] screens;
    protected SunDisplayChanger displayChanger = new SunDisplayChanger();

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String version = System.getProperty("os.version", "0.0");
                try {
                    float ver = Float.parseFloat(version);
                    if (ver > 5.1f) {
                        String courierNew;
                        File courierFile;
                        File f = new File("/etc/release");
                        FileInputStream fis = new FileInputStream(f);
                        InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
                        BufferedReader br = new BufferedReader(isr);
                        String line = br.readLine();
                        isOpenSolaris = line.indexOf("OpenSolaris") >= 0 ? true : !(courierFile = new File(courierNew = "/usr/openwin/lib/X11/fonts/TrueType/CourierNew.ttf")).exists();
                        fis.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                defaultFont = new Font("Dialog", 0, 12);
                return null;
            }
        });
    }

    @Override
    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] ret = this.screens;
        if (ret == null) {
            int num = this.getNumScreens();
            ret = new GraphicsDevice[num];
            for (int i = 0; i < num; ++i) {
                ret[i] = this.makeScreenDevice(i);
            }
            this.screens = ret;
        }
        return ret;
    }

    protected abstract int getNumScreens();

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    @Override
    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    @Override
    public Graphics2D createGraphics(BufferedImage img) {
        if (img == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData sd = SurfaceData.getPrimarySurfaceData(img);
        return new SunGraphics2D(sd, Color.white, Color.black, defaultFont);
    }

    public static FontManagerForSGE getFontManagerForSGE() {
        FontManager fm = FontManagerFactory.getInstance();
        return (FontManagerForSGE)fm;
    }

    public static void useAlternateFontforJALocales() {
        SunGraphicsEnvironment.getFontManagerForSGE().useAlternateFontforJALocales();
    }

    @Override
    public Font[] getAllFonts() {
        FontManagerForSGE fm = SunGraphicsEnvironment.getFontManagerForSGE();
        Font[] installedFonts = fm.getAllInstalledFonts();
        Font[] created = fm.getCreatedFonts();
        if (created == null || created.length == 0) {
            return installedFonts;
        }
        int newlen = installedFonts.length + created.length;
        Font[] fonts = Arrays.copyOf(installedFonts, newlen);
        System.arraycopy(created, 0, fonts, installedFonts.length, created.length);
        return fonts;
    }

    @Override
    public String[] getAvailableFontFamilyNames(Locale requestedLocale) {
        FontManagerForSGE fm = SunGraphicsEnvironment.getFontManagerForSGE();
        String[] installed = fm.getInstalledFontFamilyNames(requestedLocale);
        TreeMap<String, String> map = fm.getCreatedFontFamilyNames();
        if (map == null || map.size() == 0) {
            return installed;
        }
        for (int i = 0; i < installed.length; ++i) {
            map.put(installed[i].toLowerCase(requestedLocale), installed[i]);
        }
        String[] retval = new String[map.size()];
        Object[] keyNames = map.keySet().toArray();
        for (int i = 0; i < keyNames.length; ++i) {
            retval[i] = map.get(keyNames[i]);
        }
        return retval;
    }

    @Override
    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    public static Rectangle getUsableBounds(GraphicsDevice gd) {
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle usableBounds = gc.getBounds();
        usableBounds.x += insets.left;
        usableBounds.y += insets.top;
        usableBounds.width -= insets.left + insets.right;
        usableBounds.height -= insets.top + insets.bottom;
        return usableBounds;
    }

    @Override
    public void displayChanged() {
        for (GraphicsDevice gd : this.getScreenDevices()) {
            if (!(gd instanceof DisplayChangedListener)) continue;
            ((DisplayChangedListener)((Object)gd)).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    @Override
    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public abstract boolean isDisplayLocal();

    public void addDisplayChangedListener(DisplayChangedListener client) {
        this.displayChanger.add(client);
    }

    public void removeDisplayChangedListener(DisplayChangedListener client) {
        this.displayChanger.remove(client);
    }

    public boolean isFlipStrategyPreferred(ComponentPeer peer) {
        return false;
    }
}

