/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.finder.ClassFinder;

class InstanceFinder<T> {
    private static final String[] EMPTY = new String[0];
    private final Class<? extends T> type;
    private final boolean allow;
    private final String suffix;
    private volatile String[] packages;

    InstanceFinder(Class<? extends T> type, boolean allow, String suffix, String ... packages) {
        this.type = type;
        this.allow = allow;
        this.suffix = suffix;
        this.packages = (String[])packages.clone();
    }

    public String[] getPackages() {
        return (String[])this.packages.clone();
    }

    public void setPackages(String ... packages) {
        this.packages = packages != null && packages.length > 0 ? (String[])packages.clone() : EMPTY;
    }

    public T find(Class<?> type) {
        if (type == null) {
            return null;
        }
        String name = type.getName() + this.suffix;
        T object = this.instantiate(type, name);
        if (object != null) {
            return object;
        }
        if (this.allow && (object = this.instantiate(type, null)) != null) {
            return object;
        }
        int index = name.lastIndexOf(46) + 1;
        if (index > 0) {
            name = name.substring(index);
        }
        for (String prefix : this.packages) {
            object = this.instantiate(type, prefix, name);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected T instantiate(Class<?> type, String name) {
        if (type != null) {
            try {
                if (name != null) {
                    type = ClassFinder.findClass(name, type.getClassLoader());
                }
                if (this.type.isAssignableFrom(type)) {
                    return (T)type.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected T instantiate(Class<?> type, String prefix, String name) {
        return this.instantiate(type, prefix + '.' + name);
    }
}

