/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.sun.xml.internal.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.internal.ws.org.objectweb.asm.MethodVisitor;
import com.sun.xml.internal.ws.org.objectweb.asm.Type;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

abstract class BoundMethodHandle
extends MethodHandle {
    static final String EXTENSION_TYPES = "LIJFD";
    static final byte INDEX_L = 0;
    static final byte INDEX_I = 1;
    static final byte INDEX_J = 2;
    static final byte INDEX_F = 3;
    static final byte INDEX_D = 4;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.Lookup.IMPL_LOOKUP;
    static final SpeciesData SPECIES_DATA = SpeciesData.EMPTY;

    BoundMethodHandle(MethodType type, LambdaForm form) {
        super(type, form);
    }

    static MethodHandle bindSingle(MethodType type, LambdaForm form, char xtype, Object x) {
        try {
            switch (xtype) {
                case 'L': {
                    return BoundMethodHandle.bindSingle(type, form, x);
                }
                case 'I': {
                    return SpeciesData.EMPTY.extendWithType((char)'I').constructor[0].invokeBasic(type, form, ValueConversions.widenSubword(x));
                }
                case 'J': {
                    return SpeciesData.EMPTY.extendWithType((char)'J').constructor[0].invokeBasic(type, form, (Long)x);
                }
                case 'F': {
                    return SpeciesData.EMPTY.extendWithType((char)'F').constructor[0].invokeBasic(type, form, ((Float)x).floatValue());
                }
                case 'D': {
                    return SpeciesData.EMPTY.extendWithType((char)'D').constructor[0].invokeBasic(type, form, (Double)x);
                }
            }
            throw new InternalError("unexpected xtype: " + xtype);
        }
        catch (Throwable t) {
            throw MethodHandleStatics.newInternalError(t);
        }
    }

    static MethodHandle bindSingle(MethodType type, LambdaForm form, Object x) {
        return new Species_L(type, form, x);
    }

    MethodHandle cloneExtend(MethodType type, LambdaForm form, char xtype, Object x) {
        try {
            switch (xtype) {
                case 'L': {
                    return this.cloneExtendL(type, form, x);
                }
                case 'I': {
                    return this.cloneExtendI(type, form, ValueConversions.widenSubword(x));
                }
                case 'J': {
                    return this.cloneExtendJ(type, form, (Long)x);
                }
                case 'F': {
                    return this.cloneExtendF(type, form, ((Float)x).floatValue());
                }
                case 'D': {
                    return this.cloneExtendD(type, form, (Double)x);
                }
            }
        }
        catch (Throwable t) {
            throw MethodHandleStatics.newInternalError(t);
        }
        throw new InternalError("unexpected type: " + xtype);
    }

    @Override
    MethodHandle bindArgument(int pos, char basicType, Object value) {
        MethodType type = this.type().dropParameterTypes(pos, pos + 1);
        LambdaForm form = this.internalForm().bind(1 + pos, this.speciesData());
        return this.cloneExtend(type, form, basicType, value);
    }

    @Override
    MethodHandle dropArguments(MethodType srcType, int pos, int drops) {
        LambdaForm form = this.internalForm().addArguments(pos, srcType.parameterList().subList(pos, pos + drops));
        try {
            return this.clone(srcType, form);
        }
        catch (Throwable t) {
            throw MethodHandleStatics.newInternalError(t);
        }
    }

    @Override
    MethodHandle permuteArguments(MethodType newType, int[] reorder) {
        try {
            return this.clone(newType, this.form.permuteArguments(1, reorder, LambdaForm.basicTypes(newType.parameterList())));
        }
        catch (Throwable t) {
            throw MethodHandleStatics.newInternalError(t);
        }
    }

    static byte extensionIndex(char type) {
        int i = EXTENSION_TYPES.indexOf(type);
        if (i < 0) {
            throw new InternalError();
        }
        return (byte)i;
    }

    abstract SpeciesData speciesData();

    @Override
    final Object internalProperties() {
        return "/BMH=" + this.internalValues();
    }

    @Override
    final Object internalValues() {
        Object[] boundValues = new Object[this.speciesData().fieldCount()];
        for (int i = 0; i < boundValues.length; ++i) {
            boundValues[i] = this.arg(i);
        }
        return Arrays.asList(boundValues);
    }

    final Object arg(int i) {
        try {
            switch (this.speciesData().fieldType(i)) {
                case 'L': {
                    return this.argL(i);
                }
                case 'I': {
                    return this.argI(i);
                }
                case 'F': {
                    return Float.valueOf(this.argF(i));
                }
                case 'D': {
                    return this.argD(i);
                }
                case 'J': {
                    return this.argJ(i);
                }
            }
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        throw new InternalError("unexpected type: " + this.speciesData().types + "." + i);
    }

    final Object argL(int i) throws Throwable {
        return this.speciesData().getters[i].invokeBasic(this);
    }

    final int argI(int i) throws Throwable {
        return this.speciesData().getters[i].invokeBasic(this);
    }

    final float argF(int i) throws Throwable {
        return this.speciesData().getters[i].invokeBasic(this);
    }

    final double argD(int i) throws Throwable {
        return this.speciesData().getters[i].invokeBasic(this);
    }

    final long argJ(int i) throws Throwable {
        return this.speciesData().getters[i].invokeBasic(this);
    }

    abstract BoundMethodHandle clone(MethodType var1, LambdaForm var2) throws Throwable;

    abstract BoundMethodHandle cloneExtendL(MethodType var1, LambdaForm var2, Object var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendI(MethodType var1, LambdaForm var2, int var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendJ(MethodType var1, LambdaForm var2, long var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendF(MethodType var1, LambdaForm var2, float var3) throws Throwable;

    abstract BoundMethodHandle cloneExtendD(MethodType var1, LambdaForm var2, double var3) throws Throwable;

    @Override
    MethodHandle reinvokerTarget() {
        try {
            return (MethodHandle)this.argL(0);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    static SpeciesData getSpeciesData(String types) {
        return SpeciesData.get(types);
    }

    static class Factory {
        static final String JLO_SIG = "Ljava/lang/Object;";
        static final String JLS_SIG = "Ljava/lang/String;";
        static final String JLC_SIG = "Ljava/lang/Class;";
        static final String MH = "java/lang/invoke/MethodHandle";
        static final String MH_SIG = "Ljava/lang/invoke/MethodHandle;";
        static final String BMH = "java/lang/invoke/BoundMethodHandle";
        static final String BMH_SIG = "Ljava/lang/invoke/BoundMethodHandle;";
        static final String SPECIES_DATA = "java/lang/invoke/BoundMethodHandle$SpeciesData";
        static final String SPECIES_DATA_SIG = "Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String SPECIES_PREFIX_NAME = "Species_";
        static final String SPECIES_PREFIX_PATH = "java/lang/invoke/BoundMethodHandle$Species_";
        static final String BMHSPECIES_DATA_EWI_SIG = "(B)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String BMHSPECIES_DATA_GFC_SIG = "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String MYSPECIES_DATA_SIG = "()Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String VOID_SIG = "()V";
        static final String SIG_INCIPIT = "(Ljava/lang/invoke/MethodType;Ljava/lang/invoke/LambdaForm;";
        static final Class<?>[] TYPES = new Class[]{Object.class, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        static final String[] E_THROWABLE = new String[]{"java/lang/Throwable"};

        Factory() {
        }

        static Class<? extends BoundMethodHandle> generateConcreteBMHClass(String types) {
            ClassWriter cw = new ClassWriter(3);
            String className = SPECIES_PREFIX_PATH + types;
            String sourceFile = SPECIES_PREFIX_NAME + types;
            boolean NOT_ACC_PUBLIC = false;
            cw.visit(50, 48, className, null, BMH, null);
            cw.visitSource(sourceFile, null);
            cw.visitField(8, "SPECIES_DATA", SPECIES_DATA_SIG, null, null).visitEnd();
            for (int i = 0; i < types.length(); ++i) {
                char t = types.charAt(i);
                String fieldName = Factory.makeFieldName(types, i);
                String fieldDesc = t == 'L' ? JLO_SIG : String.valueOf(t);
                cw.visitField(16, fieldName, fieldDesc, null, null).visitEnd();
            }
            MethodVisitor mv = cw.visitMethod(0, "<init>", Factory.makeSignature(types, true), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(183, BMH, "<init>", Factory.makeSignature("", true));
            int i = 0;
            int j = 0;
            while (i < types.length()) {
                char t = types.charAt(i);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(Factory.typeLoadOp(t), j + 3);
                mv.visitFieldInsn(181, className, Factory.makeFieldName(types, i), Factory.typeSig(t));
                if (t == 'J' || t == 'D') {
                    ++j;
                }
                ++i;
                ++j;
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(16, "reinvokerTarget", "()Ljava/lang/invoke/MethodHandle;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "argL0", JLO_SIG);
            mv.visitTypeInsn(192, MH);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(16, "speciesData", MYSPECIES_DATA_SIG, null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, className, "SPECIES_DATA", SPECIES_DATA_SIG);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(16, "clone", Factory.makeSignature("", false), null, E_THROWABLE);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, className, "SPECIES_DATA", SPECIES_DATA_SIG);
            mv.visitFieldInsn(180, SPECIES_DATA, "constructor", "[Ljava/lang/invoke/MethodHandle;");
            mv.visitInsn(3);
            mv.visitInsn(50);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            Factory.emitPushFields(types, className, mv);
            mv.visitMethodInsn(182, MH, "invokeBasic", Factory.makeSignature(types, false));
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            for (Class<?> c : TYPES) {
                char t = Wrapper.basicTypeChar(c);
                mv = cw.visitMethod(16, "cloneExtend" + t, Factory.makeSignature(String.valueOf(t), false), null, E_THROWABLE);
                mv.visitCode();
                mv.visitFieldInsn(178, className, "SPECIES_DATA", SPECIES_DATA_SIG);
                int iconstInsn = 3 + BoundMethodHandle.extensionIndex(t);
                assert (iconstInsn <= 8);
                mv.visitInsn(iconstInsn);
                mv.visitMethodInsn(182, SPECIES_DATA, "extendWithIndex", BMHSPECIES_DATA_EWI_SIG);
                mv.visitFieldInsn(180, SPECIES_DATA, "constructor", "[Ljava/lang/invoke/MethodHandle;");
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                Factory.emitPushFields(types, className, mv);
                mv.visitVarInsn(Factory.typeLoadOp(t), 3);
                mv.visitMethodInsn(182, MH, "invokeBasic", Factory.makeSignature(types + t, false));
                mv.visitInsn(176);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            mv = cw.visitMethod(8, "<clinit>", VOID_SIG, null, null);
            mv.visitCode();
            mv.visitLdcInsn(types);
            mv.visitLdcInsn(Type.getObjectType(className));
            mv.visitMethodInsn(184, SPECIES_DATA, "getForClass", BMHSPECIES_DATA_GFC_SIG);
            mv.visitFieldInsn(179, className, "SPECIES_DATA", SPECIES_DATA_SIG);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            byte[] classFile = cw.toByteArray();
            InvokerBytecodeGenerator.maybeDump(className, classFile);
            Class<BoundMethodHandle> bmhClass = MethodHandleStatics.UNSAFE.defineClass(className, classFile, 0, classFile.length).asSubclass(BoundMethodHandle.class);
            MethodHandleStatics.UNSAFE.ensureClassInitialized(bmhClass);
            return bmhClass;
        }

        private static int typeLoadOp(char t) {
            switch (t) {
                case 'L': {
                    return 25;
                }
                case 'I': {
                    return 21;
                }
                case 'J': {
                    return 22;
                }
                case 'F': {
                    return 23;
                }
                case 'D': {
                    return 24;
                }
            }
            throw new InternalError("unrecognized type " + t);
        }

        private static void emitPushFields(String types, String className, MethodVisitor mv) {
            for (int i = 0; i < types.length(); ++i) {
                char tc = types.charAt(i);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, Factory.makeFieldName(types, i), Factory.typeSig(tc));
            }
        }

        static String typeSig(char t) {
            return t == 'L' ? JLO_SIG : String.valueOf(t);
        }

        private static MethodHandle makeGetter(Class<?> cbmhClass, String types, int index) {
            String fieldName = Factory.makeFieldName(types, index);
            Class<?> fieldType = Wrapper.forBasicType(types.charAt(index)).primitiveType();
            try {
                return LOOKUP.findGetter(cbmhClass, fieldName, fieldType);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        }

        static MethodHandle[] makeGetters(Class<?> cbmhClass, String types, MethodHandle[] mhs) {
            if (mhs == null) {
                mhs = new MethodHandle[types.length()];
            }
            for (int i = 0; i < mhs.length; ++i) {
                mhs[i] = Factory.makeGetter(cbmhClass, types, i);
                assert (mhs[i].internalMemberName().getDeclaringClass() == cbmhClass);
            }
            return mhs;
        }

        static MethodHandle[] makeCtors(Class<? extends BoundMethodHandle> cbmh, String types, MethodHandle[] mhs) {
            if (mhs == null) {
                mhs = new MethodHandle[]{Factory.makeCbmhCtor(cbmh, types)};
            }
            return mhs;
        }

        static SpeciesData speciesDataFromConcreteBMHClass(Class<? extends BoundMethodHandle> cbmh) {
            try {
                Field F_SPECIES_DATA = cbmh.getDeclaredField("SPECIES_DATA");
                return (SpeciesData)F_SPECIES_DATA.get(null);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }

        private static String makeFieldName(String types, int index) {
            assert (index >= 0 && index < types.length());
            return "arg" + types.charAt(index) + index;
        }

        private static String makeSignature(String types, boolean ctor) {
            StringBuilder buf = new StringBuilder(SIG_INCIPIT);
            for (char c : types.toCharArray()) {
                buf.append(Factory.typeSig(c));
            }
            return buf.append(')').append(ctor ? "V" : BMH_SIG).toString();
        }

        static MethodHandle makeCbmhCtor(Class<? extends BoundMethodHandle> cbmh, String types) {
            try {
                return Factory.linkConstructor(LOOKUP.findConstructor(cbmh, MethodType.fromMethodDescriptorString(Factory.makeSignature(types, true), null)));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | TypeNotPresentException e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        }

        private static MethodHandle linkConstructor(MethodHandle cmh) {
            LambdaForm lf = cmh.form;
            int initNameIndex = lf.names.length - 1;
            LambdaForm.Name initName = lf.names[initNameIndex];
            MemberName ctorMN = initName.function.member;
            MethodType ctorMT = ctorMN.getInvocationType();
            MethodType linkerMT = ctorMT.changeParameterType(0, BoundMethodHandle.class).appendParameterTypes(MemberName.class);
            MemberName linkerMN = new MemberName(MethodHandle.class, "linkToSpecial", linkerMT, 6);
            try {
                linkerMN = MemberName.getFactory().resolveOrFail((byte)6, linkerMN, null, NoSuchMethodException.class);
                assert (linkerMN.isStatic());
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            Object[] newArgs = Arrays.copyOf(initName.arguments, initName.arguments.length + 1);
            newArgs[newArgs.length - 1] = ctorMN;
            LambdaForm.NamedFunction nf = new LambdaForm.NamedFunction(linkerMN);
            LambdaForm.Name linkedCtor = new LambdaForm.Name(nf, newArgs);
            linkedCtor.initIndex(initNameIndex);
            lf.names[initNameIndex] = linkedCtor;
            return cmh;
        }
    }

    static class SpeciesData {
        final String types;
        final Class<? extends BoundMethodHandle> clazz;
        final MethodHandle[] constructor;
        final MethodHandle[] getters;
        final SpeciesData[] extensions;
        static final SpeciesData EMPTY = new SpeciesData("", BoundMethodHandle.class);
        private static final HashMap<String, SpeciesData> CACHE = new HashMap();
        private static final boolean INIT_DONE;

        int fieldCount() {
            return this.types.length();
        }

        char fieldType(int i) {
            return this.types.charAt(i);
        }

        public String toString() {
            return "SpeciesData[" + (this.isPlaceholder() ? "<placeholder>" : this.clazz.getSimpleName()) + ":" + this.types + "]";
        }

        LambdaForm.Name getterName(LambdaForm.Name mhName, int i) {
            MethodHandle mh = this.getters[i];
            assert (mh != null) : this + "." + i;
            return new LambdaForm.Name(mh, mhName);
        }

        private SpeciesData(String types, Class<? extends BoundMethodHandle> clazz) {
            this.types = types;
            this.clazz = clazz;
            if (!INIT_DONE) {
                this.constructor = new MethodHandle[1];
                this.getters = new MethodHandle[types.length()];
            } else {
                this.constructor = Factory.makeCtors(clazz, types, null);
                this.getters = Factory.makeGetters(clazz, types, null);
            }
            this.extensions = new SpeciesData[BoundMethodHandle.EXTENSION_TYPES.length()];
        }

        private void initForBootstrap() {
            assert (!INIT_DONE);
            if (this.constructor[0] == null) {
                Factory.makeCtors(this.clazz, this.types, this.constructor);
                Factory.makeGetters(this.clazz, this.types, this.getters);
            }
        }

        private SpeciesData(String types) {
            this.types = types;
            this.clazz = null;
            this.constructor = null;
            this.getters = null;
            this.extensions = null;
        }

        private boolean isPlaceholder() {
            return this.clazz == null;
        }

        SpeciesData extendWithType(char type) {
            byte i = BoundMethodHandle.extensionIndex(type);
            SpeciesData d = this.extensions[i];
            if (d != null) {
                return d;
            }
            this.extensions[i] = d = SpeciesData.get(this.types + type);
            return d;
        }

        SpeciesData extendWithIndex(byte index) {
            SpeciesData d = this.extensions[index];
            if (d != null) {
                return d;
            }
            this.extensions[index] = d = SpeciesData.get(this.types + BoundMethodHandle.EXTENSION_TYPES.charAt(index));
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static SpeciesData get(String types) {
            SpeciesData d = SpeciesData.lookupCache(types);
            if (!d.isPlaceholder()) {
                return d;
            }
            SpeciesData speciesData = d;
            synchronized (speciesData) {
                if (SpeciesData.lookupCache(types).isPlaceholder()) {
                    Factory.generateConcreteBMHClass(types);
                }
            }
            d = SpeciesData.lookupCache(types);
            assert (d != null && !d.isPlaceholder());
            return d;
        }

        static SpeciesData getForClass(String types, Class<? extends BoundMethodHandle> clazz) {
            return SpeciesData.updateCache(types, new SpeciesData(types, clazz));
        }

        private static synchronized SpeciesData lookupCache(String types) {
            SpeciesData d = CACHE.get(types);
            if (d != null) {
                return d;
            }
            d = new SpeciesData(types);
            assert (d.isPlaceholder());
            CACHE.put(types, d);
            return d;
        }

        private static synchronized SpeciesData updateCache(String types, SpeciesData d) {
            SpeciesData d2;
            assert ((d2 = CACHE.get(types)) == null || d2.isPlaceholder());
            assert (!d.isPlaceholder());
            CACHE.put(types, d);
            return d;
        }

        static {
            Class<BoundMethodHandle> rootCls = BoundMethodHandle.class;
            SpeciesData d0 = SPECIES_DATA;
            assert (d0 == null || d0 == SpeciesData.lookupCache("")) : d0;
            try {
                for (Class<?> c : rootCls.getDeclaredClasses()) {
                    if (!rootCls.isAssignableFrom(c)) continue;
                    Class<BoundMethodHandle> cbmh = c.asSubclass(BoundMethodHandle.class);
                    SpeciesData d = Factory.speciesDataFromConcreteBMHClass(cbmh);
                    assert (d != null) : cbmh.getName();
                    assert (d.clazz == cbmh);
                    assert (d == SpeciesData.lookupCache(d.types));
                }
            }
            catch (Throwable e) {
                throw MethodHandleStatics.newInternalError(e);
            }
            for (SpeciesData d : CACHE.values()) {
                d.initForBootstrap();
            }
            INIT_DONE = Boolean.TRUE;
        }
    }

    private static final class Species_L
    extends BoundMethodHandle {
        final Object argL0;
        static final SpeciesData SPECIES_DATA = SpeciesData.getForClass("L", Species_L.class);

        Species_L(MethodType mt, LambdaForm lf, Object argL0) {
            super(mt, lf);
            this.argL0 = argL0;
        }

        @Override
        MethodHandle reinvokerTarget() {
            return (MethodHandle)this.argL0;
        }

        @Override
        SpeciesData speciesData() {
            return SPECIES_DATA;
        }

        @Override
        final BoundMethodHandle clone(MethodType mt, LambdaForm lf) throws Throwable {
            return new Species_L(mt, lf, this.argL0);
        }

        @Override
        final BoundMethodHandle cloneExtendL(MethodType mt, LambdaForm lf, Object narg) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)0).constructor[0].invokeBasic(mt, lf, this.argL0, narg);
        }

        @Override
        final BoundMethodHandle cloneExtendI(MethodType mt, LambdaForm lf, int narg) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)1).constructor[0].invokeBasic(mt, lf, this.argL0, narg);
        }

        @Override
        final BoundMethodHandle cloneExtendJ(MethodType mt, LambdaForm lf, long narg) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)2).constructor[0].invokeBasic(mt, lf, this.argL0, narg);
        }

        @Override
        final BoundMethodHandle cloneExtendF(MethodType mt, LambdaForm lf, float narg) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)3).constructor[0].invokeBasic(mt, lf, this.argL0, narg);
        }

        @Override
        final BoundMethodHandle cloneExtendD(MethodType mt, LambdaForm lf, double narg) throws Throwable {
            return Species_L.SPECIES_DATA.extendWithIndex((byte)4).constructor[0].invokeBasic(mt, lf, this.argL0, narg);
        }
    }
}

