/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.ZStreamRef;

public class Deflater {
    private final ZStreamRef zsRef;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    private long bytesRead;
    private long bytesWritten;
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;

    public Deflater(int level, boolean nowrap) {
        this.level = level;
        this.strategy = 0;
        this.zsRef = new ZStreamRef(Deflater.init(level, 0, nowrap));
    }

    public Deflater(int level) {
        this(level, false);
    }

    public Deflater() {
        this(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.buf = b;
            this.off = off;
            this.len = len;
        }
    }

    public void setInput(byte[] b) {
        this.setInput(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            Deflater.setDictionary(this.zsRef.address(), b, off, len);
        }
    }

    public void setDictionary(byte[] b) {
        this.setDictionary(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrategy(int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            if (this.strategy != strategy) {
                this.strategy = strategy;
                this.setParams = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(int level) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException("invalid compression level");
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            if (this.level != level) {
                this.level = level;
                this.setParams = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsInput() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.len <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.finish = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.finished;
        }
    }

    public int deflate(byte[] b, int off, int len) {
        return this.deflate(b, off, len, 0);
    }

    public int deflate(byte[] b) {
        return this.deflate(b, 0, b.length, 0);
    }

    public int deflate(byte[] b, int off, int len, int flush) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            if (flush == 0 || flush == 2 || flush == 3) {
                int thisLen = this.len;
                int n = this.deflateBytes(this.zsRef.address(), b, off, len, flush);
                this.bytesWritten += (long)n;
                this.bytesRead += (long)(thisLen - this.len);
                return n;
            }
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdler() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return Deflater.getAdler(this.zsRef.address());
        }
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return this.bytesRead;
        }
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            Deflater.reset(this.zsRef.address());
            this.finish = false;
            this.finished = false;
            this.len = 0;
            this.off = 0;
            this.bytesWritten = 0L;
            this.bytesRead = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            long addr = this.zsRef.address();
            this.zsRef.clear();
            if (addr != 0L) {
                Deflater.end(addr);
                this.buf = null;
            }
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        assert (Thread.holdsLock(this.zsRef));
        if (this.zsRef.address() == 0L) {
            throw new NullPointerException("Deflater has been closed");
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, boolean var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytes(long var1, byte[] var3, int var4, int var5, int var6);

    private static native int getAdler(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        Deflater.initIDs();
    }
}

