/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public final class PosixFilePermissions {
    private PosixFilePermissions() {
    }

    private static void writeBits(StringBuilder sb, boolean r, boolean w, boolean x) {
        if (r) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if (w) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if (x) {
            sb.append('x');
        } else {
            sb.append('-');
        }
    }

    public static String toString(Set<PosixFilePermission> perms) {
        StringBuilder sb = new StringBuilder(9);
        PosixFilePermissions.writeBits(sb, perms.contains((Object)PosixFilePermission.OWNER_READ), perms.contains((Object)PosixFilePermission.OWNER_WRITE), perms.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        PosixFilePermissions.writeBits(sb, perms.contains((Object)PosixFilePermission.GROUP_READ), perms.contains((Object)PosixFilePermission.GROUP_WRITE), perms.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        PosixFilePermissions.writeBits(sb, perms.contains((Object)PosixFilePermission.OTHERS_READ), perms.contains((Object)PosixFilePermission.OTHERS_WRITE), perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        return sb.toString();
    }

    private static boolean isSet(char c, char setValue) {
        if (c == setValue) {
            return true;
        }
        if (c == '-') {
            return false;
        }
        throw new IllegalArgumentException("Invalid mode");
    }

    private static boolean isR(char c) {
        return PosixFilePermissions.isSet(c, 'r');
    }

    private static boolean isW(char c) {
        return PosixFilePermissions.isSet(c, 'w');
    }

    private static boolean isX(char c) {
        return PosixFilePermissions.isSet(c, 'x');
    }

    public static Set<PosixFilePermission> fromString(String perms) {
        if (perms.length() != 9) {
            throw new IllegalArgumentException("Invalid mode");
        }
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if (PosixFilePermissions.isR(perms.charAt(0))) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if (PosixFilePermissions.isW(perms.charAt(1))) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if (PosixFilePermissions.isX(perms.charAt(2))) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (PosixFilePermissions.isR(perms.charAt(3))) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if (PosixFilePermissions.isW(perms.charAt(4))) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if (PosixFilePermissions.isX(perms.charAt(5))) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (PosixFilePermissions.isR(perms.charAt(6))) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if (PosixFilePermissions.isW(perms.charAt(7))) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (PosixFilePermissions.isX(perms.charAt(8))) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public static FileAttribute<Set<PosixFilePermission>> asFileAttribute(Set<PosixFilePermission> perms) {
        perms = new HashSet<PosixFilePermission>(perms);
        for (PosixFilePermission p : perms) {
            if (p != null) continue;
            throw new NullPointerException();
        }
        final Set<PosixFilePermission> value = perms;
        return new FileAttribute<Set<PosixFilePermission>>(){

            @Override
            public String name() {
                return "posix:permissions";
            }

            @Override
            public Set<PosixFilePermission> value() {
                return Collections.unmodifiableSet(value);
            }
        };
    }
}

